# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
#
###########################################################################
from tempfile import mkstemp
from os import listdir, mkdir, unlink, close
from os.path import isdir, join, isfile
from string import ascii_letters
from urllib import unquote
from twisted.python import log

from horus import aaf
from ead2.backend.lib.action import Action, Dict, Text
from ead2.backend.actions import tools
from ead2.backend.config.config import TEMP_DIR

used_templates = ['main', 'formselect', 'form']

def comes_from_windows(filename):
    """ renvoie true si le filename est de type windows (avec \ au lieu de /)
    """
    ## FIXME : cela s'améliore peut être
    for char in ascii_letters:
        if filename.startswith(char+":\\"):
            return True
    return False

class ExtractionAAF(Action):
    """ outils d'importation aaf
    """
    user_description = Dict(default={}, doc="description de l'éxécutant",
                            keys=['ip', 'name', 'role'])
    name = 'extraction_aaf'
    libelle = "Importation AAF"
    category = "Outils/"
    description = "Extraire une base d'utilisateurs"
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'fichier', 'filename',
                         'options', 'nomdefichier'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
                       keys=['password'])
    filename = Text(default='', doc="Nom du fichier devoir temporaire")

    def execute(self):
        """ renvoie les données pour la mise en forme de l'action
            1 - envoi d'un formulaire de téléchargement de fichier et d'un formulaire d'options
            2 - écrire le fichier
            3 - lancer l'importation
        """
        self.params, self.server_nb = tools.get_request(self.request)
        ## 2 -
        if self.params.has_key('fichier'):
            try:
                datas = self._write_files()
                datas['toexec'] = self._get_jstoexec_for_filelist()
            except Exception, mess:
                log.err()
                datas = dict(message = mess.message)
            return self.send_frag(datas, template='horus_extraction_aaf',
                                  templates=used_templates)
        ## 3 -
        if self.form_result != {}:
            try:
                datas = self.lance_extraction()
            except Exception, mess:
                log.err()
                datas = dict(message = mess.message)
            # FIXME : fix sur appels infinis !
            self.form_result = {}
            return self.send_frag(datas, template='horus_extraction_aaf',
                                  templates=used_templates)
        ## 1 -
        result = {'titre':self.libelle}
        result.update(self._get_file_form())
        result.update(self._get_file())
        result.update(self._get_options_form())
        return self.send_all(result, template='horus_extraction_aaf',
                             templates=used_templates)

    def _get_file_form(self):
        """ renvoie la description du formulaire de téléchargement de fichier AAF"""
        aaf_entete = "Etape 1: Téléchargement de la base"
        aaf_xml_download_path = "./file_download/?server=%s&action=%s&filename=fichier" % (self.server_nb, self.name)
        return dict(aaf_xml_download_path=aaf_xml_download_path, aaf_entete=aaf_entete)

    def _get_file(self):
        """ renvoie le nom d'un fichier si il y en a un de téléchargé """
        login = self.user_description['name']
        tempdir = join(TEMP_DIR, login)
        if isdir(tempdir):
            downloaded_file = ""
            for f_name in listdir(tempdir):
                if f_name.startswith('aaf'):
                    self.filename = join(tempdir, f_name)
                    downloaded_file += "Un fichier a été téléchargé sous le nom de %s" % f_name
                elif f_name.startswith('report'):
                    downloaded_file += "Un rapport d'importation a été trouvé sous le nom de %s" % f_name
            if listdir(tempdir) != []:
                return dict(downloaded_file=downloaded_file)
        return dict()

    def _get_options_form(self):
        """ renvoie la description du formulaire d'options """
        radios_entete = "Etape 2: Génération des mots de passe"
#        radios_libelle = ['
        radio_date = {'name':'password', 'libelle':'Utiliser la date de naissance',
                                'value':'1', 'checked':'ok', 'inline':'ok'}
        radio_random = {'name':'password',
                    'libelle':'Utiliser un mot de passe généré aléatoirement',
                    'value':'2', 'inline':'ok'}
        return dict(radios_entete=radios_entete, radio_date=radio_date,
                    radio_random=radio_random, validate=self._get_validate_btn())

    def _write_files(self):
        """ écrit le fichier xml temporaire pour l'importation """
        login = self.user_description['name']
        datas = unquote(self.params['fichier'][0])
        if not isdir(join(TEMP_DIR, login)):
            mkdir(join(TEMP_DIR, login))
        else:
            if listdir(join(TEMP_DIR, login)) != []:
                for f_name in listdir(join(TEMP_DIR, login)):
                    if f_name.startswith('aaf'):
                        unlink(join(TEMP_DIR, login, f_name))
        fd, tempfilename = mkstemp('.xml', 'aaf_', join(TEMP_DIR, login))
        if datas.strip() == '':
            raise Exception, "Erreur: le fichier téléchargé est vide."
        f = file(tempfilename, 'w')
        f.write(datas)
        f.close()
        close(fd)
        self.filename = tempfilename
        return dict(message="Votre fichier a été écrit dans %s" % tempfilename)

    def lance_extraction(self):
        """ lance l'importation AAF"""
        if not self.form_result.has_key('password'):
            raise Exception, "L'importation ne peut être lancée"
        if self.filename == '' or not isfile(self.filename):
            raise Exception, "Veuillez télécharger un (nouveau) fichier XML\\npour l'importation."
        datas = tools.format_form_result(self.form_result['password'])
        password_type = datas['password']
        log.msg("Importation depuis le fichier %s avec mot de passe de type %s" % (self.filename, password_type))
        msg = ''
        lines = aaf.parse_xml_file(self.filename, password_type)
        if len(lines) < 25:
            for a in lines:
                msg += "%s\\n" % a
        else:
            for a in lines:
                msg += "%s\n" % a
            login = self.user_description['name']
            if not isdir(join(TEMP_DIR, login)):
                mkdir(join(TEMP_DIR, login))
            fd, tempfilename = mkstemp('.txt', 'report_', join(TEMP_DIR, login))
            f = file(tempfilename, 'w')
            f.write(msg)
            f.close()
            close(fd)
            msg = "Le rapport de l'importation que vous venez d'effectuer est stocké dans %s." % tempfilename
        unlink(self.filename)
        return dict(message=msg)

    def _get_validate_btn(self):
        """ renvoie la description du bouton valider """
        href = tools.make_long_form_link(self.server_nb, self.name,
                                         True, ['password'],
                                         balise='div_msg_container')
        title = "lancer l'importation"
        libelle = "Lancer l'importation"
        icone = "/image/ok.gif"
        _class = 'btn'
        return dict(href=href, title=title, libelle=libelle, icone=icone, _class=_class)

    def _get_jstoexec_for_filelist(self):
        """ renvoie le lien javascript à utiliser pour rafraichir
            la page depuis une iframe de téléchargement
        """
        toexec = "window.parent.document.getElementById('aaf_downloaded_file').innerHTML = \"%s\";"
        f_name = self._get_file().get('downloaded_file', '')
        return toexec % f_name
