# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    Classe de base pour l'importation
"""
from twisted.python import log

from scribe.importation import log as importlog

from ead2.backend.actions.lib.main import Main
from ead2.backend.actions.lib.widgets import main as M, ajax

class BaseImportation(Main):
    """
        classe de base pour l'importation
    """
    # templates utilisés
    template = 'scribe_extraction'
    widget_templates = ['main', 'form', 'formselect']

    def main(self, return_dict):
        """
            renvoie les informations
        """
        log.msg("On renvoie")
        return self.send_all(return_dict,
                             template=self.template,
                             templates=self.widget_templates)

    def send_error(self, error, message=None):
        """
            Lancé en cas d'erreur dans l'éxécution
        """
        if not message:
            message = error.getErrorMessage()
            log.msg(error.getErrorMessage())
        return_dict = dict(message=message)
        return self.send_all(return_dict,
                             template=self.template,
                             templates=self.widget_templates)

    def _get_bouton_retour(self, step=0):
        """
            Renvoie le bouton de retour arrière
        """
        import_type = self.params.get('import_type', [None])[0]
        data_type = self.params.get('data_type', [None])[0]
        category_type = self.params.get('category_type', [None])[0]
        if step == 0:
            actionname = 'scribe_extraction'
            args = {}
        elif step == 1:
            actionname = 'scribe_extraction'
            args = dict(import_type=import_type)
        elif step == 2:
            actionname = 'scribe_extraction'
            args = dict(import_type=import_type,
                        data_type=data_type)
        elif step == 3:
            actionname = 'scribe_extraction_preferences'
            args = dict(import_type=import_type,
                        data_type=data_type,
                        category_type=category_type)
        elif step == 4:
            actionname = self.name
            args = dict(import_type=import_type,
                        data_type=data_type,
                        category_type=category_type)
        else:
            actionname = 'scribe_extraction'
            args = {}
        icone = 'image/back.png'
        _class = 'simple_link'
        title = "Revenir à l'étape précédente"
        href = ajax.call(self.server_nb,
                         actionname,
                         **args)
        return dict(bouton_retour = M.Bouton(href=href,
                                             icone=icone,
                                             _class=_class,
                                             title=title))

    def _test_lock(self, return_dict):
        """
            Teste les verrous pour l'importation
        """
        importlog.test_lock()
        return return_dict

    def _err_lock(self, error):
        """
            Errback pour la présence de lock
        """
        try:
            message = error.getErrorMessage()
            message = message.replace('"', '\\"')
        except:
            message = "Erreur de lock"
        toexec = ajax.call(self.server_nb,
                           'main_status',
                           only=True)
        return dict(message=message,
                    toexec=toexec)

