# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Données pour la mise en forme de données de formulaire
#
###########################################################################

from base import Base
import main as M
import ajax

js_controls = {'number':"testNumber('%s', 'error_%s');",
               'ip':"testIp('%s', 'error_%s');",
               'required':"testVoid('%s', 'error_%s');",
               'netmask':"testNetMask('%s', 'error_%s');",}

class Input(Base):
    model = 'input'
    def __init__(self, name, libelle='', default=None, js=None, inline=False, \
                       _id=None, disabled=False, required=False, _type=None):
        """
            name: name de l'input (clé du dico utilisé à la validation)
            libelle: libellé
            default_value: valeur par défaut,
            js: script javascript éxécuté au changement de focus et à la validation,
            inline:libelle et input en ligne,
            id:si on veut un id sur le select (inutil si on a un onblur),
            disabled: si on veut empecher l'edition
            required: argument requis (ajoute la fonction js qui va bien)
        """
        self['name'] = name
        self['libelle'] = libelle
        self['model'] = self.model
        if default != None:
            self['default_value'] = default
        if js != None:
            self.js(js)
        elif required:
            self.js(js_controls['required'] % (name, name))
        elif _type in js_controls.keys():
            self.js(js_controls[_type] % (name, name))

        if inline:
            self['inline'] = 'ok'
        if _id != None:
            self['id'] = _id
        if disabled:
            self['disabled'] = 'ok'

    def js(self, js):
        """ ajoute une fonction de test de variable """
        self['onblur'] = js

    def default(self, default):
        self['default_value'] = default

    def disable(self):
        self['disabled'] = 'ok'

class Checkbox(Base):
    model = 'radio'
    def __init__(self, name, libelle='', value=None, checked=False, \
                       inline=False, disabled=False, onchange=None):
        """
            libelle:libelle,
            name:id de la checkbox,
            value:valeur,
            checked:checker par defaut?,
            inline:libelle et input en ligne,
            disabled:desactiver,
            onchange:js exec au changement
        """
        self['name'] = name
        self['libelle'] = libelle
        self['model'] = self.model
        if value:
            self['value'] = value
        else:
            self['value'] = name
        if checked:
            self['checked'] = 'ok'
        if inline:
            self['inline'] = "ok"
        if disabled:
            self['disabled'] = 'ok'
        if onchange:
            self.js(onchange)

    def check(self):
        self['checked'] = 'ok'

    def js(self, js):
        self['onchange'] = js

class Radio(Checkbox):
    """ bouton radio """
    model = 'radio'

class Select(Base):
    """
        outil de gestion des données pour la mise en forme
        d'une balise select
    """
    model = 'select'
    def __init__(self, name, libelle=None, _id=None, onchange=None, \
              inline=False, disabled=False, multi=False, size=None):
        """
            :name: id de la balise
            :options: liste de groupe d"option de type : {"name":nom du groupe,
                 "options":[{"name":id,
                             "libelle": pour affichage,
                             "default":si c"est la val par defaut}...]}
            :multi: si oui on a des selections multiples
            :onchange: fonction js pour si on change
            :libelle: si on en veut un
            :inline: en ligne si remplit
            :id: si on veut un id sur le select (inutil si on a un onchange)
            :size : si on veut definir lattribut size
            :disabled : si on veut empecher l' edition
        """
        self['name'] = name
        self['model'] = self.model
        if libelle:
            self['libelle'] = libelle
        if _id:
            self['id'] = _id
        if onchange:
            self['onchange'] = onchange
        if inline:
            self['inline'] = 'ok'
        if disabled:
            self['disabled'] = 'ok'
        if multi:
            self['multi'] = 'ok'
        if size:
            self['size'] = size
        self['options'] = []

    def add_option(self, value, libelle='', default=None, group=None):
        """
        rajoute une option à la balise select
        """
        option = {'value':value, 'name':value}
        if default: option['default'] = 'ok'
        if libelle: option['libelle'] = libelle
        else: option['libelle'] = value
        if not group:
            if len(self['options']):
                self['options'][0]['options'].append(option)
            else:
                self['options'].append({'name':'', 'options':[option]})
        else:
            currentgroup = None
            for optgroup in self['options'] :
                if optgroup['name'] == group:
                    currentgroup = optgroup
            if currentgroup:
                currentgroup['options'].append(option)
            else:
                self['options'].append({'name':group, 'options':[option]})

    def default(self, value, group=""):
        """
            Met une option à une valeur par défaut
        """
        for optgroup in self['options']:
            if optgroup['name'] == group:
                for option in optgroup['options']:
                    if option['name'] == value:
                        option['default'] = 'ok'
                        break
                break

class ListList(Base):
    """
        Renvoie un outil de transfert de liste à liste
        {'title':Titre du tableau
         'left':{'title':titre de la colonne,
                 'form':formname,
                 'datas':[{'name':item,
                           'libelle':facultatif,
                           'disabled':facultatif}...]},
         'right':{'title':titre de la colonne,
                 'form':formname,
                 'datas':[{'name':item}...]},
          'name': nom html du container,
          'btns':[{Des boutons}]
        }
    """
    model = 'listlist'
    def __init__(self, title='', container='', direction=True):
        """
            title:titre du tableau
            container: nom du tableau
            direction: droite vers gauche ou gauche vers droite
        """
        self['model'] = self.model
        if title:
            self['title'] = title
        if container:
            self['name'] = container
        self['left'] = dict(title='',
                            datas=[],
                            form=''
                            )
        self['right'] = dict(title='',
                             datas=[],
                             form='')
        self['btns'] = list()
        self.direction = direction

    def set_title(self, side, title=""):
        """
            définit le titre du tableau côté 'side'
        """
        self[side]['title'] = title

    def set_formname(self, side, formname=""):
        """
            définit le nom du formulaire du côté 'side'
        """
        self[side]['form'] = formname

    def add_item(self, side, item={'name':''}):
        """
            ajoute un élement dans la liste side
            side : left/right
            item: {'name':.., 'libelle':facultatif, disabled:facultatif}
        """
        if type(item) == dict and item.has_key('name'):
            self[side]['datas'].append(item)
        else:
            raise Exception, "Erreur de format d'item dans la méthode add_item"

    def add_btns(self):
        """
            Ajoute les boutons de transfert
        """
        self.get_lr_btn()
        self.get_rl_btn()

    def get_lr_btn(self):
        """
            renvoie la description du bouton de transfert de gauche à droite
        """
        href = ajax.transfer(self['left']['form'], "%s_table" % (
                                                    self['right']['form'],))
        if self.direction:
            icone = "/image/leftright.png"
            libelle = "Ajouter"
        else:
            icone = "/image/leftright_red.png"
            libelle = "Retirer"
        self['btns'].append(M.Bouton(href=href, libelle=libelle, icone=icone))

    def get_rl_btn(self):
        """
            renvoie la description du bouton de transfert de droite à gauche
        """
        href = ajax.transfer(self['right']['form'], "%s_table" % (
                                            self['left']['form'],))
        if self.direction:
            icone = "/image/rightleft_red.png"
            libelle = "Retirer"
        else:
            icone = "/image/rightleft.png"
            libelle = "Ajouter"
        self['btns'].append( M.Bouton(href=href, libelle=libelle, icone=icone))


class Form(Base):
    """
        Objet formulaire, pensez à importer le template .tmpl form_gen
        dans le template de mise en forme de l'action
    """
    def  __init__(self, name):
        self['name'] = name
        self['balise'] = []
        self['submit'] = None

    def add_balise(self, balise):
        """
            ajoute une balise dans le formulaire
            @balise: objet dico
        """
        self['balise'].append(balise)

    def add_input(self, name, **params):
        """
            ajoute un input dans le formulaire
        """
        self.add_balise(Input(name, **params))

    def add_checkbox(self, name, **params):
        """
            ajoute une checkbox dans le formulaire
        """
        self.add_balise(Checkbox(name, **params))

    def add_select(self, name, **params):
        """
            ajoute un bouton select dans le formulaire
        """
        self.add_balise(Select(name, **params))

    def add_radio(self, name, **params):
        """
            ajoute un bouton radio dans le formulaire
        """
        self.add_balise(Radio(name, **params))

    def add_submit(self, server_nb, actionname, return_container=None, **params):
        """
            Ajoute un bouton submit à notre formulaire
            @server_nb: numéro du serveur à traiter
            @actionname: nom de l'action à appeler avec le résultat
                        du formulaire
            @return_container: id html de la balise de réception du résultat
            @params : paramètres à passer à l'action que l'on appelle en
                 parrallèle de la validation de formulaire
        """
        href = ajax.valid(server_nb,
                           actionname,
                           formnames=[self['name']],
                           container=return_container,
                           **params)
        self['submit'] = M.Submit(href)

class Download(dict):
    """
        Formulaire de téléchargement de fichier
        format sortant :
    """
    action_template = "./file_download/?server=%s&filename=%s&action=%s"
    onsubmit_template = """return ajaxIframe.submit(this,\
{'onStart':startCallback,'onComplete':getCompleteCallback('%s')},\
'%s', '%s', '%s');"""
#    form_template = """<table style='width:100%%'><tr><td>%(libelle)s</td><td> \
#<form onsubmit=\"%(submit)s\" action=\"%(action)s\" \
#enctype='multipart/form-data' method='post'> \
#<input type='hidden' name='nomdefichier' id='%(nomdefichier)s'/> \
#<input type='file' name='%(fichier)s' id='%(fichier)s'/> \
#<input type='submit'/> \
#</form><div id='%(container)s'></div><div id='%(msg_container)s'></div></td> \
#</tr></table>"""

    def __init__(self, server_nb, actionname, fichier="fichier",
                                     nomdefichier='nomdefichier', libelle="Téléchargement"):
        dict.__init__(self, fichier=fichier,
                            nomdefichier="nomdefichier_%s" % fichier,
                            container = 'container_%s' % fichier,
                            msg_container = 'msg_container_%s' % fichier,
                            libelle=libelle)
        self.server_nb = server_nb
        self.actionname = actionname
        self.make_action_link()
        self.make_submit_link()

    def make_action_link(self):
        """
            Construit le lien d'action
        """
        self['action'] = self.action_template % (self.server_nb,
                                                 self['fichier'],
                                                 self.actionname)

    def make_submit_link(self):
        """
            Construit le lien javascript de validation
        """
        self['submit'] = self.onsubmit_template % (self['msg_container'],
                                                   self['fichier'],
                                                   self['nomdefichier'],
                                                   self['container'])

#    def render(self):
#        """
#            Renvoie le code html
#        """
#        return self.form_template % self
