# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

""" librairie de données de mise en forme
    pour les formulaires de configuration
"""
from twisted.python import log
from os.path import isfile

from amon.dansguardian import dans_tools
from amon.dansguardian.config import dans_status

from ead2.backend.actions.amon import amon_tools as t
from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import main as M, form as F
from ead2.backend.config.filenames import navigation_filters

list_mime_filename = navigation_filters['list_mime']


zone_indices = {'pedago':1, 'admin':0}
zone_msg = {'pedago':t.get_zone_libelle('2').lower(),
            'admin':t.get_zone_libelle('1').lower()}

list_msg = {'whitelist':'liste des domaines autorisés',
            'blacklist':'liste des domaines interdits',
            'extension':'liste des extensions interdites',
            'mime':'liste des types MIME interdits',
           }

def parse_mimes():
    """ parse les types mimes et renvoie 2 listes de dico
        {'name':nom de l'option, 'libelle':libelle de l'option'}
        les types disponibles et ceux déjà interdits
    """
    all_mimes = t.get_lines(list_mime_filename)
    available_mime = []

    for mime in all_mimes:
        mime = mime.split(';')
        libelle = mime[0].strip()
        if len(mime)>=3:
            if mime[2].strip():
                libelle += " (%s)" % mime[2]
        name = mime[1].strip()
        available_mime.append({'name':name, 'libelle':libelle})
    return available_mime

def get_mime_libelle(mimetype):
    """renvoie le libellé du type mime mimetype """
    all_mimes = t.get_lines(list_mime_filename)
    for mime in all_mimes:
        mime = mime.split(';')
        libelle = mime[0].strip()
        if len(mime)>=3:
            if mime[2].strip():
                libelle += " (%s)" % mime[2]
        name = mime[1].strip()
        if mimetype == name:
            return libelle
    return "Le type mime %s" % mimetype

##########       FORMULAIRE
def get_all_select_btn(form, root):
    """ renvoie la description pour les boutons 'Tous'
        @form: id du formulaire
        @root: racine (partie commune) du nom des balises à checker
    """
    return  M.Lien(href="javascript:formSelectAll('%s', '%s')" % (form, root),
                   libelle='tous',
                   _class='amon_simple_link')

def get_none_select_btn(form, root):
    """ renvoie la description pour les boutons 'Aucun'
        @form: id du formulaire
        @root: racine (partie commune) du nom des balises à checker
    """
    return M.Lien(href="javascript:formSelectNone('%s', '%s')" % (form, root),
                  libelle='aucun',
                  _class='amon_simple_link')

def get_opt_filters_form(zone):
    """ renvoie la description du formulaire d'édition des filtres optionnels
    """
    # boutons de selection Tous-Aucun
    columns = []
    for i, libelle in enumerate(dans_tools.columns_libelle):
        all_active_btn = get_all_select_btn('opt_filters_form',
                            dans_tools.option_and_index_to_name('', i))

        all_unactive_btn = get_none_select_btn('opt_filters_form',
                            dans_tools.option_and_index_to_name('', i))
        columns.append((libelle,
                        all_active_btn,
                        all_unactive_btn))

    # checkboxes
    options = t.get_filtres_options()
    optionnal_filters = []
    if not options:
        return dict()
    else:
        user_checked_opts = dans_tools.load_category_list(
                                    zone=zone_indices[zone])
        for option in options:
            description = option['libelle']
            checkbox = {}  # Clef = column, valeur = dico.

            for index, column in enumerate(dans_tools.columns_libelle):
                opt_name = option['name']
                name = dans_tools.option_and_index_to_name(opt_name, index)
                checkbox[column] = F.Checkbox(name=name, value='actif')
                if user_checked_opts[opt_name][index]:
                    checkbox[column].check()

            optionnal_filters.append((description, checkbox))
        return dict(optionnal_filters=optionnal_filters,
                        columns=columns)

def get_filtrage_form(zone):
    """
        renvoie la description du formulaire de gestion du filtrage syntaxique
    """
    def get_dans_status(zone):
        if isfile(dans_status % zone):
            return file(dans_status % zone).read()
        else:
            # la valeur par defaut dans les templates
            return '1'

    desactives = F.Radio(name='dans', value='off')
    metas = F.Radio(name='dans', value='meta')
    actives = F.Radio(name='dans', value='on')
    if '0' in get_dans_status(zone_indices[zone]):
        desactives.check()
    elif '2' in get_dans_status(zone_indices[zone]):
        actives.check()
    else:
        metas.check()

    desactive = ('Désactivé', desactives)
    meta = ("Sur les entêtes de pages WEB (recommandé)", metas)
    active = ('Sur la totalité de la page', actives)
    return dict(filtrage_radios=(desactive, meta, active))

def _get_column_checkboxes():
    """
        renvoie la description des checkboxs
    """
    checkboxes = []
    for index, column in enumerate(dans_tools.columns_list):
        checkbox = F.Checkbox(name=column,
                              libelle=dans_tools.columns_libelle[index],
                              checked=True)
        checkboxes.append(checkbox)
    return checkboxes

def get_blacklist_form(zone):
    """
        renvoie la description du formulaire de gestion des domaines interdits
    """
    sitelist_site = F.Input(name='addsite',
             libelle="Veuillez entrer un nom de domaine à interdire",
             required=True)
    return dict(sitelist_site=sitelist_site,
                checkboxes=_get_column_checkboxes())


def get_whitelist_form(zone):
    """
        renvoie la description du formulaire de gestion des domaines autorisés
    """
    sitelist_site = F.Input(name='addsite',
            libelle="Veuillez entrer un nom de domaine à autoriser",
            required=True)
    return dict(sitelist_site=sitelist_site,
                checkboxes=_get_column_checkboxes())

def get_extension_form(zone):
    """ renvoie la description du formulaire de gestion des extensions """
    extension = F.Input(name='addextension',
            libelle="Veuillez entrer l'extension à interdire",
            required=True)
    return dict(extension=extension,
                checkboxes=_get_column_checkboxes())

def get_mime_form(zone):
    """ renvoie la description du formulaire de gestion des types mime """
    available_mimes = parse_mimes()
    mime_name = F.Select(name='addmime',
                         _id='addmime',
                         libelle="Veuillez choisir le type MIME à interdire",)
    for opt in available_mimes:
        mime_name.add_option(value=opt['name'], libelle=opt['libelle'])
    return dict(mime_name=mime_name,
                checkboxes=_get_column_checkboxes())

def get_listed(zone, keyword='blacklist'):
    """ renvoie les données pour la liste des sites autorisés/interdits """
    sites = dans_tools.load_site_list(keyword=keyword, zone=zone_indices[zone])
    keys = sites.keys()
    keys.sort()

    listed = []
    site_names = []
    for site in keys:
        checkbox = {}
        for index, column in enumerate(dans_tools.columns_libelle):
            name = dans_tools.option_and_index_to_name(site, index)
            checkbox[column] = F.Checkbox(name=name, value='actif')
            if sites[site][index]:
                checkbox[column].check()
        if len(dans_tools.columns_libelle) > 1:
            active = get_all_select_btn('site_table', site)
            unactive = get_none_select_btn('site_table', site)
            listed.append((site, checkbox, active, unactive))
        else:
            listed.append((site, checkbox))
        hidden_input = F.Input(name=site, default=site)
        site_names.append(hidden_input)


    if listed == []:
        listed = "Aucun domaine n'a été placé sur la %s." % list_msg[keyword]
    entete = "Modifier la %s." % list_msg[keyword]

    return dict(entete=entete,
                site_table=listed,
                site_names=site_names,
                columns=dans_tools.columns_libelle)


def get_forbidden_extension(zone):
    """ renvoie les données pour la mise en forme du formulaire
        de modification des listes locales d'extensions interdites
    """
    exts = dans_tools.load_site_list(keyword='extension', zone=zone_indices[zone])
    keys = exts.keys()
    keys.sort()

    ext_table = []
    ext_names = []
    for ext in keys:
        checkbox = {}
        for index, column in enumerate(dans_tools.columns_libelle):
            name = dans_tools.option_and_index_to_name(ext, index)
            checkbox[column] = F.Checkbox(name=name, value='actif')
            if exts[ext][index]:
                checkbox[column].check()

        if len(dans_tools.columns_libelle) > 1:
            active = get_all_select_btn('ext_table', ext)
            unactive = get_none_select_btn('ext_table', ext)
            ext_table.append((ext, checkbox, active, unactive))
        else:
            ext_table.append((ext, checkbox))
        hidden_input = F.Input(name=ext, default=ext)
        ext_names.append(hidden_input)

    if ext_table == []:
        ext_table = "Aucune extension n'a été placée sur la %s." % list_msg['extension']
    return dict(entete="Modifier la %s" % list_msg['extension'],
                ext_table=ext_table,
                ext_names=ext_names,
                columns = dans_tools.columns_libelle)

def get_forbidden_mimes(zone):
    """ renvoie les données pour la mise en forme du formulaire
        de modification des types mime
    """
    mimes = dans_tools.load_site_list(keyword='mime', zone=zone_indices[zone])
    keys = mimes.keys()
    keys.sort()

    mime_table = []
    mime_names = []
    for mime in keys:
        checkbox = {}
        for index, column in enumerate(dans_tools.columns_libelle):
            name = dans_tools.option_and_index_to_name(mime, index)
            checkbox[column] = F.Checkbox(name=name, value='actif')
            if mimes[mime][index]:
                checkbox[column].check()

        if len(dans_tools.columns_libelle) > 1:
            active = get_all_select_btn('mime_table', mime)
            unactive = get_none_select_btn('mime_table', mime)
            mime_table.append((get_mime_libelle(mime), checkbox, active, unactive))
        else:
            mime_table.append((get_mime_libelle(mime), checkbox))

        hidden_input = F.Input(name=mime, default=mime)
        mime_names.append(hidden_input)
    if mime_table == []:
        mime_table = "Aucun type mime n'a été placé sur la %s." % list_msg['mime']
    return dict(entete="Modifier la %s." % list_msg['mime'],
                mime_table=mime_table,
                mime_names= mime_names,
                columns = dans_tools.columns_libelle)

#################  VALIDATION

def valid_opt_filters_form(form_result, zone):
    """ valide l'activation de filtres optionnels """
    resultat = tools.format_form_result(form_result, True)
    options = t.get_filtres_options()
    user_opts = {}
    for option in options:
        opt_name = option['name']
        user_opt = [0 for i in dans_tools.columns_list]
        for index, policy in enumerate(dans_tools.columns_list):
            user_opt_name = dans_tools.option_and_index_to_name(opt_name,
                                                                    index)
            if resultat[user_opt_name]:
                user_opt[index] = 1
        user_opts[opt_name] = user_opt
    dans_tools.save_category_list(user_opts,
                                  'filtres_opt',
                                  zone=zone_indices[zone])

    message = "La configuration du filtrage syntaxique a été modifiée."
    if dans_tools.reload():
        message += "\\nLe filtre a bien été rechargé."
    else:
        log.err("Erreur au lancement de /etc/init.d/dansguardian reload(2) dans forms.py")
    return dict(message=message)

def valid_filtrage_form(form_result, zone):
    """ valide la configuration du filtrage web
    """
    def save_dans_status(status, zone):
        status_f = file(dans_status%zone_indices[zone], 'w')
        status_f.write(status)
        status_f.close()

    resultat = tools.format_form_result(form_result)
    log.msg(resultat)

    status = resultat['dans']
    dans_tools.set_filtrage(zone_indices[zone], status)
    if status == 'meta':
        save_dans_status('1', zone)
        message = "Le filtrage de la navigation web sur le {0} \
s'effectue sur les entêtes de page web.".format(zone_msg[zone])
    elif status == 'on':
        save_dans_status('2', zone)
        message = "Le filtrage de la navigation web sur le {0} \
s'effectue désormais sur l'intégralité de la page.".format(zone_msg[zone])
    else:
        save_dans_status('0', zone)
        message = "Le filtrage syntaxique de la navigation web sur \
le {0} est désactivé.".format(zone_msg[zone])

    if dans_tools.reload():
        message += "\\nLe filtre a bien été rechargé."
    else:
        log.err("Erreur au lancement de /etc/init.d/dansguardian reload(2) dans forms.py")
    return dict(message=message)

def valid_sitelist_form(form_result, zone, keyword):
    """
        valide le formulaire d'ajout de site
        à la liste des sites interdits/autorisés
    """
    resultat = tools.format_form_result(form_result, True)
    log.msg("Ajout d'un site %s : %s" % (keyword, resultat['addsite']))
    site = t.format_url(resultat['addsite'])

    # caractères interdits dans les adresses à filter
    for char in ('%', '"', "'"):
        if char in site:
            raise Exception("""Erreur :\\nLe caractère %s n'est pas autorisé dans les adresses""" % char)

    # on vérifie si le site est pas déjà interdit/autorisé
    antilisted = [0 for i in dans_tools.columns_list]

    if keyword == 'whitelist':
        antikeyword = 'blacklist'
        if site in dans_tools.load_site_list(antikeyword,
                                             zone_indices[zone]).keys():
            antilisted = dans_tools.load_site_list(antikeyword,
                                                   zone_indices[zone])[site]
    else:
        antikeyword = 'whitelist'
        if site in dans_tools.load_site_list(antikeyword,
                                             zone_indices[zone]).keys():
            antilisted = dans_tools.load_site_list(antikeyword,
                                                   zone_indices[zone])[site]


    listed = dans_tools.load_site_list(keyword, zone_indices[zone])

    if site in listed.keys():
        policies_checked = listed[site]
    else:
        policies_checked = [0 for i in dans_tools.columns_list]

    for index, policy in enumerate(dans_tools.columns_libelle):
        if resultat.has_key(str(index)):
            if resultat[str(index)]:
                if antilisted[index] == 1:
                    raise Exception("Veuillez supprimer ce site de %s \
pour la politique %s." % (list_msg[antikeyword], policy))
                policies_checked[index] = 1
            log.msg("Les zones concernées : %d -> %s => %s" % (index,
                                                              policy,
                                                      resultat[str(index)]))
    listed[site] = policies_checked
    dans_tools.save_site_list(listed, keyword, zone_indices[zone])
    if not dans_tools.reload():
        log.err("Erreur au lancement de /etc/init.d/dansguardian \
reload(2) dans forms.py")
    return dict()

def valid_mod_list(data_names, data_table, zone, keyword):
    """ valide la modification du tableau des sites
        (blacklists, whitelists, types mime, extensions)
    """
    datas = tools.format_form_result(data_names).keys()
    checked = tools.format_form_result(data_table, True)

    data_list = {}
    for data in datas:
        policies_checked = []
        log.msg("data %s en %s"%(data, keyword))

        # variable pour tester si un site n'est pas présent
        # dans la liste opposée pour une politique
        antilisted = [0 for i in dans_tools.columns_list]
        if keyword == 'whitelist':
            antikeyword = 'blacklist'
        else:
            antikeyword = 'whitelist'
        if data in dans_tools.load_site_list(antikeyword,
                                             zone_indices[zone]).keys():
            antilisted = dans_tools.load_site_list(antikeyword,
                                                   zone_indices[zone])[data]

        for index, policy in enumerate(dans_tools.columns_libelle):
            key = dans_tools.option_and_index_to_name(data, index)
            log.msg("La politique %s : %s"%(policy, checked[key]))
            if checked[key]:
                #test si un site à autoriser
                # pour une police n'est pas interdits (ou inverse)
                if antilisted[index] == 1:
                    raise Exception(
            "Veuillez supprimer le site %s de %s pour la politique %s." % (
                                        data, list_msg[antikeyword], policy))

                policies_checked.append(1)
            else:
                policies_checked.append(0)
        if 1 in policies_checked:
            data_list[data] = policies_checked

    dans_tools.save_site_list(data_list, keyword, zone_indices[zone])
    if not dans_tools.reload():
        log.err("Erreur au lancement de /etc/init.d/dansguardian \
reload(2) dans forms.py")
    return dict()

def valid_extension_form(form_result, zone):
    """
        valide le formulaire d'ajout d'extensions
        à la liste d'extensions interdites
    """
    resultat = tools.format_form_result(form_result, True)
    log.msg("Ajout d'une extension interdite : %s" % resultat['addextension'])
    extension = t.format_ext(resultat['addextension'])

    forbidden_extensions = dans_tools.load_site_list('extension',
                                                     zone_indices[zone])
    if extension in forbidden_extensions.keys():
        policies_checked = forbidden_extensions[extension]
    else:
        policies_checked = [0 for i in dans_tools.columns_list]

    for index, policy in enumerate(dans_tools.columns_list):
        if resultat.has_key(str(index)):
            if resultat[str(index)]:
                policies_checked[index] = 1
            log.msg("Les zones concernées : %d -> %s => %s" % (index,
                                                policy,
                                                resultat[str(index)]))
    forbidden_extensions[extension] = policies_checked

    dans_tools.save_site_list(forbidden_extensions,
                              'extension',
                              zone_indices[zone])
    if not dans_tools.reload():
        log.err("Erreur au lancement de /etc/init.d/dansguardian \
reload(2) dans forms.py")
    return dict()


def valid_mime_form(form_result, zone):
    """
        valide le formulaire d'ajout de types mime
        à la liste de types mime interdits
    """
    resultat = tools.format_form_result(form_result, True)
    log.msg("Ajout d'un type mime interdit : %s"%resultat['addmime'])
    mime = resultat['addmime']

    forbidden_mimes = dans_tools.load_site_list('mime',
                                                zone_indices[zone])
    if mime in forbidden_mimes.keys():
        policies_checked = forbidden_mimes[mime]
    else:
        policies_checked = [0 for i in dans_tools.columns_list]

    for index, policy in enumerate(dans_tools.columns_list):
        if resultat.has_key(str(index)):
            if resultat[str(index)]:
                policies_checked[index] = 1
            log.msg("Les zones concernées : %d -> %s => %s"%(index,
                                               policy,
                                               resultat[str(index)]))
    forbidden_mimes[mime] = policies_checked
    dans_tools.save_site_list(forbidden_mimes,
                              'mime',
                              zone_indices[zone])
    if not dans_tools.reload():
        log.err("Erreur au lancement de /etc/init.d/dansguardian \
reload(2) dans forms.py")
    return dict()
