# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# scripts administratifs
#
###########################################################################
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from os.path import isdir, join, basename

scripts_admin_dir = '/usr/share/minedu/scripts'

used_templates = ['main', 'form', 'formselect']

from glob import glob

def get_scripts_admin():
    """ renvoie la liste des scripts adminstratifs exécutables """
    scripts = {}
    if isdir(scripts_admin_dir):
        for filename in glob(join(scripts_admin_dir, "*.sh")):
            lines = file(filename).read().splitlines()[:2]
            for line in lines:
                if line.startswith('#MENU='):
                    comment = line[6:].rstrip()
                    if 'deprecated' not in comment:
                        script_name = basename(filename)
                        scripts[script_name] = comment
    return scripts

class ScriptsAdmin(Action):
    """ execution des scripts administratifs sur Horus """
    user_description = Dict(doc="description de l'exécutant",
                            keys=['ip', 'role', 'name'])
    name = 'scripts_admin'
    libelle = 'Scripts administratifs'
    description = "exécution de scripts administratifs"
    category = "Outils"
    request = Dict(default={}, doc="requête en cours côté frontend",
                   keys=['server', 'action'])
    form_result = Dict(default={}, doc="Retour de formulaire", keys=['script'])

    def execute(self):
        """ renvoie les données pour la mise en forme """
        params, self.server_nb = tools.get_request(self.request)
        if self.form_result != {}:
            try:
                datas = self._execute_script()
            except Exception, mess:
                datas = {'message':mess.message}
            self.form_result = {}
            return self.send_frag(datas, template='horus_scripts_admin',
                                  templates=used_templates)
        result = {'titre':"Exécution de scripts administratifs"}
        result.update(self._get_form())
        return self.send_frag(result, template='horus_scripts_admin',
                              templates=used_templates)

    def _get_form(self):
        """ renvoie la description du formulaire de sélection de script"""
        script_options = [{'name':script_name, 'libelle':"%s (%s)" % (script_name, libelle)}for script_name, libelle in get_scripts_admin().items()]
        scripts = {'name':'script',
                    'libelle':"<b>Choisissez le script dans la liste<br />et cliquez sur le bouton 'Exécuter'<br /> Attention : le résultat peut être long à s'afficher</b><br />",
                    'options':[{'name':'Scripts administratifs', 'options':script_options}]
                    }
        return dict(scripts=scripts, validate=self._get_validate_btn())

    def _get_validate_btn(self):
        """ renvoie la description du bouton valider """
        href = tools.make_long_form_link(self.server_nb, self.name, True,
                                         ['script'], 'scripts_admin_msg')
        title = "Exécuter le script"
        libelle = "Exécuter"
        icone = '/image/ok.gif'
        return dict(href=href, title=title, libelle=libelle, icone=icone)

    def _execute_script(self):
        """ execute le script sélectionné"""
        if self.form_result.has_key('script'):
            script_name = self.form_result['script'][0]['value']
        script_path = join(scripts_admin_dir, script_name)
        return_code, return_str = tools.command_statusoutput(script_path)
        return_str = return_str.replace('\n', '<br />')
        return dict(message=return_str,
                    message_title="Exécution du script %s" % script_name)

