# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
#
# Aide de l'ead
#
###########################################################################
""" Action d'affichage d'aide """
from twisted.python import log
from ead2.backend.lib.action import * # import des actions et des types
from ead2.backend.actions.tools import get_request, make_form_link
from ead2.backend.actions.tools import format_form_result
from ead2.backend.actions.lib.widgets import ajax
from ead2.lib.libead import uni
import urllib
from ead2.backend.config.config import HELP_DIR
from ead2.config.config import dico, LIGHTSQUID_PORT
from ead2.backend.config.help import help_templates
from ead2.config.config import AUTH_FORM_URL
from os.path import join, isfile
from twisted.web.client import getPage
from glob import glob

import urllib2

class LightSquid(Action):
    """ affiche une aide pour les actions en cours de traitement """
    name = 'lightsquid'
    libelle = "Statistiques proxy"
    description = "Statistiques proxy"
    category = "Outils/"
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                                keys=['server', 'action', 'help', 'agent', 'help_page', 'squid'])

    def execute(self):
        """ renvoie les données pour la mise en forme de la page d'aide
            1 - renvoie les données pour afficher la page des agents
            2 - renvoie les données pour l'aide
        """
        params, self.server_nb = get_request(self.request)
        if AUTH_FORM_URL == None:
            url = ""
        else:
            url = AUTH_FORM_URL + "/?service="
        lightsquid_url = "{0}https://{1}:{2}/index.cgi".format(url, dico['adresse_ip_eth0'], str(LIGHTSQUID_PORT))

        result = {'titre': self.description}
        # XXX FIXME : PAS BON ? (voir backend/actions/status.py pour l'exemple des agents)
        if glob('/var/www/html/lightsquid/report/*') != []:
            popup_url = ajax.popup(lightsquid_url, "Accéder aux statistiques", 800, 600)
            lightsquid_link = "<span onclick=\"{0}\"><a href='#'>Accéder aux statistiques</a></span>".format(popup_url)
        else:
            lightsquid_link = '<span><em>Aucune statistique générée.</em></span>'
        if dico['lightsquid_auto'] == 'oui':
            lightsquid_auto = "Les statistiques sont générées une fois par jour."
        else:
            lightsquid_auto = "Attention, les statistiques ne sont pas mises à jour automatiquement."
        result['help_page'] = "<br/>{0}<br/>Pensez à lancer le script /usr/share/lightsquid/lightparser.pl en root sur le serveur.<br/><br/>{1}".format(lightsquid_auto, lightsquid_link)
        result['titre'] = "Statistiques SQUID"
        d = {'template':'aide', 'data':{'content':result}}
        return 0, uni(str(d))
