# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    Configuration des préférences pour l'importation
"""
from twisted.python import log
from twisted.internet import defer

from scribe.importation import preferences
from scribe.importation import log as importlog

from ead2.backend.lib.action import Dict
from ead2.backend.actions.lib.widgets import ajax, main as M

from ead2.backend.actions.lib.importation.base import BaseImportation
from ead2.backend.actions.lib.importation.forms import eleve_form, \
responsable_form, enseignant_form, administratif_form, get_form_result, \
autre_form
from ead2.backend.actions.lib.importation.config import FORMS
from ead2.backend.actions.lib.importation.tools import set_prefs

class ImportationPreferences(BaseImportation):
    """
        Choix des préférences pour l'importation
    """
    name = 'scribe_extraction_preferences'
    description = "Préférences pour l'importation"
    libelle = description
    request = Dict(keys=['action', 'server',
                         'import_type', 'data_type',
                         'category_type', 'preferences_ok'])
    # container pour le formulaire
    form_result = Dict(default={},
                        keys=FORMS.values())

    def execute(self):
        self.parse_request()
        return_dict = dict(title=self.description)
        defered = defer.Deferred()
        defered.callback(return_dict)
        etape = -1
        if not self.params.has_key('preferences_ok'):
            etape = 4
            data_category = self.params.get('category_type')[0]
            importlog.log.info("catégorie d'utilisateurs : %s" % (
                data_category,))
            log.msg("Étape 4 : On a choisit le type d'utilisateurs à \
importer : %s, on va envoyer le formulaire de choix de préférences." % (
                data_category,))
            defered.addCallback(self._get_preferences_form)
#            defered.addCallback(self._err_prefs_form)

        elif True in [formname in self.form_result.keys()
                               for formname in FORMS.values()]:
            etape = 5
            log.msg("Étape 5 : On valide les préférences utilisateurs.")
            defered.addCallback(self._valid_preferences_form)

        defered.addCallback(self.main)
        defered.addErrback(self.send_error,
       message="Erreur dans le choix des préférences à l'étape %s" % etape
                           )
        return defered

    def _get_preferences_form(self, return_dict):
        """
            Rajoute le formulaire de choix des préférences
            (format du login ...) pour la première passe
        """
        log.msg("On demande le formulaire de préférences")
        category_type = self.params.get('category_type')[0]
        if category_type in ('eleve', 'eleve_ss_resp'):
            return_dict['preferences_forms'] = [eleve_form()]
            formnames = (FORMS['eleve'],)
        elif category_type == 'enseignant':
            return_dict['preferences_forms'] = [enseignant_form()]
            formnames = (FORMS['enseignant'],)
        elif category_type == 'administratif':
            return_dict['preferences_forms'] = [administratif_form()]
            formnames = (FORMS['administratif'],)
        elif category_type == 'autre':
            return_dict['preferences_forms'] = [autre_form()]
            formnames = (FORMS['autre'],)
        return_dict.update(self._get_bouton_valider(formnames))
        return_dict.update(self._get_bouton_retour(step=2))
        return return_dict

    def _get_bouton_valider(self, formnames):
        """
            Renvoie le bouton de validation du formulaire
            de données
        """
        log.msg("On demande le bouton valider")
        import_type = self.params.get('import_type')[0]
        data_type = self.params.get('data_type')[0]
        category_type = self.params.get('category_type')[0]
        href = ajax.valid(self.server_nb,
                          'scribe_extraction_preferences',
                          formnames,
                          container='content',
                          import_type=import_type,
                          data_type=data_type,
                          category_type=category_type,
                          preferences_ok='True')
        href += ajax.top()
        return dict(bouton_valider=M.Submit(href=href))

    def _valid_preferences_form(self, return_dict):
        """
            Valide le choix des préférences utilisateurs
            et :
             - soit renvoie sur l'action suivante,
             - soit renvoie le formulaire suivant
        """
        log.msg("On valide le (les) formulaire de préférences utilisateurs")
        category_type = self.params.get('category_type')[0]
        data_type = self.params.get('data_type')[0]
        log.msg("On importe des %s depuis un fichier %s" % (category_type,
                                                                data_type))
        # recuperation des formulaires
        eleve_prefs = get_form_result(self.form_result, 'eleve')
        responsable_prefs = get_form_result(self.form_result, 'responsable')
        enseignant_prefs = get_form_result(self.form_result, 'enseignant')
        administratif_prefs = get_form_result(self.form_result, 'administratif')
        autre_prefs = get_form_result(self.form_result, 'autre')

        if data_type in ('sconet', 'aaf', 'be1d') and category_type != 'eleve_ss_resp':
            # on va faire un deuxième passage
            if eleve_prefs:
                log.msg("On a des préférences pour les comptes élèves")
                log.msg("eleve_prefs : %s" % eleve_prefs)
                set_prefs(preferences.get_eleves_prefs(), eleve_prefs)
                log.msg("On a défini les préférences")
                return_dict['preferences_forms'] = [responsable_form()]
                return_dict.update(self._get_bouton_valider(
                                               (FORMS['responsable'],)))
                return_dict.update(self._get_bouton_retour(step=3))
                return return_dict

            elif responsable_prefs:
                log.msg("On a des préférences pour les comptes \
responsables")
                set_prefs(preferences.get_responsables_prefs(),
                                              responsable_prefs)
                return_dict['toexec'] = self._javascript_redirection()
                return return_dict

            elif enseignant_prefs:
                log.msg("On a des préférences pour les comptes enseignants")
                set_prefs(preferences.get_enseignants_prefs(),
                                              enseignant_prefs)
                return_dict['preferences_forms'] = [administratif_form()]
                return_dict.update(self._get_bouton_valider(
                                               (FORMS['administratif'],)))
                return_dict.update(self._get_bouton_retour())
                return return_dict

            elif administratif_prefs:
                log.msg("On a des préférences pour les comptes administratifs")
                set_prefs(preferences.get_administratifs_prefs(),
                                                administratif_prefs)
                return_dict['toexec'] = self._javascript_redirection()
                return return_dict

        else: # seulement des élèves et seulement des enseignants
            if eleve_prefs:
                log.msg("On a des préférences pour les comptes élèves")
                set_prefs(preferences.get_eleves_prefs(), eleve_prefs)
                return_dict['toexec'] = self._javascript_redirection()
                return return_dict

            elif enseignant_prefs:
                log.msg("On a des préférences pour les comptes enseignants")
                set_prefs(preferences.get_enseignants_prefs(), enseignant_prefs)
                return_dict['toexec'] = self._javascript_redirection()
                return return_dict

            elif administratif_prefs:
                log.msg("On a des préférences pour les comptes administratifs")
                set_prefs(preferences.get_administratifs_prefs(),
                                                administratif_prefs)
                return_dict['toexec'] = self._javascript_redirection()
                return return_dict

            elif autre_prefs:
                log.msg("On a des préférences pour les comptes invités")
                set_prefs(preferences.get_invites_prefs(), autre_prefs)
                return_dict['toexec'] = self._javascript_redirection()
                return return_dict

        return return_dict

    def _javascript_redirection(self):
        """
            Renvoie un appel ajax pour l'action correspondant
            au type d'import demandé
        """
        import_type = self.params['import_type'][0]
        data_type = self.params['data_type'][0]
        category_type = self.params['category_type'][0]
        return ajax.call(self.server_nb,
                         'scribe_extraction_%s' % data_type,
                         import_type=import_type,
                         category_type=category_type,
                         only=False
                         )
