# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
Fonctions de création des utilisateurs
depuis les données de formulaire
"""
from scribe.eleves import Eleve
from scribe.responsables import Responsable
from scribe.administratifs import Administratif
from scribe.enseignants import Enseignant
from scribe.autres import Autre
from ead2.backend.actions import tools
from ead2.lib.error import MissingKey, MissingValue
from ead2.backend.actions.scribe.tool.scribe_tools import _valid_mail
from ead2.backend.actions.scribe.tool.user import ADRESSE
from ead2.backend.actions.scribe.tool.validate import test_password_length

def test_create_date(date, required=False):
    """
    validation de la date dans le cadre de la
    création d'un compte utilisateur
    """
    date = date.strip()
    if date == '':
        if required:
            raise MissingKey, "Erreur : la date de naissance est obligatoire." % date
        else:
            return date
    if not tools.test_date(date):
        raise MissingKey, "Erreur : le format de la date de naissance %s est incorrect." % date
    else:
        return date

def create_responsable(form_result):
    """
    création d'un responsable
    """
    args = {}
    creation = tools.format_form_result(form_result['add_user'])
    login = creation['user']
    if not tools.test_login(login):
        raise MissingKey, 'Le login ne doit contenir que les caratères de a à z, de 0 à 9 et -_.'
    args['login'] = login
    password = creation['password']
    if not tools.test_pwd(password):
        raise MissingKey, 'Le mot de passe ne convient pas'
    test_password_length(password)
    args['password'] = password
    nom = creation['name']
    args['nom'] = nom
    prenom = creation['forname']
    args['prenom'] = prenom
    args['mail'] = _valid_mail(creation['mailtype'], creation['mailperso'])
    args['date'] = test_create_date(creation['date'])
    args['civilite'] = creation['civilite']
    # gestion des coordonées du responsable
    for attr, _, param in ADRESSE:
        args[param] = creation[attr]
    eleves = []
    for i in range(10):
        eleve = creation.get('eleve'+str(i))
        if eleve == None:
            break
        elif eleve:
            eleves.append(eleve)

    # verifions que l'eleve est bien dans le ldap
    check_eleve = Eleve()

    res = [check_eleve.is_eleve(eleve) for eleve in eleves]
    args['eleve'] = eleves
    if not (False in res or res == []):
        resp = Responsable()
        resp.add_one(**args)
        return dict(message="Réussite de la création du responsable %s %s"% (prenom, nom))
    else:
        raise Exception("Echec de la création du responsable %s %s :\\nUn login élève n'a pas été trouvé dans l'annuaire."% (prenom, nom))


def create_other(form_result):
    """
    création d'un compte invité (Autre)
    """
    args = {}
    creation = tools.format_form_result(form_result['add_user'])
    login = creation['user']
    if not tools.test_login(login):
        raise MissingKey, 'Le login ne doit contenir que les caratères de a à z, de 0 à 9 et -_.'
    args['login'] = login
    password = creation['password']
    if not tools.test_pwd(password):
        raise MissingKey, 'Le mot de passe ne convient pas'
    test_password_length(password)
    args['password'] = password
    nom = creation['name']
    args['nom'] = nom
    prenom = creation['forname']
    args['prenom'] = prenom
    args['mail'] = _valid_mail(creation['mailtype'], creation['mailperso'])
    args['date'] = test_create_date(creation['date'])
    args['civilite'] = creation['civilite']
    Autre().add_one(**args)
    return dict(message="Réussite de la création du compte invité pour %s %s" % (prenom, nom))


def create_administratif(form_result):
    """
    création d'un administratif
    """
    args = {}
    creation = tools.format_form_result(form_result['add_user'])
    login = creation['user']
    if not tools.test_login(login):
        raise MissingKey, 'Le login ne doit contenir que les caratères de a à z, de 0 à 9 et -_.'
    args['login'] = login
    password = creation['password']
    if not tools.test_pwd(password):
        raise MissingKey, 'Le mot de passe ne convient pas'
    test_password_length(password)
    args['password'] = password
    args['date'] = test_create_date(creation['date'])
    nom = creation['name']
    args['nom'] = nom
    prenom = creation['forname']
    args['prenom'] = prenom
    args['civilite'] = creation['civilite']
    args['profil'] =  creation['_sambaProfilePath']
    args['quota'] = creation['user_quota']
    args['shell'] = creation.has_key('shell')
    args['mail'] = _valid_mail(creation['mailtype'], creation['mailperso'])
    args['change_pwd'] = creation.has_key('force_password')
    if creation.has_key('admin'):
        args['groupe'] = 'DomainAdmins'
    if 'etab' in creation:
        args['etab'] = creation['etab']
    adm = Administratif()
    # arguments obligatoires :
    # ['login', 'password', 'nom', 'prenom', 'date']
    # dict(civilite='1',mail='local',quota='0',profil='1',
    # shell=False,int_id='',groupe='',
    adm.add_one(**args)
    return dict(message="Réussite de la création de l'administratif %s %s"% (prenom, nom))


def create_teacher(form_result):
    """
    création d'un enseignant
    """
    args = {}
    ## on teste le retour de toutes les valeurs
    formkeys = ['user', 'name', 'forname', 'password', 'civilite',
                'user_quota', '_sambaProfilePath', 'mailtype',
                'mailperso', 'principal', 'date']

    creation = tools.format_form_result(form_result['add_user'])
    for key in formkeys:
        if key not in creation.keys():
            raise MissingKey, "Il manque une information : %s" % key
    # encodage de certains attributs en UTF8
    for i in ['name', 'forname', 'password']:
        try:
            creation[i] = creation[i].strip()
            creation[i] = creation[i]
        except:
            continue
    args['login'] = creation['user'].strip()
    if not tools.test_login(args['login']):
        raise MissingKey, 'Le login ne doit contenir que les caratères de a à z, de 0 à 9 et -_.'
    password = creation['password']
    if not tools.test_pwd(password):
        raise MissingKey, 'Le mot de passe ne convient pas'
    test_password_length(password)
    args['password'] = password
    args['date'] = test_create_date(creation['date'], required=True)
    args['nom'] = creation['name']
    args['prenom'] = creation['forname']
    args['civilite'] = creation['civilite']
    args['mail'] = _valid_mail(creation['mailtype'], creation['mailperso'])
    # compatibilité des valeurs avec l'annuaire
    for var in ['login', 'mail']:
        if not tools.test_ldap_entry(args[var]):
            raise MissingValue, "La variable %s n'est pas au bon format" % var
    try:
        args['quota'] = int(creation['user_quota'])
    except:
        raise MissingValue, "La variable quota n'est pas un entier"
    args['profil'] =  creation['_sambaProfilePath']
    args['change_pwd'] = creation.has_key('force_password')
    args['shell'] = creation.has_key('shell')
    args['groups'] = []
    if creation['principal'] != '0':
        args['classe'] = creation['principal']
        args['groups'].append('profs-%s' % args['classe'])
    if creation.has_key('admin'):
        args['groups'].append('DomainAdmins')
    if 'etab' in creation:
        args['etab'] = creation['etab']
    ens = Enseignant()
    ens.add_one(**args)
    return dict(message="Réussite de la création de l'enseignant %(prenom)s %(nom)s" % (args))


def create_pupil(form_result):
    """
    création d'un élève
    """
    args = {}
    ## on teste le retour de toutes les valeurs
    formkeys = ['user', 'name', 'forname', 'password', 'domains', 'civilite',
                '_sambaProfilePath', 'divcod', 'employeeNumber', 'user_quota',
                'Ine', 'date']
    creation = tools.format_form_result(form_result['add_user'])
    for key in formkeys:
        if key not in creation.keys():
            raise MissingKey, "Il manque une information : %s" % key
    args['login'] = creation['user'].strip()
    if not tools.test_login(args['login']):
        raise MissingKey, 'Le login ne doit contenir que les caratères de a à z, de 0 à 9 et -_.'
    password = creation['password']
    if not tools.test_pwd(password):
        raise MissingKey, 'Le mot de passe ne convient pas'
    test_password_length(password)
    args['password'] = password
    args['date'] = test_create_date(creation['date'], required=True)
    args['nom'] = creation['name']
    args['prenom'] = creation['forname']
    args['classe'] = creation['divcod']
    args['numero'] = creation['employeeNumber'].strip()
    args['civilite'] = creation['civilite']
    args['domaine'] = creation['domains']
    # compatibilité des valeurs avec l'annuaire
    for var in ['domaine', 'login']:
        if not tools.test_ldap_entry(args[var]):
            raise MissingValue, "La variable %s n'est pas au bon format" % var
    try:
        args['quota'] = int(creation['user_quota'])
    except:
        raise MissingValue, "La variable quota n'est pas un entier"
    args['profil'] =  creation['_sambaProfilePath']
    args['change_pwd'] = creation.has_key('force_password')
    args['shell'] = creation.has_key('shell')
    args['ine'] = creation['Ine'].strip()
    eleve = Eleve()
    eleve.add_one(**args)
    return dict(message="Réussite de la création de l'élève %(prenom)s %(nom)s" % (args))

