#-*-coding:utf-8-*-
"""
    Utilitaires de gestion des clés de frontend
"""
from random import random
from twisted.python import log
from pyeole.dict4ini import DictIni
from ead2.config.config import ip_locale
from ead2.backend.lib.error import UnknownFrontend
from ead2.lib.crypto import create_key

FRONTEND_UNKNOWN_ERROR = "Ce frontend n'est pas encore enregistré."
FRONTEND_AUTH_ERROR = "Tentative de désinscription d'un frontend avec une mauvaise clé."

class FrontendKeys(DictIni):
    """
        Gère les clés de frontend
    """
    def __init__(self, inifile=None):
        super(FrontendKeys, self).__init__(inifile)

    def auth(self, client_ip, key):
        """
            authentifie une clé frontend
        """
        if self.get('keys').get(client_ip) == key:
            return True
        elif client_ip == ip_locale and self.get('keys').get('127.0.0.1') == key:
            # "adresse_ip_eth0" => "127.0.0.1" (#4979)
            log.msg('Frontend forcé en local')
            return True
        else:
            return False

    def register(self, client_ip):
        """
            Enregistre le frontend ayant client_ip comme ip
        """
        frontend_keys = self.get('keys')
        if not frontend_keys.get(client_ip):
            key = create_key(client_ip, random())
            frontend_keys[client_ip] = key
            self.save()
            return key
        else:
            return frontend_keys.get(client_ip)

    def unregister(self, client_ip, key):
        """
            Désenregistre le frontend ayant client_ip comme ip
        """
        frontend_keys = self.get('keys')
        if frontend_keys.has_key(client_ip):
            if frontend_keys[client_ip] == key:
                frontend_keys.pop(client_ip)
                self.save()
                return(0)
            else:
                raise UnknownFrontend(FRONTEND_AUTH_ERROR)
        elif key in frontend_keys.values():
            for client_ip in frontend_keys:
                if frontend_keys[client_ip] == key:
                    frontend_keys.pop(client_ip)
                    return(0)
        else:
            raise UnknownFrontend(FRONTEND_UNKNOWN_ERROR)
