# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Outil pour les actions, gestionnaire de journal
#
# get_request :
#           recupere les parametres et le numero du serveur dans la requete
#
# form_result :
#           refactore le retour de formulaire de manière ergonomique
#
# Utilitaires permettant de generer des liens javascript make_*
#
# Outils de parsing des commandes smb*
###########################################################################

""" utilitaires pour les actions """
from twisted.python import log
from ead2.backend.config.filenames import journal_filename
import pickle, time
from os.path import isfile
from string import ascii_letters, digits, ascii_uppercase
from ead2.lib.libead import parcour_dico, encode_str
from pyeole.process import system_out

from subprocess import PIPE, Popen, STDOUT

forbidden_pwd_chars = [' ', '"', "'"]

def get_request(request):
    """ renvoit la requete,le num serveur"""
    server_nb = None
    if request !={}:
        server_nb = request['server'][0]
    params = parcour_dico(request, encode_str)
    return params, server_nb

#def encode_str(string):
#    """ encode une string ou un unicode en utf8 """
#    try:
#        string = string.encode('utf8')
#    except:
#        pass
#    return string

def format_form_result(liste, check=False):
    """ depuis une liste de dico {'name':nom, 'value':valeur} (éventuellement 'checked':'true'/'false')
        renvoit un dico {nom:valeur}
        :liste: listes des valeurs renvoyées par le formulaire
        :check: si True on recuper True ou False pour les checked='true' sinon on recupere la clé value
                si 2 alors on renvoie le couple nom:value si checked=false et True si checked=true
    """
    #FIXME: la gestion du param check a été modifié,il est possible que cela pose des problèmes
    result = {}
    for param in liste:
        # on passe toute les variables par un filtre pour l'encodage
        param = parcour_dico(param, encode_str)
        if not param.has_key('checked'):
            if type(param['value']) == str:
                result[param['name']] = param['value'].strip()
            else:
                result[param['name']] = param['value']
        else:
            if param['checked'] == 'true':
                if check:result[param['name']] = True
                else:
                    if type(param['value']) == str:
                        result[param['name']] = param['value'].strip()
                    else:
                        result[param['name']] = param['value']
            elif param['checked'] == 'false':
                if check==True:result[param['name']] = False
                if check=='2':result[param['name']] = param['value'].strip()
    return result

def get_records():
    """ renvoit les données enregistrées dans le journal du serveur de commande """
    if isfile(journal_filename):
        a = file(journal_filename, 'r')
        dico = pickle.load(a)
        a.close()
        return dico
    else:
        return {'actions':[]}

def write_journal(dico, key=None):
    """ écrit le journal de bord du serveur de commande
        :dico: données à écrire (le dico entier si key is None, dico[key] si key non None)
        :key: clé du dictionnaire dans laquelle enregistré dico
    """
    if key is None:
        a = file(journal_filename, 'w')
        pickle.dump(dico, a)
        a.close()
    else:
        record = get_records()
        record[key] = dico
        write_journal(record)
    return True

def get_recorded_actions():
    """ renvoit la liste des actions effectuées par l'utilisateur """
    return get_records()['actions']

def record_action(action_description, user_description):
    """ enregistre l'exécution d'une action """
    max_size = 100
    date = time.localtime()
    date = 'Le %s/%s/%s à %s:%s :'%(date[2], date[1], date[0], date[3], date[4])
    actions = get_recorded_actions()
    if len(actions)>max_size:
        actions.reverse()
        actions.pop()
        actions.reverse()
    action = "%s %s par %s depuis %s"%(date,action_description, user_description['name'], user_description['ip'])
    actions.append(action)
    write_journal(actions, 'actions')
    return True

def make_long_js_link(server_nb, action_name, balise='', confirm=False, code=False, **args):
    """ renvoit un lien vers une action
        :**args: parametres d'appel 'nom du param' = 'valeur du param'
        :code: True si les arguments sont sous forme de code js ou False si ce sont des strings
        :confirm: True si on doit confirmer l'execution
    """
    link = ''
    if not confirm:
        link += "javascript:"
    link += "launchLoader();"
    if args == {}:
        if balise:link += "call_action('%s', '%s', '%s')"%(server_nb, action_name, balise)
        else:link += "call_action('%s', '%s')"%(server_nb, action_name)
    else:
        link += "call_plugin('%s', '%s',"%(server_nb, action_name)
        options = "["
        virgule = False
        for key, val in args.items():
            if virgule:
                options += ','
            if not code:
                options += "['%s', '%s']"%(key, val)
            else:
                options += "['%s', %s]"%(key, val)
            virgule = True
        options += "]"
        if balise:link += "%s, '%s');"%(options, balise)
        else: link += "%s);"%options
    return link

def make_js_link(server_nb, action_name, balise='', confirm=False, code=False, **args):
    """ renvoit un lien vers une action
        :**args: parametres d'appel 'nom du param' = 'valeur du param'
        :code: True implique que les arguments sont écrit sous forme de javascript (pas de cote) exemple this.selectIndex
        :confirm: True si on doit confirmer l'execution, True=> pas de javascript:
        :balise: balise html dans laquelle le resultat de la requete doit etre place 'content' si rien
    """
    link = ''
    if not confirm:
        link += "javascript:"
    if args == {}:
        if balise:link += "call_action('%s', '%s', '%s')"%(server_nb, action_name, balise)
        else:link += "call_action('%s', '%s')"%(server_nb, action_name)
    else:
        link += "call_plugin('%s', '%s',"%(server_nb, action_name)
        options = "["
        virgule = False
        for key, val in args.items():
            if virgule:
                options += ','
            if not code:
                options += "['%s', '%s']"%(key, val)
            else:
                options += "['%s', %s]"%(key, val)
            virgule = True
        options += "]"
        if balise:link += "%s, '%s');"%(options, balise)
        else: link += "%s);"%options
    return link

## liens de validtion de formulaire
def make_form_link(server_nb, action_name, direct, formnames=[], balise='', **params):
    """
        renvoie un lien pour un bouton de validation de formulaire
        :server_nb: numéro du serveur à éditer
        :action_name: nom de l'action à qui envoyer la requête
        :direct: True => lien sans le `javascript:` devant pour l'inserer dans un autre js
        :formnames: ids des formulaires à valider
        :balise: balise de réception du résultat de la requête
        :params: paramètres à ajouter à la validation de formualaire
    """
    link = "formValidForm('%s', '%s', "%(server_nb, action_name)
    forms = "["
    virgule = False
    for form in formnames:
        if virgule:
            forms += ", "
        forms += "'%s'"%form
        virgule = True
    forms += "]"

    link += "%s" %forms

    if balise:
        link += ",'%s'" % balise
    if params != {}:
        for key, val in params.items():
            link += ","
            link += "['%s', '%s']" % (key, val)
    link += ");"

    if direct:
        link = "javascript:%s"%link
    return link

def make_key_form_link(server_nb, action_name, direct, formnames=[], balise=''):
    """ renvoit un lien pour la validation clavier de formulaire
        :direct: True: lien sans le `javascript:` devant pour l'inserer dans un autre js
        :*kw: ids des formulaires à valider
    """
    link = "formValidFormByKey('%s', '%s', "%(server_nb, action_name)
    forms = "["
    virgule = False
    for form in formnames:
        if virgule:
            forms += ", "
        forms += "'%s'"%form
        virgule = True
    forms += "]"
    if balise:
        link += "%s, '%s');"%(forms, balise)
    else:
        link += "%s);"%forms
    if direct:
        link = "javascript:%s"%link
    return link

def make_long_form_link(server_nb, action_name, direct, formnames=[], balise=''):
    """ renvoit un lien pour un bouton de validation de formulaire
        :direct: True: lien sans le `javascript:` devant pour l'inserer dans un autre js
        :*kw: ids des formulaires à valider
    """
    link = "launchLoader();formValidForm('%s', '%s', "%(server_nb, action_name)
    forms = "["
    virgule = False
    for form in formnames:
        if virgule:
            forms += ", "
        forms += "'%s'"%form
        virgule = True
    forms += "]"
    if balise:
        link += "%s, '%s');"%(forms, balise)
    else:
        link += "%s);"%forms
    if direct:
        link = "javascript:%s"%link
    return link

def make_confirm_link(message, nextaction):
    """ renvoit un lien pour une action a confirmer avant d'executer
        :message: le message de validation
        :nextaction: description de l'action suivante
    """
    nextaction = nextaction.replace("'", "\\'")
    message = message.replace("'", "\\'")
    link = "javascript:formConfirmExecute('%s', '%s')"%(message, nextaction)
    return link

def make_help_link(server_nb, actionname, **args):
    """ crée un lien vers une aide """
    link = "javascript:setHelp('%s', '%s'"%(server_nb, actionname)
    if args != {}:
        link += ",["
        for key, value in args.items():
            link += "['%s', '%s'],"%(key, value)
        link += "]);"
    else:
        link += ");"
    return link

#######################################################
#   Utilitaires de parsing des commandes smbstatus    #
#######################################################


def list_valid_workstations(_type = None):
    """ renvoit les machines connectées au réseau
        :_list: list de dico décrivant les machines
    """
    keys = {'controleur':'*',
            'maitre':'+'}
    result = []
    machines = get_active_workstations()
    if _type in keys.keys():
        for machine in machines:
            if machine['_type'] == keys[_type]:
                result.append(machine)
        return result
    else:
        return machines

def get_active_workstations():
    """ renvoit les stations connectées
    """
    _list = []
    #code, result = command_statusoutput('/usr/bin/findsmb')
    code, result, err = system_out(['/usr/bin/findsmb'], container='fichier')
    if code == 0:
        workstations = parse_findsmb(result)
        for workstation in workstations:
            _list.append(parse_workstation(workstation))
    return _list

def parse_findsmb(string):
    """ parse les descriptions des machines depuis findsmb"""
    lines = string.splitlines()
    for line in lines:
        if '-------' in line:
            num = lines.index(line)+1
            lines=lines[num:]
    return lines

def parse_workstation(string):
    """ parse les descriptions d'une machine
        'ip , netbiosname ,type, nom, systeme'
    """
    workstation = {}
    attrs = string.split()
    workstation['ip'] = attrs[0]
    workstation['netbiosname'] = attrs[1]
    fin = attrs[2:]
    fin = "".join(fin).split('[')
    workstation['_type'] = fin[0]
    workstation['nom'] = fin[1].split(']')[0]
    if len(fin)>2 :
        workstation['systeme'] =  fin[2].split(']')[0]
    else:
        workstation['systeme'] = "undefined"
    return workstation

#####
def parse_smbstatus(string):
    """ parse la commande smbstatus
        :return: liste de dico decrivant les utilisateurs ainsi
                    que tous les services et fichiers qui leur sont associés
                    None par défaut
    """
    users_section = string.split('ocked files')[0]
    activity_section = string.split('ocked files')[1]
    users = parse_smbstatus_users(users_section)
    if users is not None:
        activity = parse_smbstatus_files(activity_section)
        if activity is not None:
            users = associate_users_and_files(users, activity)
        else:
            for user in users:
                user['files'] = None
        return users
    return []

def associate_users_and_files(users, activity):
    """ associe les utilisateurs et leur fichier en activité"""
    for user in users:
        user['files'] = []
        for f in activity:
            if f['pid'] == user['pid']:
                user['files'].append(f)
    return users

def parse_smbstatus_files(string):
    """ parse la section des fichiers actifs (action en cour) """
    file_sect = string.splitlines()
    files_str = ''
    for i, line in enumerate(file_sect):
        if '----------' in line:
            files_str = file_sect[(i+1):]
            break
    fichiers = []
    if files_str == '':
        return None
    for file_str in files_str:
        file_tab = file_str.split()
        if file_tab != []:
            fichier = {}
            fichier['pid'] = file_tab[0]
            fichier['uid'] = file_tab[1]
            fichier['denymode'] = file_tab[2]
            fichier['access'] = file_tab[3]
            fichier['rw'] = file_tab[4]
            fichier['oplock'] = file_tab[5]
            fichier['sharepath'] = file_tab[6]
            fichier['nom'] = file_tab[7]
            fichiers.append(fichier)
    if fichier == []:
        return None
    return fichiers

def parse_smbstatus_users(string):
    """ parse la section utilisateurs de smbstatus (deux parties)"""
    users_sect = string.splitlines()
    # on sépare les deux parties
    for i, line in enumerate(users_sect):
        if '----------' in line:
            result = users_sect[(i+1):]
            break
    for i, line in enumerate(result):
        if '----------' in line:
            part1 = result[:(i-1)]
            part2 = result[(i+1):]
            break
    # on récupère tous les utilisateurs
    users = []
    for i in part1:
        user_table = i.split()
        if user_table != []:
            user = {}
            user['pid'] = user_table[0]
            user['nom'] = user_table[1]
            user['group'] = user_table[2]
            user['machine'] = user_table[3]
            ip = user_table[4]
            if user['machine'] not in ip:
                if ip[0] =='(':
                    ip = ip [1:]
                    ip = ip[:-1]
                user['ip'] = ip
            else:
                user['ip'] = ''
            users.append(user)
    if users == []:
        return None
    services = []
    for i in part2:
        user_table2 = i.split()
        if len(user_table2) >4:
            service = {}
            service['service'] = user_table2[0]
            service['pid'] = user_table2[1]
            service['machine'] = user_table2[2]
            fin = user_table2[3:]
            fin = "".join(fin)
            service['timeconnect'] = fin
            services.append(service)
    # on associe les services à leur propriétaire
    for user in users:
        user['services'] = []
        for service in services:
            if user['pid'] == service['pid']:
                user['services'].append(service)
        if user['services'] == []:
            user['services'] = None
    return users

#### Test pour les entrees LDAP
def test_login(attr):
    """Controle que le login ne contient que des [a-Z] [0-9] et '_-.'
    """
    chars = ascii_letters + digits + '-_.' # caracteres speciaux a autoriser en plus
    for i in attr:
        if i not in chars: return None
    return True

def test_pwd(pwd):
    """ teste la validité d'un mot de passe, à améliorer """
    chars = forbidden_pwd_chars
    for i in pwd:
        if i in chars: return False
    return True

def test_number(attr):
    """ teste si une string est un nombre """
    if type(attr) == int: return True
    chars = digits
    for i in attr:
        if i not in chars: return None
    return True

def test_ldap_attribute(attr):
    """ controle un attribut à rentrer dans l'annuaire"""
    return True
#    try:
#        int(attr)
#        return False
#    except:
#        return True

def test_ldap_entry(entry):
    """ controle une entrée dans l'annuaire, pas d'espace """
    if ' ' in entry: return False
    entry = entry.replace('.', '')
    if not test_ldap_attribute(entry): return False
    return True

def test_drive_letter(letter):
    """ teste si une lettre de lecteur est bien de la forme <lettre>:"""
    if ':' not in letter: return False
    if len(letter) != 2: return False
    if letter[0].upper() not in ascii_uppercase: return False
    return True

def test_date(date):
    """ controle le format jj/mm/aaaa d'une date """
    a = date.split('/')
    if len(a) != 3: return False
    if len(a[0]) > 2 or len(a[0]) == 0 or not test_number(a[0]): return False
    if len(a[1]) > 2 or len(a[1]) == 0 or not test_number(a[1]): return False
    if int(a[1]) not in range(1,13): return False
    if len(a[2]) != 4 or not test_number(a[2]): return False
    return True

def test_path(path):
    """ test un chemin de fichier [a-Z] [0-9] et '_-./' """
    if type(path) not in (str, unicode): return None
    if not path.startswith('/'): return None
    chars = ascii_letters + digits + '-_./' # caracteres speciaux a autoriser en plus
    for i in path:
        if i not in chars: return None
    return True

def test_mail(mail):
    """ teste une adresse mail *@*.* """
    mail = mail.strip()
    if ' ' in mail:
        return False
    chars = ascii_letters + digits + '-_.@'
    for i in mail:
        if i not in chars:
            return False
    if len(mail.split('@')) == 2:
        return True
    return False

def filter_by_alpha(users, alpha):
    """ filtre une liste d'utilisateur par nom de famille sur la première lettre"""
    result = []
    for user in users:
        if user.lower().startswith(alpha.lower()): result.append(user)
    return result

## fonction d'éxécution de commande avec subprocess (à la place de commands)
def cmdtolist(str):
    """ cree une liste de commande depuis une string """
    cmdlist=[]
    current=[]
    gc=''
    last=''
    for c in str:
        if (c == '\\'):
            pass
        elif (last == '\\'):
            current.append(c)
        elif (gc != ''):
            if (c != gc):
                current.append(c)
            else:
                gc=''
        else:
            if (c.isspace()):
                cmdlist.append(''.join(current))
                current = []
            elif (c == '"'):
                gc = c
            elif (c == "'"):
                gc = c
            else:
                current.append(c)
        last = c
    if (len(current) != 0):
        cmdlist.append(''.join(current))
    cmdlist.insert(0, 'sudo')
    return cmdlist

class Fpipe:
    def __init__(self, fn, stdin=None):
        self.fn = fn
        self.stdin = stdin
        self.stdout = StringIO.StringIO()
    def call(self):
        self.fn(self.stdin, self.stdout)

def command_statusoutput(*cmds, **args):
    """ equivalent à commands.getstatusoutput mais avec subprocess,
        accepte plusieurs commande liées, (équivalent à 'cmd1 | cmd2')
        renvoie un code retour et le resultat de  la commande
        option nommée 'err' à False si les erreurs ne sont pas incluses
        dans stdin
    """
    def func():
        pass
    def norm(cmd):
        if (isinstance(cmd, str)):
            return cmdtolist(cmd)
        return cmd
    def pipeobj(cmd, stdin=None, err=True):
        if (callable(cmd)):
            fp = Fpipe(cmd, stdin)
            fp.call()
            fp.stdout.seek(0)
            return fp
        if (stdin is None):
            if err:
                return Popen(norm(cmd), stdout=PIPE, stderr=STDOUT)
            else:
                return Popen(norm(cmd), stdout=PIPE)
        else:
            if err:
                return Popen(norm(cmd), stdin=stdin, stdout=PIPE, stderr=STDOUT)
            else:
                return Popen(norm(cmd), stdin=stdin, stdout=PIPE)

    err = args.get('err', True)
    if (len(cmds) == 0):
        return
    prev = None
    for cmd in cmds:
        if (prev is None):
            prev = pipeobj(cmd, err=err)
        else:
            prev = pipeobj(cmd, stdin=prev.stdout, err=err)
    return_str = prev.communicate()[0].strip()
    return_code = prev.wait()
    log.msg(cmds)
    return return_code, return_str

def command_output(cmd):
    """ renvoie le résultat d'une commande """
    cmd = cmd.split()
    cmd.insert(0, 'sudo')
    return Popen(cmd, stdout=PIPE, stderr=PIPE, stdin=PIPE).communicate()[0]
