# -*- coding: UTF-8 -*-

# répertoire de l'application ead
import os.path as osp
from creole.eosfunc import is_installed
HERE = osp.dirname(__file__)
EAD_DIR = osp.normpath(osp.join(HERE, '..'))

try:
    #ZZZZ2.4
    from creole.client import CreoleClient
    dico = CreoleClient().get_creole()
    ip_locale = dico['adresse_ip_eth0']

    if dico.get('ead_sso', 'non') == 'oui':
        AUTH_SERVER_ADDR = dico.get('eolesso_adresse', ip_locale)
        AUTH_FORM_PORT = dico.get('eolesso_port', '8443')
    else:
        AUTH_SERVER_ADDR = None
        AUTH_FORM_PORT = None

    if dico.get('activer_ead_reverseproxy', 'non') != 'non':
        REVERSEPROXY_PORT = dico.get('port_ead_reverseproxy', None)
    else:
        REVERSEPROXY_PORT = None

    from creole.config import cert_file, key_file
    cert_file = dico.get('server_cert', cert_file)
    key_file = dico.get('server_key', key_file)

except:
    print 'except'
    ip_locale = '127.0.0.1'
    AUTH_SERVER_ADDR = None
    AUTH_FORM_PORT = None
    REVERSEPROXY_PORT = None

#durée de vie d'un nombre magique permettant la communication entre un frontend et un backend
#ce timeout est reinitialise a chaque fois qu'une action est lancée
MAGIC_NUMBER_TIMEOUT = 3600 * 24

#durée de vie des sessions expirées. Quand une session expire, on la garde dans un cache pour savoir
#si quand une session est non valide, si elle avait expirée ou si elle n'a jamais existée
EXPIRED_SESSION_TIMEOUT = 60 * 60 * 2

# lightsquid (consultation des logs)
LIGHTSQUID_INSTALLED = is_installed('lightsquid')
# durée de vie en secondes de la session pour l'accès à l'application
LIGHTSQUID_TIMEOUT = 60 * 15
# Port de l'application Lightsquid (consultation des logs squid)
LIGHTSQUID_PORT = int(dico.get('lightsquid_port', 8062))

if AUTH_SERVER_ADDR and AUTH_FORM_PORT:
    #URL de la page web d'authentification
    AUTH_FORM_URL = 'https://%s:%s' % (AUTH_SERVER_ADDR, AUTH_FORM_PORT)
    #URL du serveur d'authentification
    AUTH_SERVER = 'https://%s:%s/xmlrpc' % (AUTH_SERVER_ADDR, AUTH_FORM_PORT)
else:
    AUTH_FORM_URL = None
    AUTH_SERVER = None
#port d'ecoute du backend
BACKEND_LISTEN_PORT = 4201
#Port d'ecoute du serveur de fichier
EADFILE_LISTEN_PORT = 4202
EADFILE_URL = ip_locale
