# -*- coding: utf-8 -*-
""" Menu de gestion des actions sur un serveur """
from twisted.python import log
from nevow import loaders, athena, tags as T, static, rend, inevow
from nevow.flat import flatten

from ead2.frontend.web.config import ENCODING
from ead2.lib import error

class Menu(rend.Fragment):
    """ partie gauche de l'ead
        :menu: dico décrivant le menu
        :action: dico décrivant les actions
    """
    docFactory = loaders.xmlstr('''\
                               <div xmlns:nevow="http://nevow.com/ns/nevow/0.1">
                                     <span nevow:render="menu"/>
                                </div>
                                ''')

    def __init__(self, ctx):
        self.ctx = ctx
        self.action_path =[]

    def _get_open_menu_list(self, action, menu):
        """ recupere le chemin vers l action en cour pour avoir un menu ouvert
            :action: nom de l'action en cour
            :menu: dico de description du menu
            fonction recursive
        """
        _list = []
        # on parcoure les cles de dico
        for cle in menu.keys():
            if action in self._get_child(cle, menu):
                _list.append(cle)
                _list.extend(self._get_open_menu_list(action, menu[cle][1]))# on parcoure les sous menus
        return _list

    def _get_child(self, name, dico):
        """
           liste les enfants d'une clé du dico
           fonction recursive
        """
        _list = []
        value = dico[name]
        _list.extend(value[0]) # les enfants directs
        if value[1] != {}:
            for key, val in value[1].items():
                _list.extend(self._get_child(key, value[1])) # les enfants des sous menus
        return _list


    def _data_menu(self):
        """
        construction des datas pour le menu
        """
        session = inevow.ISession(self.ctx)
        if 'actions' and 'menu' in session.menu.keys():
            self.actions = session.menu['actions']
            self.menu = session.menu['menu']
        return

    def render_menu(self, ctx, data):
        """ rend le menu """
        self._data_menu()
        return self._menu()

    def _menu(self):
        """ construction du menu """
        action = inevow.ISession(self.ctx).current_action # on recup l action en cour
        # on liste l arborescence de menu pour arriver a notre action
        if action:
            self.action_path = self._get_open_menu_list(action, self.menu)
        if self.menu is not None:
            return T.div(_id="list")[T.ul(_class="open")[T.h1["Actions sur le serveur"], self._affiche(self.menu, self.actions)]]
        else:
            return ''


    def _affiche(self, dico_menu, dico_action):
        """
            Affiche le menu
        """
        menu = []
        menu_entries = dico_menu.keys()
        menu_entries.sort()
        for menu_entry in menu_entries:
            submenu_description = dico_menu[menu_entry]
            if menu_entry:
                # on a des sous-menu
                if menu_entry in self.action_path:
                    triangle = self._open_triangle(menu_entry)
                    classe = 'open'
                else:
                    triangle = self._closed_triangle(menu_entry)
                    classe= 'closed'
                sub_menu = T.ul(_id="ul_menu%s" % menu_entry, _class=classe)[
                                    self._affiche_script(submenu_description[0], dico_action),
                                    self._affiche(submenu_description[1], dico_action)
                                    ]
                menu_tag = T.li(_id='menu%s' % menu_entry)[
                                                  triangle,
                                                  sub_menu]
                menu.append(menu_tag)

            else:
                #on a pas de sous-menu
                menu.append(#T.li(_id='menu%s' % menu_entry)[
                            self._affiche_script(submenu_description[0], dico_action)
                            #                      ]
                            )
        return menu

#    def _affiche(self, dico_menu, dico_action):
#        """
#        Pour afficher le menu mis en forme
#        Fonction récursive
#        """
#        menu = []
#        keys = dico_menu.keys()
#        keys.sort()
#        #for cle, value in dico_menu.items():
#        for cle in keys:
#            value = dico_menu[cle]
#            # on regarde si ce menu doit rester ouvert
#            if cle in self.action_path:
#                triangle = self._open_triangle(cle)
#                classe = 'open'
#            else:
#                triangle = self._closed_triangle(cle)
#                classe= 'closed'
#            if cle:
#                menu.append(T.li(_id='menu%s'%cle)[ triangle,
#                        T.ul(_id="ul_menu%s"%cle, _class=classe)[ self._affiche_script(value[0], dico_action),
#                                                                  self._affiche(value[1], dico_action)
#                                                                ]
#                                                  ])
#            else:
#                menu.append(T.li(_id='menu%s'%cle)[ self._affiche_script(value[0], dico_action)])
#        return menu

    def _closed_triangle(self, cle):
        """ rend les triangles du menu pour un menu ferme"""
        return T.a(href="javascript:toggle('menu"+cle+"');")[
                                                    T.img(src="/image/closed.gif", _id="img_menu"+cle),
                                                    cle
                                                   ]
    def _open_triangle(self, cle):
        """ rend les triangles du menu ouvert """
        return T.a(href="javascript:toggle('menu"+cle+"');")[
                                                    T.img(src="/image/opened.gif", _id="img_menu"+cle),
                                                    cle
                                                   ]

    def _affiche_script(self, liste, dico_action):
        """
        Affichage des scripts d'action
        """
        liste.sort()
        tag = []
        session = inevow.ISession(self.ctx)
        server_nb = session.current_server
        if hasattr(session, 'current_action'):
            current = session.current_action
        else:
            current = None
        for elt in liste:
            href = None
            if not href:
                href = "javascript:setActiveMenu('menu_%s');call_action('%s', '%s')"%(elt, str(server_nb), elt)
            tag.append(T.li[ T.a(_class='action',_id='menu_%s'%elt, href=href,title=dico_action[elt][0])[
                                    T.img(src='/image/soleil_orange.png', border=0),
                                    T.span[dico_action[elt][2]]
                                ]
                            ])
            if elt == current:
                tag.append(T.script["setActiveMenu('menu_%s')"%(elt)])
        return tag
