#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# client de test de bande passante
#
###########################################################################


from twisted.internet import reactor, defer
#from twisted.internet.defer import
from twisted.internet.protocol import Protocol, ClientCreator, ClientFactory
import time


class EchoClient(Protocol):

    def __init__(self):
        self.myd = defer.Deferred()

    def connectionMade(self):
        self.size = 25
        self.debut = time.time()
        self.send(1)

    def dataReceived(self, data):
        fin_mess = data[-4:]
        if fin_mess == 'ROK1':
            passed1 = time.time()-self.debut
            try:
                self.size = int(self.size/passed1)
            except:
                pass
            self.debut = time.time()
            self.send(2)
        if fin_mess == 'ROK2':
            passed2 = time.time()-self.debut
            try:
                self.upload = self.size/passed2
            except:
                self.upload = 0
            self.transport.write('END3')
        if fin_mess == 'END1':
            self.transport.write('ROK1')
            self.debut = time.time()
        if fin_mess == 'END2':
            passed3 = time.time()-self.debut
            taille = int(data[-14:-4])
            try:
                self.download = taille/passed3
            except:
                self.download = 0
            self.transport.loseConnection()

    def connectionLost(self, reason):
        try:
#            self.factory.debits = {'down':self.download, 'up':self.upload}
            self.debits = {'down':self.download, 'up':self.upload}
        except:
#            self.factory.debits = {'down':None, 'up':None}
            self.debits = {'down':None, 'up':None}
        self.myd.callback(self.debits)
        return self.debits
#        return self.download, self.upload

    def send(self, indice):
        self.size = self.size * 2
        message = '1'*1024*self.size
        message = message[:-4]+'END'+str(indice)
        self.transport.write(message)

class EchoFactory(ClientFactory):
    protocol = EchoClient

    def __init__(self, fonction=None):
        self.fonction = fonction

    def clientConnectionFailed(self, connector, reason):
        dico={'up':None, 'down':None}
        if self.fonction: self.fonction(dico)
        else:
            affiche(dico)

    def clientConnectionLost(self, connector, reason):
        try:
            debit_down, debit_up = round(self.debits['down'],1), round(self.debits['up'],1)
        except:
            debit_down, debit_up = None, None
        dico = {'up':debit_up, 'down':debit_down}
        if self.fonction: self.fonction(dico)
        else: affiche(dico)


def defer_connect(HOST, PORT):
    c = ClientCreator(reactor, EchoClient)
    d = c.connectTCP(HOST, int(PORT))
    return d.addCallback(lambda proto: proto.myd)

def defer_test_connection(HOST, PORT, fonction='', err_fonction = ''):
    d = defer_connect(HOST, PORT)
    d.addCallback(fonction)
    d.addErrback(err_fonction)
#    d.addCallback(fonction)
#    d.addErrback(err_fonction)

# this connects the protocol to a server HOST, runing on port PORT
def test_connexion(HOST, PORT, fonction=None):
    """teste la bande passante avec HOST et excute "fonction"
    avec dico{'up':x, 'down:y} en argument sinon utilise la fonction
    "affiche"
    """
    f = EchoFactory(fonction)
    reactor.connectTCP(HOST, int(PORT), f, timeout=3)

def affiche(dico):
    if type(dico) == dict:
        try:
            reactor.stop()
        except:
            pass
    else:
        print "Erreur"

def ret_err(m=None, n=None):
    reactor.stop()

def main():
    HOST = '127.0.0.1'
    HOST = '192.168.230.85'
    PORT = 50010
    d = defer_connect(HOST, PORT)
    d.addCallback(affiche)
    d.addErrback(ret_err)
    reactor.run()

# this only runs if the module was *not* imported
if __name__ == '__main__':
    main()


