# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Données pour la mise en forme de base (boutons)
#
###########################################################################

from base import Base

class Bouton(Base):

    def __init__(self, href='', libelle='', icone='/image/ok.gif', title='', _class=None):
        self.init_dict(href, libelle, icone, title, _class)

    def init_dict(self, href, libelle, icone, title, _class):
        self['href'] = href
        self['libelle'] = libelle
        self['icone'] = icone
        self['title'] = title
        if _class:
            self['_class'] = _class

class BoutonDiv(Bouton):
    pass

class Lien(Bouton):
    def __init__(self, href='', libelle='', icone='', title='', _class='simple_link'):
        self.init_dict(href, libelle, icone, title, _class)

class Submit(Bouton):
    def __init__(self, href='', libelle='Valider', icone='/image/ok.gif', title='', _class=None):
        self.init_dict(href, libelle, icone, title, _class)

class SupprBtn(Bouton):
    def __init__(self, href='', libelle='Supprimer', icone='/image/supprimer.gif', title="", _class=None):
        self.init_dict(href, libelle, icone, title, _class)

class CloseBtn(Bouton):
    def __init__(self, href='', libelle='Fermer', icone='/image/supprimer.gif', title="", _class=None, balise=""):
        """
            balise : si balise est renseignée
        """
        if balise :
            if href:
                href += "setVoid('%s');" % balise
            else:
                href = "javascript:setVoid('%s');" % balise
        self.init_dict(href, libelle, icone, title, _class)
