# -*- coding: utf-8 -*-
from scribe.eoleldap import Ldap
from ldap import  SCOPE_ONELEVEL, modlist
from scribe.ldapconf import SUFFIX, acad, num_etab

def get_etabs():
    conn = Ldap()
    conn.connect()
    suffix = "ou=%s,ou=education,%s" % (acad, SUFFIX)
    etabs = conn.connexion.search_s(suffix, SCOPE_ONELEVEL,'(ou=*)', ['ou'])
    conn.close()
    if etabs == None:
        raise Exception('Impossible de récuperer des établissements dans %s' % suffix)
    list_etabs = []
    for etab in etabs:
        list_etabs.extend(etab[1]['ou'])
    if num_etab not in list_etabs:
        raise Exception('Pas de branche LDAP pour le numéro établissement source %s ' % num_etab)
    list_etabs.remove(num_etab)
    return (num_etab, list_etabs)

def add_etab(uai):
    conn = Ldap()
    conn.connect()
    suffix = "ou=%s,ou=%s,ou=education,%s" % (uai, acad, SUFFIX)
    #les groupes
    suffix_group = "ou=groupes,%s" % suffix
    suffix_group_local = 'ou=local,%s' % suffix_group
    #les partages
    suffix_share = "ou=partages,%s" % suffix
    suffix_share_local = "ou=local,%s" % suffix_share
    #les utilisateurs
    suffix_user = "ou=utilisateurs,%s" % suffix
    suffix_user_perso = "ou=personnels,%s" % suffix_user
    suffix_user_perso_local = "ou=local,%s" % suffix_user_perso
    suffix_user_eleve = "ou=eleves,%s" % suffix_user
    suffix_user_eleve_local = "ou=local,%s" % suffix_user_eleve
    suffix_user_autre = "ou=autres,%s" % suffix_user
    suffix_user_autre_local = "ou=local,%s" % suffix_user_autre
    suffix_user_responsable = "ou=responsables,%s" % suffix_user
    suffix_user_responsable_local = "ou=local,%s" % suffix_user_responsable

    etab = {}
    etab['objectclass'] = ['organizationalUnit']
    ldif = modlist.addModlist(etab)
    conn._add(suffix, ldif)
    conn._add(suffix_group, ldif)
    conn._add(suffix_group_local, ldif)
    conn._add(suffix_share, ldif)
    conn._add(suffix_share_local, ldif)
    conn._add(suffix_user, ldif)
    conn._add(suffix_user_perso, ldif)
    conn._add(suffix_user_eleve, ldif)
    conn._add(suffix_user_autre, ldif)
    conn._add(suffix_user_responsable, ldif)
    conn._add(suffix_user_perso_local, ldif)
    conn._add(suffix_user_eleve_local, ldif)
    conn._add(suffix_user_autre_local, ldif)
    conn._add(suffix_user_responsable_local, ldif)
    conn.close()

