# -*- coding: UTF-8 -*-
"""configuration du backend ead
"""
from os.path import abspath, join, dirname, normpath
from ead2.config.config import dico
from ead2 import backend

# module EOLE et version
EOLE_MODULE = dico['eole_module']
EOLE_VERSION = dico['eole_version']

# internationalisation
I18N_DIR = abspath(join(dirname(backend.__file__), 'i18n'))
# nom de l'application
APP_NAME = "ead2"

# repertoire des actions
# ex : ROOT_DIR/ead2/backend/actions
ACTION_DIR = abspath(join(dirname(backend.__file__), 'actions'))
# repertoire des scripts lances par les actions
SCRIPT_DIR = abspath(join(dirname(backend.__file__), 'bin'))
# repertoire des fichiers telecharges par le frontend
DOWNLOAD_DIR = abspath(join(dirname(backend.__file__), 'download'))
MD5_DIR = abspath(join('/tmp/', 'md5'))
# fichier de configuration (ce repertoire)
CONFIG_DIR = abspath(dirname(__file__))

# repertoire des gabarits disponibles pour envoir par le backend
# exemple : ROOT_DIR/ead2/backend/template
TEMPLATE_DIR = normpath(abspath(
    join(dirname(__file__), '..', 'template')))

# Nouveaux répertoires sur Eole-2.3
EOLE_CONFIG_DIR = '/var/lib/eole/config'
EOLE_REPORTS_DIR = '/var/lib/eole/reports'

#UID de l'utilisateur nobody
NOBODY_UID = 65534
#GID de l'utilisateur nobody
NOBODY_GID = 65534
# Le port des agents zephir on teste qu'ils sont la ....
try:
    from zephir.monitor.agentmanager import config
    AGENT_PORT = 8090
except:
    AGENT_PORT = None

#sur Zéphir les agents sont diffusés en HTTPS
if EOLE_MODULE == 'zephir':
    AGENT_PROTOCOL = 'https'
else:
    AGENT_PROTOCOL = 'http'
#fichier des cles associees a chaque frontend
FRONTEND_KEYS_FILE = join(CONFIG_DIR, 'frontend_keys.ini')
#chemin vers les fichiers de commande bacula
BACULA_DIR = "/usr/share/eole/bacula/"
# chemin vers les fichiers bacula
BACULA_TEMP_DIR = EOLE_REPORTS_DIR
#chemin vers les fichiers temporaires
TEMP_DIR = abspath(join(dirname(backend.__file__), 'tmp'))
#chemin vers les fichiers d'aide
HELP_DIR = abspath(join(dirname(backend.__file__), 'aide'))
# Chemin pour l'activation de nouvelles actions ead
ENABLED_ACTION_DIR = "/etc/ead/sites-enabled"
AVAILABLE_ACTION_DIR = "/etc/ead/sites-available"
PLUGIN_PERM_DIR = "/usr/share/ead2/backend/config/perms"

# services dont l'arrêt peut provoquer la déconnexion Ead2
EAD_SERVICES = ['ead-server', 'ead-web', 'eole-sso']
NON_STOP_SERVICES = ['networking', 'bastion', 'rsyslog']
