# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
#  Outil de gestion de set de machine
#
###########################################################################
""" Action d'evaluation d'url """
from twisted.python import log

from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.actions.amon import groupe_form
from ead2.backend.actions.amon.amon_tools import get_zone_libelle

used_templates = ['main', 'form', 'accordion', 'formselect']

zone_libelle = get_zone_libelle(1)

class GroupeMachineadmin(Action):
    """ gestion des sets ipset de machine """
    user_description = Dict(default={},
                            doc="description de l'éxécutant",
                            keys=['ip', 'name', 'role'])
    name = 'groupe_machine_admin'
    libelle = "Groupe de machine"
    description = "Gère des groupes de machine sur '{0}'".format(zone_libelle.lower())
    category = zone_libelle.capitalize()
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action',
                         'delete', 'menu',
                         'forbid', 'ip_set',
                         'policy'])

    def execute(self):
        """ renvoie les données pour la mise en forme des actions
        """
        self.params, self.server_nb = tools.get_request(self.request)
        if self.params.has_key('delete'):
            try:
                datas = groupe_form.del_ip_set('admin',
                                self.params['delete'][0])
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True,
                                                     balise='ip_set_menu',
                                                     menu='ok')
            except Exception, mess:
                log.err()
                datas = {'message':str(mess)}
            return self.send_frag(datas,
                                  template="amon_groupe_machine",
                                  templates=used_templates)

        elif self.params.has_key('forbid'):
            try:
                datas = groupe_form.forbid('admin', self.params['ip_set'][0], self.params['forbid'][0])
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True,
                                                     balise='ip_set_menu',
                                                     menu='ok')
            except Exception, mess:
                log.err()
                datas = {'message':str(mess)}
            return self.send_frag(datas, template="amon_groupe_machine", templates=used_templates)

        elif self.params.has_key('policy'):
            try:
                datas = groupe_form.set_policy('admin', self.params['ip_set'][0], self.params['policy'][0])
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True,
                                                     balise='ip_set_menu',
                                                     menu='ok')
            except Exception, mess:
                log.err()
                datas = dict(message=str(mess))
            return self.send_frag(datas, template="amon_groupe_machine", templates=used_templates)
        elif self.params.has_key('menu'):
            datas = groupe_form.ip_sets('admin', self.server_nb, self.name)
            return self.send_frag(datas, template="amon_groupe_machine", templates=used_templates)
        result = {'titre':self.libelle}
        result.update(groupe_form._get_ip_set_create_btn('admin', self.server_nb, self.name))
        result['toexec'] = tools.make_js_link(self.server_nb, self.name, confirm=True, balise='ip_set_menu', menu='ok')
        return self.send_all(result, template="amon_groupe_machine", templates=used_templates)

class GroupeMachineCreateadmin(Action):
    """ gestion des sets ipset de machine """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'groupe_machine_create_admin'
    libelle = "Création de groupe de machine"
    description = "Crée un groupes de machine sur '{0}'".format(zone_libelle.lower())
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                                keys=['server', 'action'])
    form_result = Dict(default={}, doc="retour formulaire de la requete en cours coté frontend",
                                    keys = ['set_create'])
    def execute(self):
        """ renvoie les données pour la mise en forme des actions
        """
        self.params, self.server_nb = tools.get_request(self.request)
        if self.form_result != {}:
            if self.form_result.has_key('set_create'):
                try:
                    datas = groupe_form.create_set('admin',
                                                 tools.format_form_result(self.form_result['set_create']))
                    datas['toexec'] = tools.make_js_link(self.server_nb, 'groupe_machine_admin',
                                                    confirm=True, balise='ip_set_menu', menu='ok')
                except Exception, mess:
                    datas = {'message':str(mess)}
                self.form_result = {}
                return self.send_frag(datas, template="amon_groupe_machine", templates=used_templates)
        result = groupe_form.create_form('admin')
        result['libelle'] = self.libelle
        result['validate'] = self._get_validate_btn()
        return self.send_all(result, template="amon_groupe_machine", templates=used_templates)

    def _get_validate_btn(self):
        """ renvoie les données pour la mise en forme du bouton valider """
        href = tools.make_form_link(self.server_nb, self.name, True, ['set_create'], balise='set_create_msg')
        title = "Valider la création de ce groupe"
        libelle = "Valider"
        icone = "/image/ok.gif"
        return dict(href=href,
                    title=title,
                    libelle=libelle,
                    icone=icone)


class GroupeMachineHoraire(Action):
    """ gestion des liens des horaires des groupes de machine """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'groupe_machine_horaire_admin'
    libelle = "Application de plage horaire"
    description = "Définir des plage horaires d'ouverture"
    category = None
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                        keys=['server', 'action', 'ip_set', 'todel'])
    form_result = Dict(default={}, doc="retour formulaire de la requete en cours coté frontend",
                        keys = ['ip_set_time_range', 'ip_set_current_set', 'ip_set_time_range_copy'])
    def execute(self):
        """ renvoie les données pour la mise en forme des actions
        """
        self.params, self.server_nb = tools.get_request(self.request)
        self.group = None
        if self.form_result != {}:
            if self.form_result.has_key('ip_set_time_range'):
                try:
                    self.group = self.form_result['ip_set_current_set'][0]['value']
                    datas = groupe_form.set_time_range('admin',
                            self.group,
                            tools.format_form_result(self.form_result['ip_set_time_range'])
                            )
                    datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                         balise='ip_set_workspace',
                                                         confirm=False,
                                                         ip_set=self.group)
                except Exception, mess:
                    log.err()
                    datas = {'message':str(mess)}
                self.form_result = {}
                return self.send_frag(datas, template="amon_groupe_machine", templates=used_templates)

            if self.form_result.has_key('ip_set_time_range_copy'):
                try:
                    self.group = self.form_result['ip_set_current_set'][0]['value']
                    datas = groupe_form.copy_time_range('admin',
                                             self.group,
                                             tools.format_form_result(self.form_result['ip_set_time_range_copy'])
                                                        )
                    datas['toexec'] = tools.make_js_link(self.server_nb, self.name, balise='ip_set_workspace', confirm=False, ip_set=self.group)
                except Exception, mess:
                    log.err()
                    datas = {'message':str(mess)}
                self.form_result = {}
                return self.send_frag(datas, template="amon_groupe_machine", templates=used_templates)

        if self.params.has_key('todel'):
            try:
                self.group = self.params['ip_set'][0]
                datas = groupe_form.del_time_range('admin', self.group, self.params['todel'][0])
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name, balise='ip_set_workspace', confirm=False, ip_set=self.group)
            except Exception, mess:
                log.err()
                datas = {'message':str(mess)}
            self.params.pop('todel')
            return self.send_frag(datas, template="amon_groupe_machine", templates=used_templates)

        if self.params.has_key('ip_set'):
            self.group = self.params['ip_set'][0]
            self.group_datas = groupe_form._get_group_datas('admin', self.group)
        elif self.group == None:
            datas = {'toexec': tools.make_js_link(self.server_nb, 'groupe_machine_admin')}
            return self.send_frag(datas, template="amon_groupe_machine", templates=used_templates)
        result = {'ip_set_name': self.group}
        result.update(groupe_form._get_time_range('admin', self.server_nb, self.name, self.group, self.group_datas))
        result['validate_time_range'] = self._get_validate_time_range_btn()
        result.update(groupe_form._get_copy_time_range_form('admin', self.group))
        result['validate_time_range_copy'] = self._get_copy_time_range_btn()
        result['close'] = groupe_form.get_close_btn()
        return self.send_all(result, template="amon_groupe_machine", templates=used_templates)

    def _get_validate_time_range_btn(self):
        """ renvoie la decsription du bouton de validation pour la définition de plage de temp """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['ip_set_time_range', 'ip_set_current_set'],
                                    balise='ip_set_time_range_msg')
        title = "Définir ces horaires pour ce groupe de machine."
        libelle = "Valider"
        icone = '/image/ok.gif'
        return dict(href=href, title=title, libelle=libelle, icone=icone)

    def _get_copy_time_range_btn(self):
        """ renvoie la description du bouton de validation pour la copie des plage temporelle """
        href = tools.make_form_link(self.server_nb, self.name, True, ['ip_set_time_range_copy', 'ip_set_current_set'], balise='ip_set_time_range_msg')
        title = "Copier les horaires de ce groupe"
        libelle = "Valider"
        icone = '/image/ok.gif'
        return dict(href=href, title=title, libelle=libelle, icone=icone)

