# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Eole - 2015 (Ministère Écologie - CPII)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action printers
# outil de gestion des imprimantes (gestion simplifiée et lien vers cups)
#
###########################################################################

from twisted.python import log
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.config.config import ip_locale, dico
from ConfigParser import ConfigParser

if dico['mode_conteneur_actif'] == 'oui':
    ADRESSE = dico['adresse_ip_internet_link']
else:
    ADRESSE = ip_locale
DEFAULT_ICON = '/image/machines.gif'
DEFAULT_URL = 'https://{0}'.format(ADRESSE)
INI_PATH = '/var/lib/eole/config/ead_external_tools_links.ini'

def ini_to_menu(config_file):
    """
    renvoie les informations d'une configuration sous la forme d'un menu ead
    :param configuration: fichier ini de configuration
    :type configuration: str
    """
    links = []
    config = ConfigParser()
    config.read(config_file)
    for base_url in config.sections():
        for option in config.options(base_url):
            url = '/'.join([base_url, config.get(base_url, option)])
            href = "javascript:OuvreFenetre('{0}', '{1}')"
            href = href.format(url, option)
            link = {'href': href,
                    'title': option,
                    'icone': DEFAULT_ICON,
                    'libelle': option}
            links.append(link)
    return links

class Links(Action):
    """ Page de présentation de liens
    """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'links'
    libelle = "Liens"
    category = "Outils/Outils externes"
    description = "Liens vers des outils externes"
    request = Dict(default={},
              doc="arguments de la requete en cours cote frontend",
              keys=['server', 'action', 'page'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json", keys=[])

    def execute(self):
        """ renvoie les données pour l'affichage de liens vers les applications externes
        """
        params, self.server_nb = tools.get_request(self.request)

        result = {'titre':self.description, 'soustitre':''}
        result.update(self._get_menu())
        return self.send_all(result, template='links')

    def _get_menu(self):
        """
        renvoie le menu avec les différents liés (déclarés dans la fonction ou dans un fichier annexe)
        """
        links = ini_to_menu(INI_PATH)
        return dict(menus=links)

