# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action générique
#
###########################################################################
from twisted.python import log
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.actions.seshat import seshat_tools as t
from ead2.config.config import dico
from seshat.backend import EAD_ROUTES, gen_routes, RELAY_FILE as RELAYHOSTS

used_templates = ['main', 'form', 'formselect', 'accordion']

class Routes(Action):
    """ Page """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = "routes"
    libelle = "Routes Exim"
    category = "Messagerie"
    description = "Gestion des routes pour Exim"

    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   #server et action sont les clés systématiques
                   keys=['server', 'action', 'delroute'])

    form_result = Dict(default={}, doc='retour de formulaire',
                       keys=['addroute'])

    def execute(self):
        params, self.server_nb = tools.get_request(self.request)
        # Dans le cas d'un formulaire:
        if self.form_result.has_key('addroute'):
            try:
                resultat = tools.format_form_result(self.form_result['addroute'])
                # datas: dico utilisé pour la templatisation
                domaine, adresse = resultat['domaine'], resultat['adresse']
                log.msg("+ ajout de la route : %s -> %s" % (domaine, adresse))
                res = t.add_route(EAD_ROUTES, domaine, adresse)
                if res:
                    gen_routes()

            except Exception, message:
                log.err()
            self.form_result = {}
        elif params.has_key('delroute'):
            domaine, adresse = params['delroute'][0].split('#')
            log.msg("+ suppression de la route : %s -> %s" % (domaine, adresse))
            res = t.del_route(EAD_ROUTES, domaine, adresse)
            if res:
                gen_routes()

        result = {} # variable renvoyée utilisée dans le template associé
        result.update(self._get_list(t.get_routes(EAD_ROUTES)))
        result.update(self._get_form())
        return self.send_all(result, template='seshat_routes',
                            templates=used_templates)

    def _get_list(self, routes):
        routes_list = []
        for dom, add in routes:
            libelle = "%s -> %s" % (dom, add)
            suppr_btn = dict(href=tools.make_js_link(self.server_nb, self.name,
                                                delroute='%s#%s' % (dom, add)),
                             libelle='', title='',
                             icone="/image/supprimer.gif", _class='btn')
            routes_list.append((libelle, suppr_btn))
        return dict(routes=routes_list)

    def _get_form(self):
        """
        construction du formulaire d'ajout des routes
        """
        label = """Domaine établissement<br/>
<i>(exemple : etab.%(nom_academie)s.%(suffixe_domaine_academique)s)</i>"""
        domaine = {'libelle': label % dico,
                    'name':'domaine', 'inline':'ok',
                    'onblur':"testVoid('domaine', 'error_domaine');"}
        adresse = {'libelle':'Adresse ip associée',
                    'name':'adresse', 'inline':'ok',
                    'onblur':"testVoid('adresse', 'error_adresse');"}
        valid_btn = {'libelle':'Valider', 'title':'', 'icone':'/image/ok.gif',
                     'href':tools.make_form_link(self.server_nb, self.name, True, ['addroute'])}
        return dict(domaine=domaine, adresse=adresse, valid_btn=valid_btn)

# /!\ cette action n'est actuellement plus utilisée sur 2.3 /!\ #
class RelayHosts(Action):
    """ Page """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = "relayhosts"
    libelle = "Hôtes"
    category = "Messagerie"
    description = "Gestion des hôtes à relayer"

    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   #server et action sont les clés systématiques
                   keys=['server', 'action', 'delhost'])

    form_result = Dict(default={}, doc='retour de formulaire',
                       keys=['addhost'])

    def execute(self):
        params, self.server_nb = tools.get_request(self.request)
        if dico['open_relay'] == 'oui':
            return self.send_all({'openrelay':'oui'},
                                 template='seshat_relayhosts',
                                 templates=used_templates)

        # Dans le cas d'un formulaire:
        if self.form_result.has_key('addhost'):
            try:
                resultat = tools.format_form_result(self.form_result['addhost'])
                # datas: dico utilisé pour la templatisation
                domaine = resultat['domaine']
                log.msg("+ ajout de l'hôte : %s" % (domaine))
                t.add_host(RELAYHOSTS, domaine)

            except Exception, message:
                log.err()
            self.form_result = {}
        elif params.has_key('delhost'):
            domaine = params['delhost'][0]
            log.msg("+ suppression de l'hôte : %s" % (domaine))
            try:
                t.del_host(RELAYHOSTS, domaine)
            except Exception, message:
                log.err()
        result = {} # variable renvoyée utilisée dans le template associé
        result.update(self._get_list(t.get_lines(RELAYHOSTS)))
        result.update(self._get_form())
        if 'message' in vars():
            result['message'] = message
        return self.send_all(result, template='seshat_relayhosts',
                            templates=used_templates)

    def _get_list(self, routes):
        routes_list = []
        for dom in routes:
            libelle = dom
            suppr_btn = dict(href=tools.make_js_link(self.server_nb, self.name,
                                                     delhost=dom),
                             libelle="", title="",
                             icone="/image/supprimer.gif", _class='btn')
            routes_list.append((libelle, suppr_btn))
        return dict(hosts=routes_list)

    def _get_form(self):
        domaine = {'libelle': "Hôte à ajouter",
                    'name':'domaine', 'inline':'ok',
                    'onblur':"testVoid('domaine', 'error_domaine');"}
        valid_btn = {'libelle':'Valider', 'title':'', 'icone':'/image/ok.gif',
                     'href':tools.make_form_link(self.server_nb, self.name, True, ['addhost'])}
        return dict(domaine=domaine, valid_btn=valid_btn)
