#-*- coding: utf-8 -*-
###########################################################################
## Eole NG - 2007
## Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
## Licence CeCill  cf /root/LicenceEole.txt
## eole@ac-dijon.fr
##
## serveur pour affichage des pages CGI de lightsquid
##
############################################################################
import xmlrpclib, time, hashlib, random

from twisted.web import server, twcgi, http
from twisted.web.resource import ErrorPage, Resource
from twisted.python import components
from twisted.internet import reactor
from zope.interface import Interface

from ead2.config.config import ip_locale, LIGHTSQUID_TIMEOUT, LIGHTSQUID_PORT
from ead2.lib.libbackend import PamAuth
from ead2.backend.lib.eadserver import _gain_privileges, _drop_privileges

# définition des classes servant a créer de nouvelles variables dans les sessions
class IPreferences(Interface):
    pass

class Preferences(components.Adapter):
    __implements__ = IPreferences

    def __init__(self,original):
        self.session_id = None
        components.Adapter.__init__(self,original)

def gen_random():
    random_id = str(time.time())
    random_id = hashlib.sha224('%s/%s' % (random_id, random.randrange(2**100)))
    return random_id

service_url = "https://{0}:{1}/index.cgi".format(ip_locale, LIGHTSQUID_PORT)

# formulaire d'authentification locale
LOCAL_AUTH_FORM = """
<body style="padding:0px;
    color:#000;
    font:Georgia,Verdana,Tahoma,Arial,sans-serif;
    margin:150px;">
<center>
<div id="squid_local_auth">
<p>Veuillez saisir le mot de passe de l'utilisateur "{0}"</p>
<FORM action={1} method="POST" name="squid_auth_form">
<input type='password' tabindex='1' name='squid_password' id='squid_password' title='Mot de passe'/>
<input type='submit' tabindex='2' value='Connexion'>
</FORM>
</div>
</center>
</body>
"""

components.registerAdapter(Preferences, server.Session, IPreferences)

class AuthForm(Resource):

    def render(self, request):
        if request.args.has_key('ticket'):
            user = "admin"
        else:
            user = "root"

        return LOCAL_AUTH_FORM.format(user, service_url)


class PerlScript(twcgi.CGIDirectory):

    def __init__(self, pathname, ead_server):
        self.ead_server = ead_server
        self.pam_auth = PamAuth()
        self.session_id = None
        self.app_ticket = None
        self.expire_callb = None
        self.timeout = LIGHTSQUID_TIMEOUT
        twcgi.CGIDirectory.__init__(self, pathname)

    filter = '/usr/bin/perl' # Points to the perl parser

    def getChild(self, path, request):
        """surcharge pour gérer l'authentification
        """
        session_id = None
        if request.args.has_key('ticket'):
            # vérification d'un ticket SSO
            app_ticket = request.args.get('ticket', [''])[0]
            auth_ok, user_data = self.ead_server.auth_server.get_user_details(app_ticket, service_url)
            if auth_ok and user_data['uid'][0] == 'admin':
                session_id = self.init_session(request)
                self.app_ticket = app_ticket
        elif request.args.has_key('squid_password'):
            # vérification du mot de passe de l'utilisateur admin (ldap)
            password = request.args.get('squid_password', [''])[0]
            _gain_privileges(self.ead_server.uid, self.ead_server.gid)
            try:
                auth_ok = self.pam_auth.authenticate('root', password)
            except:
                auth_ok = False
                import traceback
                traceback.print_exc()
            finally:
                _drop_privileges()
            if auth_ok:
                session_id = self.init_session(request)
                # on conserve le lien sur l'expiration de session pour
                # le réinitialiser dans touch_session
                self.expire_callb = reactor.callLater(self.timeout, self.close_session)
        else:
            session = request.getSession(IPreferences)
            session_id = session.session_id
            if request.args.has_key('logoutRequest'):
                # fermeture de la session en mode SSO, on vérifie que la requête
                # correspond bien au ticket fourni lors de la connexion
                if self.app_ticket in request.args['logoutRequest'][0]:
                    self.close_session()
        if session_id is not None and session_id == self.session_id:
            self.touch_session()
            # on a une session valide, on appelle le script CGI
            return twcgi.CGIDirectory.getChild(self, path, request)
        else:
            # non authentifié, on demande le mot de passe d'admin
            return AuthForm()
            # return ErrorPage(http.UNAUTHORIZED, "Accès non autorisé", "Veuillez saisir le mot de passe de l'utilisateur admin")

    def close_session(self):
        self.session_id = None

    def touch_session(self):
        if self.expire_callb and self.session_id:
            # on annule l'expiration de la session
            try:
                self.expire_callb.cancel()
            except:
                # déjà expiré ?
                pass
            # et on la réinitialise
            self.expire_callb = reactor.callLater(self.timeout, self.close_session)

    def init_session(self, request):
        # on annule les éventuels timeouts en attente
        if self.expire_callb:
            try:
                self.expire_callb.cancel()
            except:
                # déjà expiré ?
                pass
        self.expire_callb=None
        session = request.getSession(IPreferences)
        session_id = gen_random()
        session.session_id = session_id
        self.session_id = session_id
        return session_id
