# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action de gestion d'Acls
#
#
###########################################################################
"""
    gestion des Acls sur Scribe et horus
"""
from twisted.python import log
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.actions.lib.acls import editor
from ead2.backend.actions.lib.acls.filesystem import get_dir, get_dir_btns, \
js_escape

# liste des templates complémentaires utilisés
used_templates = ['main', 'form', 'formselect', 'accordion']

class Acls(Action):
    """ Gestion des Acls """
    user_description = Dict(default={},
                            doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = "acls" #celui de perm_nomdumodule.ini
    libelle = "Gestion des Acls"
    category = "Outils"
    description = "Gérer les Acls des fichiers et répertoires du serveur"

    #server et action sont les clés systématiques
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'path', 'dirname', 'thedirname'])

    form_result = Dict(default={}, doc='retour de formulaire', keys=[])

    def execute(self):
        params, self.server_nb = tools.get_request(self.request)
        if params.has_key('dirname') and params.has_key('path'):
            # ouverture d'un répertoire
            datas = get_dir(self.server_nb, self.name,
                            params['dirname'][0],
                            params['path'][0])
            return self.send_frag(datas, template='acls',
                                  templates=used_templates)

        elif params.has_key('thedirname') and params.has_key('path'):
            # fermeture d'un répertoire
            datas = dict(dirname=get_dir_btns(self.server_nb,
                                              self.name,
                                              params['thedirname'][0],
                                              js_escape(params['path'][0])))
            return self.send_frag(datas, template='acls',
                                  templates=used_templates)
        result = {'titre':"Gestion des Acls"}
        result.update(get_dir(self.server_nb, self.name))
        return self.send_all(result, template='acls',
                             templates=used_templates)

class AclEditor(Action):
    """ editeur d'Acls """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = "acls_editor" #celui de perm_nomdumodule.ini
    libelle = "Édition des Acls"
    category = None #"Outils"
    description = "Éditer les Acls d'un fichier ou d'un répertoire du serveur"

    #server et action sont les clés systématiques
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'path', 'dirname',
                         'todel', '_type'])
    form_result = Dict(default={}, doc='retour de formulaire',
                       keys=['acls_form'])

    def execute(self):
        params, self.server_nb = tools.get_request(self.request)

        # on récupère le path à éditer
        if not params.has_key('path'):
            result = {'toexec': tools.make_js_link(self.server_nb, 'acls',
                                                   confirm=True)}
            return self.send_all(result, template="acls_editor",
                                     templates=used_templates)
        else:
            path = js_escape(params['path'][0])

        if params.has_key('todel') and params.has_key('_type'):
            todel = params['todel'][0]
            _type = params['_type'][0]
            try:
                datas = editor.valid_del_acl(todel, _type, path)
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True,
                                                     balise="acls_workspace",
                                                     path=path)
            except Exception, message:
                datas = dict(message=message.message)
                log.err()
            return self.send_frag(datas, template="acls_editor",
                                         templates=used_templates)

        # des modifications ont été apportées: on valide
        if self.form_result != {}:
            result = tools.format_form_result(self.form_result['acls_form'],
                                              True)
            try:
                datas = editor.valid_acl_mod(result, path)
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=True,
                                                     balise="acls_workspace",
                                                     path=path)
            except Exception, message:
                datas = dict(message=message.message
                        )
                log.err()
            self.form_result = {}
            return self.send_frag(datas, template="acls_editor",
                                         templates=used_templates)

        result = {}
        result.update(editor.get_acl_editor(self.server_nb, self.name, path))
        result['toexec'] = "$('acls_workspace').style.display = 'block';$('acls_workspace').style.height='auto';"
        return self.send_all(result, template="acls_editor",
                                 templates=used_templates)
