#-*-coding:utf-8-*-
"""
    renvoie la description de l'arborescence de fichiers
    pour la gestion des Acls
"""
from os import listdir
from os.path import isfile, isdir, join, sep, dirname as pdirname
from ead2.backend.actions import tools
from ead2.backend.config.filenames import acl_root_dir as root_dir
from ead2.backend.config.config import EOLE_MODULE as module

# fonction principale (appelée depuis l'action ead
root_label = pdirname(root_dir).split(sep)[-1]

def get_dir(server_nb, name, dirname=root_label, path=root_dir):
    """
        renvoie le contenu de path/ pour mise en forme
        de type
        - dirname:
          + subdir
          subfile
        où subdir et subfile sont des boutons ainsi que + et -
        renvoie:
        main_btns = (bouton -, bouton mod_acl)
        dirbtns = [(bouton+, bouton mod_acl)...]
        filebtns = [(bouton_mod_acl)...]

    """
    path = deformat_path_from_html(path)
    if isdir(path):
        subdirs = [subdir for subdir in listdir(path) if valid_dirname(subdir, path)]
        subfiles = [subfile for subfile in listdir(path) if valid_filename(subfile, path)]
        subdirs.sort()
        subfiles.sort()

        main_btns = get_main_dir_btns(server_nb, name, dirname, js_escape(format_path_for_html(path)))
        dirbtns = [get_dir_btns(server_nb, name, subdir, js_escape(format_path_for_html(join(path, subdir))))for subdir in subdirs]
        filebtns = [get_file_btns(server_nb, name, subfile, js_escape(format_path_for_html(join(path, subfile))))for subfile in subfiles]

        return dict(main_btns=main_btns,
                    dirbtns=dirbtns,
                    filebtns=filebtns)
    else:
        raise Exception("répertoire non trouvé : %s" % path)

#########################
# BOUTONS

def get_main_dir_btns(server_nb, name, dirname, path):
    """
        renvoie les boutons pour le repertoire listé ( - nom du rep )
    """
    if dirname != root_label:
        btn1 = get_minus_btn(server_nb, name, dirname, path)
    else:
        btn1 = ""
    btn2 = get_mod_acl_btn(server_nb, name, dirname, path)
    return (btn1, btn2, get_dir_tagname(path), get_dir_subtagname(path))

def get_dir_btns(server_nb, name, dirname, path):
    """ renvoie les boutons pour les sous-reps
        (bouton + et bouton mod_acl)
    """
    btn1 = get_plus_btn(server_nb, name, dirname, path)
    btn2 = get_mod_acl_btn(server_nb, name, dirname, path)
    return (btn1, btn2, get_dir_tagname(path))

def get_file_btns(server_nb, name, filename, path):
    """
        renvoie le bouton d'appel pour le fichier filename
    """
    return get_mod_acl_btn(server_nb, name, filename, path, False)

def get_minus_btn(server_nb, name, dirname, path):
    """
        renvoie la description du bouton -
    """
    href = tools.make_js_link(server_nb, name, balise=get_dir_tagname(path),
                              path=path, thedirname=js_escape(dirname))
    title = "Réduire"
    icone = "/image/%s/closedir.png" % module
    libelle = ""
    _class = "minus-btn"
    return dict(href=href,
                title=title,
                icone=icone,
                libelle=libelle,
                _class=_class)

def get_plus_btn(server_nb, name, dirname, path):
    """
        renvoie la description du bouton de deploiement de repertoire
    """
    href = tools.make_js_link(server_nb, name, balise=get_dir_tagname(path),
                              dirname=js_escape(dirname), path=path)
    icone = "/image/%s/opendir.png" % module
    libelle = ""
    title = "Déployer %s" % dirname
    _class = "plus-btn"
    return dict(href=href,
                title=title,
                icone=icone,
                libelle=libelle,
                _class=_class)

def get_mod_acl_btn(server_nb, name, dirname, path, _isdir=True):
    """ renvoie la description du bouton d'appel
        pour le formulaire de modification d'Acls
    """
    href = tools.make_js_link(server_nb, 'acls_editor',
                              balise='acls_workspace',
                              dirname=js_escape(dirname),
                              path=path)
    if _isdir:
        icone = "/image/%s/dir.png" % module
    else:
        icone = "/image/%s/file.png" % module
    libelle = dirname
    title = "Éditer les Acls de %s" % dirname
    _class = "simple_link"
    return dict(href=href,
                title=title,
                icone=icone,
                libelle=libelle,
                _class=_class)

########################
## Utilitaires

def valid_dirname(dirname, path):
    """
        teste si le repertoire doit être listé
    """
    if isdir(join(path, dirname)) and not dirname.startswith('.'):
        return True
    return False

def valid_filename(filename, path):
    """
        teste si le fichier doit être listé
    """
    if isfile(join(path, filename)) and not filename.startswith('.'):
        return True
    return False

def get_dir_tagname(path):
    """ renvoie le nom de la div container du rep path """
    # /!\ on enlève les apostrophes pour les div /!\ #
    path = path.replace("\\'", "")
    return 'dir_'+path

def get_dir_subtagname(path):
    """ renvoie le nom de la div container du contenu du rep path """
    # /!\ on enlève les apostrophes pour les div /!\ #
    path = path.replace("\\'", "")
    return 'dir_'+path+'_subdiv'

def format_path_for_html(path):
    """
        formate le nom du chemin pour le passer en html
    """
    return path.replace('/', '___')

def deformat_path_from_html(path):
    """
        deformate le chemin depuis le format utilisé en html
    """
    return path.replace('___', '/')

def js_escape(name):
    """
        remplace les apastrophes pour la gestion javascript
    """
    return name.replace("'", "\\'")

def js_unescape(name):
    """
        remet les apastrophes pour la gestion javascript
    """
    return name.replace("\\'", "'")
