# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    Outil d'importation (extraction) pour scribe
    On choisit le type d'import (MAJ, nouvelle année)
    On choisit le format de fichier
    On choisit le type d'utilisateur à importer
    On choisit les préférences utilisateurs
    On valide les préférences, on redirige vers la page liée
                                au format de fichier choisit
"""
from twisted.python import log
from twisted.internet import defer

from scribe.importation.config import DATA_TYPE, CATEGORIES
from scribe.importation import log as importlog

from ead2.backend.actions.lib.widgets import ajax, main as M
from ead2.backend.lib.action import Dict

from ead2.backend.actions.lib.importation.base import BaseImportation


class Importation(BaseImportation):
    """
        Action d'entrée pour l'importation
        choix du type/format/catégorie
    """
    name = 'scribe_extraction'
    libelle = "Importation"
    category = "Outils"
    description = "Importation de données utilisateurs"
    request = Dict(keys=['action', 'server', 'import_type', 'data_type',
                         'category_type'])

    def execute(self):
        """ renvoie les données pour l'affichage
            insertion de la page de l'ead 1
        """
        self.parse_request()
        log.msg("# Importation (Extraction) de données première partie #")
        log.msg("# les parametres : %s" % self.params)
        return_dict = dict(title=self.description)
        defered = defer.Deferred()
        defered.callback(return_dict)
        etape = -1
        if not self.params.has_key('import_type'):
            # on vérifie les locks avant de se lancer...

            etape = 1
            log.msg("Étape 1 : Choix du type d'import")
            defered.addCallback(self._get_import_type_btns)

        elif not self.params.has_key('data_type'):
            importlog.start_importation('EAD')
            etape = 2
            import_type = self.params.get('import_type')[0]
            importlog.log.info("type d'import : %s" % (import_type,))
            log.msg("Étape 2 : On a choisi un type d'import : %s, on va \
demander le format de données " % (import_type,))
            defered.addCallback(self._get_data_type_btns)

        elif not self.params.has_key('category_type'):
            etape = 3
            data_type = self.params.get('data_type')[0]
            importlog.log.info("source de données : %s" % (data_type,))
            log.msg("Étape 3 : On a choisi le format de données : %s, \
on va demander quelle catégorie d'utilisateurs." % (data_type,))
            defered.addCallback(self._get_category_type_btns)

        defered.addCallback(self._test_lock)
        defered.addErrback(self._err_lock)
        defered.addCallback(self.main)
        defered.addErrback(self.send_error,
                   message="Une erreur est survenue à l'étape %s" % etape)
        return defered

    def _get_import_type_btns(self, return_dict):
        """
            Renvoie les boutons pour le choix de type d'import
            (maj/import annuel)
        """
        btn_maj = M.Lien(href=ajax.call(self.server_nb,
                                        self.name,
                                        import_type='maj'),
                           libelle="Mise à jour des bases")
        btn_annuel = M.Lien(href=ajax.call(self.server_nb,
                                        self.name,
                                        import_type='annuel'),
                           libelle="Importation annuelle des bases")
        return_dict['import_types'] = (btn_maj, btn_annuel)
        return_dict.update(self._get_bouton_retour())
        return return_dict

    def _get_data_type_btns(self, return_dict):
        """
            Renvoie les boutons pour le choix des types d'import
            sconet/aaf/...
        """
        data_types = list()
        for _type, libelle in DATA_TYPE:
            lien = ajax.call(self.server_nb,
                             self.name,
                             data_type=_type,
                             import_type=self.params.get('import_type')[0])
            data_types.append(M.Lien(href=lien, libelle=libelle))
        return_dict['data_types'] = data_types
        return_dict.update(self._get_bouton_retour())
        return return_dict

    def _get_category_type_btns(self, return_dict):
        """
            Rajoute les boutons pour le choix de catégories d'import
            (fichier élève, fichier enseignant)
        """
        category_types = list()
        data_type = self.params.get('data_type')[0]
        categories = CATEGORIES[data_type]
        for category_name, category_libelle in categories:
            lien = ajax.call(self.server_nb,
                             'scribe_extraction_preferences',
                             data_type=data_type,
                             import_type=self.params.get('import_type')[0],
                             category_type=category_name)
            category_types.append(M.Lien(href=lien,
                                         libelle=category_libelle.capitalize()))
        return_dict['category_types'] = category_types
        return_dict.update(self._get_bouton_retour(step=1))
        return return_dict
