# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action de configuration de vnc
#
###########################################################################
"""Actions permettant de configurer VNC """
from os.path import isfile
from twisted.python import log
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.config.filenames import vnc
from ead2.config.config import dico

# liste des templates complémentaires utilisés
used_templates = ['main', 'form', 'formselect']

# options proposées
options = ({'name':'simple', 'libelle':"visualisation simple"},
            {'name':'controle', 'libelle':"visualisation et contrôle"},
            {"name":'desactive', "libelle":"VNC désactivé"}
          )

# prise en compte du mode conteneur
FICHIER_PATH = dico.get('container_path_fichier', '')
VNC_FILE = FICHIER_PATH + vnc['conf_dir']

def set_conf(value):
    """ écrit la conf de vnc """
    if value not in ["simple", "desactive", "controle"]:
        raise Exception, "La valeur de configuration pour vnc n'est pas valable."
    f = file(VNC_FILE, 'w')
    f.write(value)
    f.close()

def get_conf():
    """ récupère la configuration en cours """
    if isfile(VNC_FILE):
        value = file(VNC_FILE).read()
        return value.strip()
    return "simple"

class VNC(Action):
    """ action de configuration de vnc """

    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = "scribe_vnc"
    libelle = "VNC"
    category = "Outils/"
    description = "Configuration du mode de contrôle"
    request = Dict(default={}, doc="Requête en cours côté frontend",
                   keys=['server', 'action'])
    form_result = Dict(default={},
                       doc="Résultat de formulaire provenant du frontend.",
                       keys = ['vnc_config'])

    def execute(self):
        """ répond au frontend et renvoie les données pour la mise en forme """
        params, self.server_nb = tools.get_request(self.request)
        if self.form_result.has_key('vnc_config'):
            try:
                datas = self._set_vnc_control_mode()
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                     confirm=True)
            except Exception, error:
                log.err("Erreur : vnc.py, %s"%error)
                datas = dict(message=error.message)
            self.form_result = {}
            return self.send_frag(datas, template="scribe_vnc",
                                  templates=used_templates)

        result = {'titre':'Configuration du mode de contrôle'}
        result.update(self._get_form())
        return self.send_all(result, template="scribe_vnc",
                             templates=used_templates)

    def _get_form(self):
        """ renvoie la description du formulaire de configuration du mode de contrôle """

        control_mode = {'name':'vnc_control_mode',
                         'options' : [{'name':'', 'options':options}],
                         'libelle' : "Mode de contrôle VNC (nouvelles connexions)"}

        conf = get_conf()
        control_mode = [({'name':'vnc_control_mode',
                         'libelle':'',
                         'value':opt['name'],
                         'inline':'ok'
                         },
                         opt['libelle'])for opt in options]
        for radio, libelle in control_mode:
            if radio['value'] == conf:
                radio['checked'] = 'ok'
        libelle = "Mode de contrôle VNC (nouvelles connexions)"

        validate_btn = {'href':tools.make_form_link(self.server_nb,
                                                    self.name, True,
                                                    ['vnc_config'],
                                                    balise='vnc_div_msg'),
                        'title':"Appliquer la configuration",
                        'libelle':'Valider',
                        'icone':'/image/ok.gif',
                        }

        return dict(control_mode=control_mode,
                    libelle=libelle,
                    validate=validate_btn)

    def _set_vnc_control_mode(self):
        """ applique la configuration du mode de contrôle choisie """
        resultat = tools.format_form_result(self.form_result['vnc_config'])
        if not resultat.has_key('vnc_control_mode'):
            log.err("Erreur: vnc.py, il manque des données de formulaire à la configuration.")
            raise Exception, "Erreur: il manque des données pour la configuration du mode de contrôle vnc."
        control = resultat['vnc_control_mode']
        set_conf(control)
        return dict(message="Le mode de contrôle a été défini en %s" % control)
