#-*-coding:utf-8-*-
""" description des formulaires de gestion utilisateurs pour guardian """
from twisted.python import log
from amon.era import postes as era_poste
from amon.era.main import bastion_restart
from amon.backend import get_interfaces
from ead2.backend.actions.amon import amon_tools as t
from sets import Set

zones_indices = {'admin':0, 'pedago':1}

poste_msgs = {'web':{'list_entete':"Adresses interdites d'accès web",
                      'list_libelle':"%(poste)s de %(hdeb)s à %(hfin)s du %(jdeb)s au %(jfin)s",
                      'list_header':"",
                      'default_list':"Aucune adresse n'est interdite de web",
                      'main':"liste des postes interdits de navigation web",
                     },
               'all':{'list_entete':"Adresses interdites de réseau",
                      'list_libelle':"%(poste)s est interdit tout le temps",
                      'list_header':"",
                      'default_list':"Aucune adresse n'est interdite de réseau",
                      "main":"liste des postes interdits de réseau",
                     },
               'destination':{'list_entete':"Destinations interdites",
                       'list_libelle': "%(poste)s",
                       'list_header':"",
                        'list_header':'',
                        'default_list':"Aucune destination n'a été interdite",
                        "main":"liste des destinations interdites",
                      },
              }

def get_poste_form(zone):
    """
        renvoie les données pour la mise en forme
        du formulaire d'interdiction de poste (interdiction de web ou tout réseau)
        @zone: pour l'instant zone ne serre à rien
    """
    ip = {'name':'poste', 'onblur':"testVoid('poste', 'poste')",
          'libelle':"Source à interdire"}
    heure_deb = {'name':'hdeb',
                 'options':[{'name':'heure de début',
                             'options':t.get_hours('7:00')}],
                 'libelle':"Heure de début"}
    heure_fin = {'name':'hfin',
                 'options':[{'name':'heure de fin',
                             'options':t.get_hours('19:00')}],
                 'libelle':"Heure de fin"}
    jour_deb = {'name':'jdeb',
                'options':[{'name':'jour de début',
                                   'options':t.get_days('lundi')}],
                'libelle':" du "}
    jour_fin = {'name':'jfin',
                'options':[{'name':'jour de fin',
                            'options':t.get_days('dimanche')}],
                'libelle':" au "}
    options = [{'name':name, 'libelle':"%s (%s)" % (libelle, name)} \
               for name, libelle in get_interfaces(zones_indices[zone]).items()]
    interface = {'name':'interface',
                 'options':[{'name':'', 'options':options}],
                 'libelle':"Interface associée à l'adresse"}
    niveau = {'options':[
                        ('Seulement le web',
                            {'name':'niveau', 'value':'web',
                            'checked':'true', 'inline':'ok'}),
                        ("Toute activité réseau<br/><i>interdiction permanente</i>",
                            {'name':'niveau', 'value':'all', 'inline':'ok'}),
                        ],
            'libelle':'Niveau de restriction'}

    if len(options)>1:
        return dict(ip=ip,
                heure_deb=heure_deb,
                heure_fin=heure_fin,
                jour_deb=jour_deb,
                jour_fin=jour_fin,
                niveau=niveau,
                interface=interface)
    else:
        return dict(ip=ip,
                heure_deb=heure_deb,
                heure_fin=heure_fin,
                jour_deb=jour_deb,
                jour_fin=jour_fin,
                niveau=niveau)

def get_destination_form(zone):
    """ renvoie le formulaire d'interdiction de destination """
    ip = {'name':'poste', 'onblur':"testVoid('poste', 'poste')",
                'libelle':"Destination à interdire"}
    options = [{'name':name, 'libelle':"%s (%s)" % (libelle, name)} \
               for name, libelle in get_interfaces(zones_indices[zone]).items()]
    interface = {'name':'interface',
                 'options':[{'name':'', 'options':options}],
                 'libelle':"Interface associée à la source"}
    if len(options)>1:
        return dict(ip=ip,
                    interface=interface)
    return dict(ip=ip)


def get_poste_list(zone, keyword='destination'):
    """
        récupère la liste des postes all, web, destination
        (tout réseau, web seulement ou destination)
    """
    if keyword == 'destination':
        sens = 'depuis'
    else:
        sens = 'sur'
    options = []
    for poste in era_poste.load_forbidden_poste(zones_indices[zone], keyword):
        option = {'name':poste['poste'],
                  'libelle':poste_msgs[keyword]['list_libelle'] % poste}
        if poste.has_key('interface'):
            option['libelle'] += " %s l'interface %s." % (sens, poste['interface'])
        options.append(option)
    if options == []:
        poste_list = poste_msgs[keyword]['default_list']
    else:
        poste_list = {'name':'to_del',
                      'options':[{'name':"", "options":options}],
                      'libelle':poste_msgs[keyword]['list_header'],
                      'multi':'ok'}
    return {'entete_%s' % keyword:poste_msgs[keyword]['list_entete'],
            'select_%s' % keyword:poste_list}

def add_poste(zone, resultat, keyword=None):
    """
        valide un formulaire d'ajout de poste

    """
    if keyword is None:
        keyword = resultat['niveau']

    all_postes = era_poste.load_forbidden_poste(zones_indices[zone], keyword)
    message = "L'adresse %s " % resultat['poste']
    if resultat['poste'] not in [poste['poste'] for poste in all_postes]:
        all_postes.append(resultat)
        era_poste.save_forbidden_poste(zones_indices[zone], keyword, all_postes)
        message += "a été ajoutée à la %s." % poste_msgs[keyword]['main']
        if bastion_restart():
            message += "\\n Le pare-feu a bien été redémarré."
        else:
            log.err("Erreur au redémarrage de bastion dans ead2/backend/actions/amon/poste_form.py (1)")
            message += "\\n Erreur: erreur à la mise en place des interdictions."
    else:
        message += "était déjà dans la %s" % poste_msgs[keyword]['main']

    return dict(message=message)

def mod_poste_list(zone, resultat, keyword='destination'):
    """ modifie la liste des postes
        @zone: admin ou pedago
        @resultat: liste de dico decrivant un poste
        @keyword: all/web/description
            (interdiction de tout le réseau, navigation web, destination)
    """
    todelpostes = resultat['to_del']
    if todelpostes != []:
        message = "Les adresses : \\n"
        all_postes = era_poste.load_forbidden_poste(zones_indices[zone], keyword)
        remaining_postes = Set([poste['poste'] for poste in all_postes]).difference(Set(todelpostes))
        tosave_postes = [poste for poste in all_postes if poste['poste'] in remaining_postes]
        era_poste.save_forbidden_poste(zones_indices[zone], keyword, tosave_postes)
        message += '\\n'.join(todelpostes)
        message += '\\nont été retirées de la %s' % poste_msgs[keyword]['main']
        if bastion_restart():
            message += "\\n Le pare-feu a bien été redémarré."
        else:
            log.err("Erreur au redémarrage de bastion dans ead2/backend/actions/amon/poste_form.py (2)")
            message += "\\n Erreur: erreur à la mise en place des interdictions."
    else:
        message = "Aucune modification n'a été effectuée."
    return dict(message=message)
