# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action ServerRestart et ServerStop
#
# Redémarre ou stoppe le serveur
#
###########################################################################

"""Actions effectuant des manoeuvres lourdes sur le serveur"""
from twisted.python import log
from twisted.internet import reactor
from pyeole.process import system_code
from ead2.backend.config.config import debug
from ead2.backend.lib.action import Action, Dict
from ead2.lib.libead import uni
from ead2.backend.actions import tools
from ead2.backend.config.filenames import reconf
TIMEOUT = 8

class Serverconfigure(Action):
    """Reconfiguration du serveur
    """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'server-configure'
    libelle = 'Reconfigurer'
    description = 'Reconfigurer le serveur'
    category = 'Système/Serveur'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'immediat'])

    def execute(self):
        """ renvoie les données pour la mise en page
            1 - Renvoie les données pour le bouton de lancement du reconfigure
            2 - Lance un reconfigure
        """
        params, self.server_nb = tools.get_request(self.request)
        result = {'titre':self.description}
        message = ''
        ## 2 -
        if params.has_key('immediat'):
            self.immediat = params['immediat']
            result['btn'] = ''
            message = "Le serveur va être reconfiguré et va peut-être redémarrer.\\nVous allez être déconnecté."
            if debug:
                log.msg("Reconfiguration du serveur", self.user_description)
            self.reconfigure_server()
        else:
            result['btn'] = self._get_btn()
        ## 1 -
        result['retour_msg'] = message
        result['retour_btn']  = get_retour_btn(self.server_nb)
        dico = {'template':"serveur", 'data':{'content':result}}
        return 0, uni(str(dico))

    def reconfigure_server(self):
        """ reconfigurer le serveur """
        # lancement avec at pour détacher l'action
        cmd = "/usr/bin/reconfigure --auto >%s 2>&1" % reconf['log']
        system_code(['at', 'now'], stdin=cmd)

    def _get_btn(self):
        """ renvoit la description du bouton reconfigurer """
        libelle = self.description
        icone = "/image/redemarrer.gif"
        jslink = tools.make_js_link(self.server_nb, self.name, confirm=True, immediat='True')
        href = tools.make_confirm_link("Etes-vous sûr de vouloir reconfigurer le serveur ?", jslink)
        return {'href':href, 'icone':icone, 'libelle':libelle}

class ServerReboot(Action):
    """Redémarrage du serveur
    :immediat: arret immediat ou non
    """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'server-reboot'
    libelle = 'Redémarrer'
    description = 'Redémarrer le serveur'
    category = 'Système/Serveur'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'immediat'])

    def execute(self):
        """ renvoie les données pour l'affichage
            1 - Renvoie la description du bouton de redémarrage
            2 - Lance le redémarrage du serveur
        """
        params, self.server_nb = tools.get_request(self.request)
        result = {'titre':self.description}
        message = ''
        ## 2 -
        if params.has_key('immediat'):
            self.immediat = params['immediat']
            result['btn'] = ''
            message = "Le serveur va redémarrer d'ici peu (%s secondes), vous allez être déconnecté." % TIMEOUT
            if debug:
                log.msg("Redémarrage du serveur", self.user_description)
            reactor.callLater(TIMEOUT, self.reboot_server)
        else:
            result['btn'] = self._get_btn()
        ## 1 -
        result['retour_msg'] = message
        result['retour_btn']  = get_retour_btn(self.server_nb)
        dico = {'template':"serveur", 'data':{'content':result}}
        return 0, uni(str(dico))

    def reboot_server(self):
        """ redémarre le serveur """
        tools.command_statusoutput("/sbin/reboot")

    def _get_btn(self):
        """ renvoit la description du bouton redemarrer """
        libelle = "Redémarrer le Serveur"
        icone = "/image/redemarrer.gif"
        jslink = tools.make_js_link(self.server_nb, self.name,
                                    confirm=True, immediat='True')
        href = tools.make_confirm_link("Etes-vous sûr de vouloir redémarrer le serveur ?", jslink)
        return {'href':href, 'icone':icone, 'libelle':libelle}

class ServerStop(Action):
    """arret du serveur
        :immediat: arret immediat ou non
    """
    user_description = Dict(default={}, doc="description de l'éxécutant",
                            keys=['ip', 'name', 'role'])
    name = 'server-stop'
    libelle = 'Arrêter'
    category = 'Système/Serveur'
    description = 'Arrêter le serveur'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'immediat'])

    def execute(self):
        """ renvoie les données pour l'affichage
            1 - renvoie la description du bouton d'arrêt
            2 - Arrête le serveur
        """
        params, self.server_nb = tools.get_request(self.request)
        result = {'titre':self.description}
        message = ''
        ## 2 -
        if params.has_key('immediat'):
            self.immediat = params['immediat']
            result['btn'] = ''
            message = "Le serveur va s'arrêter d'ici peu (%s secondes), vous allez être déconnecté." % TIMEOUT
            if debug:
                log.msg("Arrêt du serveur", self.user_description)
            reactor.callLater(TIMEOUT, self.stop_server)
        else:
            result['btn'] = self._get_btn()
        ## 1 -
        result['retour_msg'] = message
        result['retour_btn']  = get_retour_btn(self.server_nb)
        dico = {'template':"serveur", 'data':{'content':result}}
        return 0, uni(str(dico))

    def stop_server(self):
        """ arrête le serveur """
        tools.command_statusoutput("/sbin/halt")

    def _get_btn(self):
        """ renvoit la description du bouton redemarrer """
        libelle = "Arrêter le Serveur"
        icone = "/image/arreter.gif"
        jslink = tools.make_js_link(self.server_nb, self.name, confirm=True, immediat='True')
        href = tools.make_confirm_link("Etes-vous sûr de vouloir stopper le serveur ?", jslink)
        return {'href':href, 'icone':icone, 'libelle':libelle}

def get_retour_btn(server_nb):
    return {'href': tools.make_js_link(server_nb, 'main_status'),
            'icone': "/image/back.png",
            'libelle':"Revenir à la page d'accueil"}
