#-*-coding:utf-8-*-
"""
    Utilisataires de téléchargement de fichier
    css, javascript et image depuis le backend
"""
import urllib2, md5
from shutil import rmtree
from os import listdir, unlink, remove, symlink, makedirs
from os.path import join, isdir, islink

from twisted.python import log
from nevow.url import URL

from ead2.config.config import EADFILE_LISTEN_PORT
from ead2.frontend.web.config import (SCRIPT_DIR, IMAGE_DIR,
                                      STYLE_DIR, TEMPLATE_DIR, debug)
from ead2.frontend.web.lib.servers import servers

def clean_datas():
    """
        lancé à chaque démarrage
        supprime les fichiers web téléchargés:
            /image/upload/
            /style/upload/
            /script/upload/
        et supprime les templates deja downloadés.
    """
    # liste des modules historiques possédant des dl spécifiques
    modules = ['amon', 'amonecole', 'horus', 'scribe', 'eclair', 'esbl']
    for racine in [SCRIPT_DIR, STYLE_DIR, IMAGE_DIR]:
        upload_dir = join(racine, 'upload')
        if not isdir(upload_dir):
            makedirs(upload_dir)
        # vérification des liens symbolique
        # pour conserver la compatibilité #1325
        for module in modules:
            mlink = join(racine, module)
            if not islink(mlink):
                if isdir(mlink):
                    rmtree(mlink)
                symlink(upload_dir, mlink)
        # suppression des fichiers téléchargés
        for fic in listdir(upload_dir):
            remove(join(upload_dir, fic))
    # suppression des templates téléchargés
    for tmpl in listdir(TEMPLATE_DIR):
        name = join(TEMPLATE_DIR, tmpl)
        if not isdir(name):
            remove(name)
    # (ré)initialisation de l'__init__.py
    init = join(TEMPLATE_DIR, '__init__.py')
    file(init, 'w').write('')
    return True

def initialize_ead_files(session):
    """ initialise l'interface en chargeant les fichiers
        à inclure pour l'ead du serveur courant
        :session: objet session de nevow
        :session.ead_server: server en cour de traitement
    """
    magic = session.magic_number
    if session.ead_server is None:
        return

    # en 2.3, on télécharge tout sur tous les modules (cf. #1673)
    session.module_name = session.ead_server.get_module_name(magic)[1]

    # chemins d'import
    script_dir = join(SCRIPT_DIR, 'upload')
    style_dir = join(STYLE_DIR, 'upload')
    image_dir = join(IMAGE_DIR, 'upload')

    # listing des fichiers déjà présents sur le frontend
    act_scripts = str(listdir(script_dir))
    act_styles = str(listdir(style_dir))
    act_images = str(listdir(image_dir))

    # appel du backend pour lister les fichiers manquants
    call = {'script':act_scripts,
            'style':act_styles,
            'image':act_images}
    code, result = session.ead_server.execute_action(unicode('update_ead'),
                                                     call,
                                                     magic)
    if result == '{}':
        return
    try:
        result = eval(result)
    except:
        return
    url = servers().get_server(session.current_server)[0]
    url = URL.fromString(url)
    ead_file_url = url.secure(False)
    # recuperation des fichiers aupres du serveur http
    get_files(result['style'], 'style', style_dir, ead_file_url)
    get_files(result['script'], 'script', script_dir, ead_file_url)
    get_files(result['image'], 'image', image_dir, ead_file_url)

def get_files(files, keyword, typed_path, ead_file_url):
    """
        Récupère les fichiers de type keyword
    """
    http_path = "%s:%s" % (ead_file_url, EADFILE_LISTEN_PORT)
    for fil in files:
        from_path = join(join(http_path, keyword), fil)
        md5file = fil + '.md5'
        md5path = join(http_path, join('md5', join(keyword, md5file)))
        dest_path = join(typed_path, fil)
        get_file(from_path, md5path, dest_path)

def get_file(from_path, md5_path, dest_path):
    """telecharge "fich" et "fich.md5" sur serveur
        calcul le checksum de fich et le compare a celui contenu dans "fich.md5"
        :from_path: chemin vers le fichier a telecharger
        :md5_path: chemin vers le fichier md5
        :dest_path: chemin du fichier de destination
    """
    try:
        dest5 = dest_path + '.md5'
        if debug:
            log.msg('Telechargement de "%s"' % dest_path)
            log.msg('Telechargement depuis : %s' % from_path)
        file(dest_path, 'wb').write(urllib2.urlopen(from_path).read())
        file(dest5, 'wb').write(urllib2.urlopen(md5_path).read())
    except Exception, err:
        log.err("erreur")
        log.err(err)
        return None
    try:
        if check_sum(dest_path, dest5):
            # on supprime le fichier md5
            unlink(dest5)
            return dest_path
        else:
            return None
    except Exception, err:
        log.err("erreur md5 :")
        log.err(err)
        return None

def check_sum(fich, sumfich):
    """recupere le checksum contenu dans sumfich,
        calcule le checksum de fich
        et compare les deux
    """
    orig_sum = file(sumfich, 'r').readlines()[0].strip().split()[0].strip()
    dest_sum = md5.md5(file(fich,'rb').read()).hexdigest().strip()
    if orig_sum == dest_sum:
        return True
    else:
        return None

def get_js_files(dirname):
    """
        Renvoie la liste triée des fichiers javascript du répertoire
    """
    if isdir(dirname):
        script_list = listdir(dirname)
        script_list.sort()
        for script in script_list:
            if script.endswith('.js'):
                yield script
