#*-*coding:utf-8*-*
from ead2.backend.actions.tools import command_statusoutput

main_command = "/usr/bin/scp-remote %s "
main_command = "/usr/bin/ecm-remote %s "

# dico de lien keyword -> option de la commande
cmds = dict(disconnect = '-D',
#            lockdown = '-e /usr/bin/xlock -u',
            lockdown = '-l -u',
            process_list = '-p -u',
            kill='-k')
#UTILITAIRES
def get_users():
    """ renvoie la liste des utilisateurs connectés """
    status, user_list_str = command_statusoutput(main_command%"-U")
    user_list = [user_line.split(',')[1] for user_line in user_list_str.splitlines()]
    return user_list

def get_users_select():
    """
        renvoie les données pour la mise en forme d'une select
        pour la selection des users
    """
    entete = "Sélectionnez un (des utilisateurs) pour l'exécution d'action"
    users = get_users()
    options = [{'name':user, 'libelle':user}for user in get_users()]
    select = {'name':'user_list',
              'options':[{'name':'', 'options':options}],
              'multi':'true'
              }
    if not users:
        entete = "Il n'y a aucun utilisateur connecté"
        return dict(entete_user_list=entete)
    else:
        return dict(user_list_select=select,
                    entete_user_list=entete)

# FONCTIONS DE RETOUR POST-VALIDATION
def return_msg(keyword, result, user_list_str):
    """
        fonction de renvoi de message
    """
    if keyword == 'disconnect':
        message = "Les utilisateurs : \\n %s \\n ont bien été déconnectés." % user_list_str
    elif keyword == "lockdown":
        message = "Les postes des utilisateurs :\\n %s \\n ont bien été verrouillés." % user_list_str
    elif keyword == "kill":
        message = "Les processus ont bien été tués."
    else:
        message = "L'action demandée a bien été exécuté : %s." % result
    return dict(message=message)

def process_list(keyword, result, user_list_str):
    """
        renvoie la description de la select
        pour la selection du process à tuer
    """
    options = [dict(name=process_line.split(',')[1],
                    libelle=process_line.split(',')[1])
                for process_line in result.splitlines()
                if len(process_line.split(','))>1]
    select = {'name':"process_to_kill",
                'options':[{'name':'', 'options':options}],
                "libelle":"Sélectionnez le processus à tuer pour %s"%user_list_str,
                }
    # pour la memorisation (à la validation)
    users = {'name':'users', 'default_value':user_list_str}
    return dict(process_select=select,
                users=users)

# lien keyword-> fonction de retour après validation
return_funcs = {'disconnect':return_msg,
                'lockdown':return_msg,
                'process_list':process_list,
                'kill':return_msg,
                }
#EXECUTION DES COMMANDES

def do_cmd(keyword, item_list):
    """
        execute une commande
    """
    item_list_str = ','.join(item_list)
    cmd = main_command % cmds[keyword]
    cmd += item_list_str
    status, result = command_statusoutput(cmd)
    return return_funcs[keyword](keyword, result, item_list_str)

def kill(proc, users):
    """
        tue le process proc pour les utilisateurs de la liste users
    """
    message = "Le process %s a été tué\\n"%proc
    cmd = main_command%cmds["kill"]
    cmd += proc
    for user in users:
        if user.strip():
            status, result = command_statusoutput("%s -u %s"%(cmd, user.strip()))
            message += "pour l'utilisateur %s\\n"%user
    return dict(message=message)
