#!/usr/bin/python
#-*-coding:utf-8-*-
"""
    Script d'enregistrement d'action ead
    (crée un lien symbolique de l'action vers le répertoire cible)
"""
import getopt, sys
from os import system
from os.path import join, isfile, isdir, split

sys.path.append('/usr/share')

from ead2.backend.config.config import AVAILABLE_ACTION_DIR
DOC = """
Usage : register_action.py [PYFILEPATH]
Enregistre un fichier d'action ead
Crée un lien pointant vers pyfilepath depuis /etc/ead/sites-available/.
Il sera alors possible d'activer ce fichier action grâce au script /usr/share/ead2/backend/bin/enable_action.py

Ex :
1) register_action.py /root/monaction.py
Crée un lien symbolique de /etc/ead/sites-available/monaction.py vers /root/monaction.py
"""

def usage():
    """
        print la doc
    """
    print DOC

def test_target(target):
    """
        Teste la destination
    """
    if not isfile(target):
        print("-- WRONG PATH : THE ACTION FILE \"%s\" DOESN'T EXIST --" % (
                                                              target,))
        usage()
        sys.exit(2)

def test_linkname(linkname):
    """
        teste la dispo du lien symbolique
    """
    if isfile(linkname):
        print("Un fichier d'action du même nom existe déjà (\"%s\"), \
renommez votre fichier." % (linkname,))
        usage()
        sys.exit(2)

def mkdir(dirname):
    """
        Crée les repertoires si besoin
    """
    if not isdir(dirname):
        if system("/bin/mkdir -p %s" % (dirname,)) != 0:
            print("Une erreur est survenue à la création du répertoire \"%s\"" % (
                                                              dirname,))
            usage()
            exit(2)

def main():
    """
        lance la commande
    """
    try:
        opts, args = getopt.getopt(sys.argv[1:], "h", ["help"])
    except getopt.GetoptError, err:
        print str(err)
        usage()
        sys.exit(2)
    for option, value in opts:
        if option in ('-h', '--help'):
            usage()
            sys.exit(0)
    try:
        target = args[0]
    except IndexError:
        print("-- THE PATH TO THE ACTION FILE IS MISSING --")
        usage()
        sys.exit(2)

    test_target(target)

    actionfilename = split(target)[1]
    linkname = join(AVAILABLE_ACTION_DIR, actionfilename)
    test_linkname(linkname)

    # on crée le répertoire si il n'existe pas
    mkdir(AVAILABLE_ACTION_DIR)
    # on crée le lien symbolique
    print("Vous pouvez maintenant activer votre fichier action \
avec /usr/share/ead2/backend/bin/enable_action.py")
    exit(system("/bin/ln -s '%s' '%s'" % (target, linkname)) )

if __name__ == '__main__':
    main()
