# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action scribe_user*
# Creation d'utilisateur
# Recherche puis modification d'utilisateur
# modfication de mot de passe
# Supression d'utilisateur
#
###########################################################################
"""
Listing d'utilisateurs
"""
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions.lib.widgets import main as M
from ead2.backend.actions import tools
from ead2.backend.actions.scribe.tool import getform
from ead2.backend.actions.scribe.tool.user import used_templates, _get_menu


class UserListing(Action):
    """ renvoie le formuliare de listing utilisateur
    """
    user_description = Dict(default={}, doc="description de l'éxécutant",
                            keys=['ip', 'name', 'role'])
    name = 'scribe_user_list'
    libelle = "Recherche d'utilisateur"
    category = "Gestion/Utilisateurs/"
    description = 'Lister des utilisateurs'
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json", keys=[])

    def execute(self):
        """ renvoit les données pour l'affichage
        """
        params, self.server_nb = tools.get_request(self.request)
        result = {'titre':"Gestion des utilisateurs",
                  'sstitre':self.description}
        result.update(_get_menu(self.server_nb, self.name))
        result.update(getform._get_user_listing_form())
        result.update({'validate':self._get_valid_btn()})
        return self.send_all(result, template='scribe_users',
                             templates=used_templates)

    def _get_valid_btn(self):
        """ renvoie la description du bouton de validation de la recherche
            la cible du retour est la balise : user_div_container
        """
        href = tools.make_form_link(self.server_nb, 'scribe_user_table', True,
                                    ['search'], 'user_div_container')
        return M.Submit(href=href, libelle='Lister')
