# -*- coding: UTF-8 -*-
"""
    Chargement des actions
"""
import imp
from glob import glob
from os import listdir
from os.path import isfile, join, isdir
from twisted.python import log
from ead2.backend.lib import error
from ead2.backend.config.config import (CONFIG_DIR, ENABLED_ACTION_DIR,
                                        ACTION_DIR, debug)

def _list_actions_from_file():
    """
        Liste les actions disponibles depuis des fichiers textes
    """
    # actions de base
    fic_actions = [join(CONFIG_DIR, 'actions.cfg')]
    # actions supplémentaires
    fic_actions.extend(glob('%s/actions/actions_*.cfg' % CONFIG_DIR))
    # lecture des fichiers
    for fic_action in fic_actions:
        list_f = file(fic_action)
        for action in list_f.readlines():
            if not action.startswith('#'):
                if isfile(join(ACTION_DIR, "%s.py" % action.strip())):
                    yield action.strip()
                else:
                    if debug:
                        log.msg("/!\\ fichier d'action %s.py non trouvé /!\\" % action)

def _list_auto_registered_actions(directory=ENABLED_ACTION_DIR):
    """
        Liste les actions auto-enregistrées
    """
    if isdir(directory):
        for filename in listdir(directory):
            if filename.endswith('.py') and filename != '__init__.py':
                yield filename[:-3]

def load_action_pyfile(action_file, action_dir):
    """
        Importe un fichier .py
    """
    try:
        if debug:
            log.msg(" * Chargement de \"%s.py\"" % join(action_dir, action_file))
        filename, pathname, desc = imp.find_module(action_file,
                                                  [action_dir])
        imp.load_module(action_file, filename, pathname, desc)
    except ImportError:
        log.err("Error while loading module : \"%s\"" % (action_file))
    except Exception, msg:
        error.get_out("Error while loading the action file \"%s\": %s" % (
                                                            action_file, msg))


def load_actions():
    """
        charge les actions depuis le répertoire ACTION_DIR
    """
    if debug:
        log.msg("*** Chargement des actions")
    # chargement des actions enregistrés par fichier texte
    for action_file in _list_actions_from_file():
        load_action_pyfile(action_file, ACTION_DIR)
    # chargement des actions auto enregistrées
    if debug:
        log.msg("*** Chargement des actions auto")
    for action_file in _list_auto_registered_actions():
        load_action_pyfile(action_file, ENABLED_ACTION_DIR)
