# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action navigation_access
#
# Gere les interdiction d'acces de poste ou d'url ainsi que l'autorisation
# de moderateur
#
###########################################################################
""" Action de gestion des filtres web sur un amon """
from twisted.python import log

from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.actions.amon import menus
from ead2.backend.actions.amon.amon_tools import get_zone_libelle
from ead2.backend.actions.amon import poste_form

used_templates = ['main', 'form', 'formselect', 'accordion']
zone_libelle = get_zone_libelle(2)


def get_validate(server_nb, name):
    """ renvoie la description du bouton valider """
    return {'href':tools.make_form_link(server_nb, name,
                                        True,
                                        ['list_add'],
                                        balise='return_msg_container'),
             'icone':'/image/amon/ok.gif',
             'libelle':'Ajouter',
             'title':'Ajouter cette adresse'}

def get_validate_mod(server_nb, name, keyword=''):
    """ renvoie les données pour la mise en forme
    du bouton de modification de liste """
    return {'href':tools.make_form_link(server_nb, name,
                                        True,
                                        ['list_suppr_%s' % keyword],
                                        balise='return_msg_container'),
            'icone':'/image/supprimer.gif',
            'libelle':'Supprimer',
            'title':'Supprimer de la liste'}


class Poste(Action):
    """ interface de gestion des postes au niveau iptables"""
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'navigation_poste_pedago'
    libelle = 'Interdiction de poste'
    description = "Interdire des sources (%s)" % (zone_libelle.lower(),)
    category = None
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action'])
    form_result = Dict(default={},
                       doc="retour formulaire de la requete en cours coté frontend",
                       keys = ['list_suppr_web', 'list_add', 'list_suppr_all'])
    def execute(self):
        """ renvoie les données pour la mise en forme """
        params, self.server_nb = tools.get_request(self.request)
        if self.form_result.has_key('list_add'):
            try:
                datas = poste_form.add_poste('pedago',
                         tools.format_form_result(self.form_result['list_add'], ))
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True)
            except Exception, msg:
                log.err()
                datas = dict(message = msg.message)
            self.form_result = {}
            return self.send_frag(datas,
                                  template='amon_poste',
                                  templates=used_templates)
        elif self.form_result.has_key('list_suppr_web'):
            try:
                datas = poste_form.mod_poste_list('pedago',
                                tools.format_form_result(self.form_result['list_suppr_web']),
                                keyword='web')
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True)
            except Exception, msg:
                log.err()
                datas = dict(message = msg.message)
            self.form_result = {}
            return self.send_frag(datas,
                                  template='amon_poste',
                                  templates=used_templates)
        elif self.form_result.has_key('list_suppr_all'):
            try:
                datas = poste_form.mod_poste_list('pedago',
                                tools.format_form_result(self.form_result['list_suppr_all']),
                                keyword='all')
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True)
            except Exception, msg:
                log.err()
                datas = dict(message = msg.message)
            self.form_result = {}
            return self.send_frag(datas,
                                  template='amon_poste',
                                  templates=used_templates)
        result = {'titre':self.description}
        result['sstitre'] =  ''
        result['menus'] = menus._get_menu(self.server_nb,
                                          'navigation_poste',
                                          'pedago')
        result.update(poste_form.get_poste_form('pedago'))
        result.update(poste_form.get_poste_list('pedago', 'web'))
        result.update(poste_form.get_poste_list('pedago', 'all'))
        result['validate'] = get_validate(self.server_nb, self.name)
        result['validate_mod_web'] = get_validate_mod(self.server_nb, self.name, 'web')
        result['validate_mod_all'] = get_validate_mod(self.server_nb, self.name, 'all')
        return self.send_all(result,
                             template='amon_poste',
                             templates=used_templates)

class Destination(Action):
    """ interface de gestion des destinations au niveau iptables"""
    user_description = Dict(default={},
                            doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'navigation_destination_pedago'
    libelle = 'Sources et destinations'
    description = "Interdire des destinations (%s)" % (zone_libelle.lower(),)
    category = zone_libelle.capitalize()
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action'])
    form_result = Dict(default={},
                       doc="retour formulaire de la requete en cours coté frontend",
                       keys = ['list_suppr_destination', 'list_add'])
    def execute(self):
        """ renvoit les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)
        if self.form_result.has_key('list_add'):
            try:
                datas = poste_form.add_poste('pedago',
                         tools.format_form_result(self.form_result['list_add']),
                                            'destination')
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True)
            except Exception, msg:
                log.err()
                datas = dict(message = msg.message)
            self.form_result = {}
            return self.send_frag(datas,
                                  template='amon_poste',
                                  templates=used_templates)
        elif self.form_result.has_key('list_suppr_destination'):
            try:
                datas = poste_form.mod_poste_list('pedago',
                                tools.format_form_result(self.form_result['list_suppr_destination']),
                                keyword='destination')
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True)
            except Exception, msg:
                log.err()
                datas = dict(message = msg.message)
            self.form_result = {}
            return self.send_frag(datas,
                                  template='amon_poste',
                                  templates=used_templates)
        result = {'titre':self.description}
        result['sstitre'] =  ''
        result['menus'] = menus._get_menu(self.server_nb,
                                          'navigation_destination',
                                          'pedago')
        result.update(poste_form.get_destination_form('pedago'))
        result.update(poste_form.get_poste_list('pedago', 'destination'))
        result['validate'] = get_validate(self.server_nb, self.name)
        result['validate_mod_destination'] = get_validate_mod(self.server_nb, self.name, 'destination')
        return self.send_all(result,
                             template='amon_poste',
                             templates=used_templates)
