# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action UpdateEad
#
# Action permettant de lister les fichiers web(script, style et image)
# manquant au frontend
#
###########################################################################
from twisted.python import log
from ead2.backend.lib.action import *
from ead2.lib.libead import uni
from ead2.backend.actions.eclair import user
from ead2.backend.actions import tools


used_templates = ['main', 'form', 'formselect', 'accordion']

## Commande "gérer" les stations
#main_command = "/usr/bin/scp-remote"

# Liste des différents boutons d'actions
buttons = dict(disconnect = dict(libelle = "Deconnecter un utilisateur", title = "Deconnection", icone="/image/eclair/deconnecter.gif"),
              lockdown = dict(libelle = "Verrouiller une station", title = "Bloquer", icone="/image/eclair/block.png"),
              #unlock = dict(libelle = "Débloquer une station", title = "débloquer"),
              process_list = dict(libelle = "Lister les processus d'un utilisateur", title = "liste des processus", icone="/image/eclair/process.png")
          )

# Commandes necessitant un argument. i.e une zone a remplir
#(execute = dict(libelle = "Exécuter une commande sur une station", title = "Exécuter une commande"),
#(killer = dict(libelle = "Tuer un processus d'un utilisateur", title = "Tuer un processus"),
#(send_msg = dict(libelle = "Envoyer un message à un utilisateur", title = "Envoyer un message"),


# Liste des commandes associées au boutons
#cmds = dict(disconnect = '-D', lockdown = '-l', unlock = '-c', process_list = '-P')

class EclairEad(Action):
    """flag de mise a jour de l'ead
       cette action est specifique et lancee au moment de la connexion a un serveur
    """
    name = 'user'
    category = "Eclair"
    user_description = Dict(default={}, doc="Description de l'executant", keys=['name', 'role', 'ip'])
    request  =  Dict(default={}, doc="Arguments de la requête en cours côté frontend",
                        keys=['server', 'action'])
    description = 'outil de gestion eclair'
    libelle = "Connectés"
    form_result= Dict(default={}, doc='retour de formulaire',
                        keys=['user_list',
                              'disconnect',
                              'lockdown',
                              'process_list',
                              'process_select',
                              ])


    def execute(self):
        """
        Execution des commandes pour le module eclair via EAD2
        """
        self.params, self.server_nb = tools.get_request(self.request)

        # Construction des boutons (b)
        boutons = []
        for b in buttons.keys():
            btn = self.btn_factory(b)
            boutons.append(btn)

        #initialisation de la variable de retour
        result = dict(titre="Outil de gestion des clients légers EclairNG",
                      sstitre="",
                      boutons=boutons,
                      form_names=buttons.keys())

        #gestion des retours de formulaires
        if self.form_result.has_key('disconnect'):
            try:
                result.update(self.valid('disconnect',  tools.format_form_result(self.form_result['user_list'])))
            except:
                log.err()
                result.update(dict(message="Erreur à la déconnexion d'utilisateur."))
            self.form_result = {}

        if self.form_result.has_key('lockdown'):
            try:
                result.update(self.valid('lockdown',  tools.format_form_result(self.form_result['user_list'])))
            except:
                log.err()
                result.update(dict(message="Erreur au blocage de poste."))
            self.form_result = {}

        if self.form_result.has_key('process_list'):
            try:
                result.update(self.valid('process_list',  tools.format_form_result(self.form_result['user_list'])))
                result.update(self.get_kill_btn())
            except Exception, message:
                log.err()
                result.update(dict(message=message.message))
            self.form_result = {}

        if self.form_result.has_key('process_select'):
            try:
                datas = self.kill(tools.format_form_result(self.form_result['process_select']))
            except:
                log.err()
                datas = dict(message="Erreur à l'arrêt de processus.")
            self.form_result = {}
            return self.send_frag(datas, template='eclair', templates=used_templates)

        result.update(user.get_users_select())
        return self.send_all(result, template='eclair', templates=used_templates)

    def btn_factory(self, button):
        """Fabrique de boutons"""
        return dict(href=tools.make_form_link(self.server_nb,
                                            self.name,
                                            True,
                                            ['user_list', button],
                                            ),
                  title= buttons[button]['title'],
                  libelle=buttons[button]['libelle'],
                  icone=buttons[button]['icone'],
                  _class='simple_link')


    def valid(self, keyword, user_list=[]):
        """ valide l'execution de processus simple
            (blocage, listing de process, deconnection)
        """
        user_list = user_list['user_list']
        if user_list == []:
            raise Exception, "Aucun utilisateur n'a été sélectionné."
        return user.do_cmd(keyword,user_list)

    def kill(self, process):
        """
            valide l'arrêt de processus
        """
        user_list = process['users'].split()
        process = process['process_to_kill']
        print "kill : %s"%process
        print "pour : %s"%user_list
        return user.kill(process, user_list)

    def get_kill_btn(self):
        """
            renvoie la description du bouton de validation de tuage de processus
        """
        href = tools.make_form_link(self.server_nb, self.name,
                                    True,
                                    ['process_select'],
                                    'msg_container')
        title = "Killer les processus sélectionnés"
        icone = ""
        libelle = "Tuer les processus"
        return dict(kill_btn=dict(href=href,
                                  title=title,
                                  icone=icone,
                                  libelle=libelle)
                    )
#        commands.getstatusoutput(mds[keyword])

"""
  -u, --users              List of users to apply section to
  -e, --exec               Process to execute on users computer using --users
  -k, --kill               Process to kill on users computer using --users
  -m, --message            Message to send to users using --users
  -l, --lock               Lock selected users using --users
  -c, --unlock             Unlock selected users using --users
  -U, --return_users       Returns the current users list
  -P, --return_process     Returns the processes for the current user
  -L, --lockdown_user      Locks down selected user
  -D, --disconnect         Disconnect a selected pid
  -g, --return_groups      Returns the groups config
"""
