# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
#Test du module de gestion de profils
#
###########################################################################
""" teste role_editor_tools.py """
import autopath
from ead2.backend.actions.lib.profils import role_editor_tools as r
import os

def test_get():
    """ teste les méthodes get """
    m = r.UserRoleManager('/usr/share/ead2/backend/actions/lib/profils/tests/datas/role.ini')
    assert m.get_sections() == {'typeadmin':{'2':'prof_admin', '0':'prof'}, 
                                            'uid':{'admin':'admin'}}

def test_add():
    """ teste l'ajout et la suppression """
    if os.path.isfile('/usr/share/ead2/backend/actions/lib/profils/tests/datas/role_test.ini'):
        os.remove('/usr/share/ead2/backend/actions/lib/profils/tests/datas/role_test.ini')
#    r.role_filename = '/usr/share/ead2/backend/actions/lib/profils/tests/datas/role_test.ini'
    m = r.UserRoleManager('/usr/share/ead2/backend/actions/lib/profils/tests/datas/role_test.ini')
    m.add_role_key('typeadmin', '2', 'prof_admin')
    m.add_role_key('typeadmin', '0', 'prof')
    m.add_role_key('uid', 'admin', 'admin')
    assert m.get_sections() == {'typeadmin':{ '2':'prof_admin', '0':'prof'}, 
                                            'uid':{'admin':'admin'}}
    m.del_autorization('typeadmin', '2')
    assert m.get_sections() == {'typeadmin':{'0':'prof'}, 
                                                'uid':{'admin':'admin'}}
    m.del_role_autorizations('admin')
    assert m.get_sections() == {'typeadmin':{'0':'prof'}}
