# -*- coding: utf-8 -*-
###########################################################################
#
# Eole NG - 2010
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################
"""
Action permettant de lister les virus découverts
par l'anti-virus temps réél
"""
import re
from os import listdir
from os.path import join, isfile
from pyeole.process import system_out
from ead2.config.config import ANTIVIRUS_SAMBA
from ead2.backend.actions import tools
from ead2.backend.lib.action import Action, Dict

# liste des templates complémentaires utilisés
USED_TEMPLATES = ['main', 'form', 'formselect', 'accordion']

def get_virus():
    """
    Renvoie la liste des virus détéctés
    """
    log_path = '/var/log/rsyslog/local/scannedonlyd_clamav/'
    re_log = re.compile(r'scannedonlyd_clamav\.warning\.log-[0-9]{8}\.gz')
    max_vir = 30
    mois = {}
    mois["jan"] = "janvier" #idem
    mois["feb"] = "février"
    mois["fév"] = "février"
    mois["mar"] = "mars" #idem
    mois["apr"] = "avril"
    mois["avr"] = "avril"
    mois["may"] = "mai"
    mois["mai"] = "mai"
    mois["jun"] = "juin"
    mois["jui"] = "juin"
    mois["jul"] = "juillet" #idem
    mois["aug"] = "août"
    mois["aou"] = "août"
    mois["sep"] = "septembre" #idem
    mois["oct"] = "octobre"
    mois["nov"] = "novembre"
    mois["dec"] = "décembre"
    result = []
    viruses = []

    # fichier de log courant
    file1 = join(log_path, 'scannedonlyd_clamav.warning.log')
    if isfile(file1):
        lines = system_out(['grep', "contains virus", file1])[1].splitlines()
        lines.reverse()
        result.extend(lines)
    # fichier de log précédent
    file2 = [ path for path in listdir(log_path) if re_log.search(path)]
    if file2 != []:
        file2.sort()
        file2 = file2[-1]
        if isfile(file2):
            lines = system_out(['zgrep', "contains virus", file2])[1].splitlines()
            lines.reverse()
            result.extend(lines)
    if len(result) > max_vir:
        result = result[:max_vir]
    for ligne in result:
        try :
            moisfr = mois[ligne[0:3].lower()]
        except :
            moisfr = ligne[0:3]
        date = ligne[4:6]+" "+moisfr
        elts = ligne.split()
        fichier = ' '.join(elts[7:-3])
        virus = elts[-1][0:-1]
        client = 'unknown'
        viruses.append({'client':client, 'fichier':fichier,
                        'date':date, 'virus':virus})
    return dict(virus=viruses)


class ConnectedVirus(Action):
    """
    affichage des virus mise en quarantaine
    """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'virus'
    libelle = "Détection de virus"
    category = "Outils/"
    description = 'Virus détectés'
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'quota'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json", keys=[])

    def execute(self):
        """ renvoie les données pour l'affichage """
        params, self.server_nb = tools.get_request(self.request)
        result = {'titre':"Détection de virus", 'sstitre':self.description}
        if not ANTIVIRUS_SAMBA:
            result.update(virus="L'anti-virus temps réél est désactivé")
        else:
            result.update(get_virus())
        return self.send_all(result, template='scribe_connexion_quota',
                             templates=USED_TEMPLATES)

