#!/usr/bin/python
#-*-coding:utf-8-*-
"""
    Désactive un fichier d'action ead
"""
import getopt, sys
from os import system, listdir
from os.path import join

sys.path.append('/usr/share')

from ead2.backend.config.config import ENABLED_ACTION_DIR
DOC = """
Usage : disable_action.py [ACTIONNAME]
Désactive l'importation d'un fichier d'action par l'ead.
Supprime le lien /etc/ead/sites-enabled/ACTIONNAME.

Ex :
1) disable_action.py monaction.py
Supprime le lien /etc/ead/sites-enabled/monaction.py
"""

def usage():
    """
        print la doc
    """
    print DOC

def main():
    """
        lance la commande
    """
    try:
        opts, args = getopt.getopt(sys.argv[1:], "h", ["help"])
    except getopt.GetoptError, err:
        print str(err)
        usage()
        sys.exit(2)
    for option, value in opts:
        if option in ('-h', '--help'):
            usage()
            sys.exit(0)


    try:
        actionfilename = args[0]
    except:
        avlble = [aname for aname in listdir(ENABLED_ACTION_DIR)
                           if aname.endswith('.py')]
        if len(avlble) < 1:
            print("-- NO ACTION HAS BEEN REGISTERED : \
(see register_action.py) --")
            usage()
            sys.exit(2)
        print("Fichiers action activées :")
        for indice, actionname in enumerate(avlble):
            print("[%s] %s" % (indice, actionname,))
        action_indice = -1
        while action_indice not in range(len(avlble)):
            try:
                action_indice = int(raw_input("Numéro du fichier action à désactiver : "))
            except:
                action_indice = -1
        actionfilename = avlble[action_indice]

    linkname = join(ENABLED_ACTION_DIR, actionfilename)

    # on crée le lien symbolique
    exit(system("/bin/rm -f '%s'" % (linkname,)) )

if __name__ == '__main__':
    main()
