# -*- coding: UTF-8 -*-

import os
from popen2 import Popen3
from StringIO import StringIO



class Action(object):

    def __init__(self, name, description="", category='default', needs=None):
        """
        @param name: le nom de l'action
        @param description: la description de l'action
        @needs: la liste des objets (de leurs interfaces) requis
                pour exécuter l'action
        """
        self.params = {}
        self.name = name
        self.description = description
        self.category = category
        self.needs = needs or []
        self.stdout = StringIO()
        self.stderr = StringIO()
        self.status = None
        
    def do_it(self):
        """contient le code d'implémation de l'action
        XXX: pour l'instant, do_it() doit renvoyer pickle.dumps(self)
        """
        

class LocalScriptAction(Action):

    def __init__(self, executable, name, description="", category='default', needs=None):
        Action.__init__(self, name, description, category, needs)
        self.executable = executable
    
    def do_it(self):
        """Exécute le script localement"""
        # _, self.stdout, self.stderr = os.popen3(self.path)
        proc = Popen3(self.executable, capturestderr=True)
        self.status = proc.wait()
        self.stdout = proc.fromchild.read() or ''
        self.stderr = proc.childerr.read() or ''
        return pickle.dumps(self)

class DeferredScriptAction(Action):
    def __init__(self, path, name, description="", category='default', needs=None):
        Action.__init__(self, name, description, category, needs)
        argv = path.split()
        self.executable = argv[0]
        self.exc_args = argv[1:]
        splitted_path = self.executable.split(os.path.sep)
        if splitted_path:
            self.path = os.path.sep.join(splitted_path[:-1])
            self.executable = splitted_path[-1]
        else:
            self.path = '.'
            
    def execute(self):
        """returns a deferred ..."""
        from twisted.internet.utils import getProcessOutputAndValue
        d = getProcessOutputAndValue(self.executable, self.exc_args, path=self.path)
        d.addCallback(self.store_result)
        d.addCallback(self.serialized)
        return d

    def serialized(self, args):
        return pickle.dumps(self)

    def store_result(self, args):
        self.stdout, self.stderr, self.status = args

    def do_it(self):
        return self.execute()

ScriptAction = DeferredScriptAction

class FunctionAction(Action):
    def __init__(self, name, func, params, description="", category='default', needs=None):
        Action.__init__(self, name, description, category, needs)
        self.func = func
        self.params = params
        
    def do_it(self, params):
        self.func(self, **params)
        return pickle.dumps(self)

try:
    set
except NameError:
    from sets import Set
    set = Set

class NamedSet(set):
    """Implémentation d'un set nommé (réel intérêt ?)"""
    def __init__(self, name, iterable=()):
        set.__init__(self, iterable)
        self.name = name

    def __repr__(self):
        return '<NamedSet %s (%s) at %s>' % (self.name, self, hex(id(self)))

class ActionGroup(NamedSet):
    """Implémentation d'un groupe d'actions"""
