# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
    Importation be1d
"""
from ead2.backend.lib.action import Dict

from ead2.backend.actions.lib.importation.fichier import BaseImportationFichier
from scribe.importation.config import (BE1D_FILES,
                                       BE1D_FILEVARNAMES)

class ImportationBe1d(BaseImportationFichier):
    """
        Importation de type Be1d
        Téléchargement / Parsing / Importation
    """
    data_type = 'be1d'
    name = 'scribe_extraction_be1d'
    description = 'Importation de fichier be1d'
    libelle = description
    all_file_descriptions = BE1D_FILES
    request_keys = ['server',
                    'action',
                    'category_type',
                    'import_type',
                    'data_type',
                    'nomdefichier',
                    'filename',
                    'finished',
                    'parse',
                    'refresh_parse',
                    'importation',
                    'refresh_importation',
                    ]

    # variable de reception du contenu de fichier (original)
    origfilevarnames  = BE1D_FILEVARNAMES

    # pool pour les noms de variables de réception
    filevarnames = []
    request_keys.extend(BE1D_FILEVARNAMES['eleve'])
    request = Dict(default={}, keys=request_keys)
    file_download_entete = "Importation de '%s' au format : BE1D"
