# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Action scribe_share
# Edition de la lettre de lecteur pour les partages
#
###########################################################################
from twisted.python import log
from scribe import eoleshare
from ead2.lib.error import MissingKey, MissingValue
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions.lib.widgets import form as F, main as M
from ead2.backend.actions.tools import get_request, make_form_link, format_form_result

used_templates = ['main', 'form', 'formselect']

class Share(Action):
    """ attribut une nouvelle lettre de lecteur à un partage """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'scribe_share'
    libelle = "Lettre de lecteur"
    category = "Gestion/Partages/"
    description = "Gestion des lettres de lecteur"
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                                keys=['server', 'action'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json", keys=['share_edit'])

    def execute(self):
        """ Renvoi les données pour l'affichage de l'édition des partages
            1 - renvoie du formulaire et de la liste des lettres atribuées
            2 - valide l'attribution de lettre
        """
        params, self.server_nb = get_request(self.request)
        result = {'titre':self.description}
        ## 2 -
        if self.form_result != {}:# validation de formulaire
            try:
                result.update(self._valid_form())
            except (MissingKey, MissingValue, Exception), mess:
                log.err("Erreur dans share.py : %s"%mess)
                result.update({'message':mess.message})
            self.form_result = {}
        ## 1 -
        result.update(self._get_form())
        result.update(self._get_attributed_letters())
        return self.send_all(result, template='scribe_share', templates=used_templates)

    def _get_attributed_letters(self):
        """ renvoie les données pour l'affichage des lettres déjà utilisées """
        shares = []
        for name, letter in eoleshare.Share().get_reserved_letters().items():
            if name in eoleshare.EOLE_SHARES:
                shares.append({'name':"%s (Réservé Eole)" % name,
                               'letter':letter})
            else:
                shares.insert(0, {'name':name, 'letter':letter})
        return dict(share_list=shares, share_list_title="Rappel des lettres déjà réservées")

    def _get_form(self):
        """ renvoie la description du formulaire de gestion de partages """
        share_name = F.Select(name='share_name', inline=True,
                              libelle='Partage disponible')
        all_shares = set(eoleshare.Share().get_shares().keys())
        eole_shares = set(eoleshare.EOLE_SHARES)
        shares = list(all_shares - eole_shares)
        shares.sort()
        for sha in shares:
            share_name.add_option(sha)

        share_letter = F.Input(name='share_letter',
                                libelle="Lettre de lecteur à appliquer <br />(ex : k:)<br />(vide pour inactif)",
                                inline=True)

        validate = M.Submit(href=make_form_link(self.server_nb, self.name, True, ['share_edit']),
                            title="Attribuer cette lettre à ce partage")
        return dict(share_name=share_name, share_letter=share_letter, validate=validate)

    def _valid_form(self):
        """ valide l'attribution de lettre à un partage """
        if not self.form_result.has_key('share_edit'):
            raise MissingKey, "Erreur : des données manquent pour l'attribution de la lettre de partage."
        resultat = format_form_result(self.form_result['share_edit'])
        if not resultat.has_key('share_name') or not resultat.has_key('share_letter'):
            raise MissingKey, "Erreur : des données manquent pour l'attribution de la lettre de partage."
        ldapshare = eoleshare.Share()
        ldapshare.ldap_admin.connect()
        share_name = resultat['share_name']
        share_letter = resultat['share_letter'].strip()
        letters = [let.upper() for let in ldapshare._get_shares().values()]
        # FIXME !!!
        #letters.extend([let.upper() for let in backend.get_eole_shares().values()])
        if share_letter:## si on a une lettre, on vérifie qu'elle n'est pas déjà attribuée
            if ':' not in share_letter:
                share_letter += ':'
            if not self.test_letter(share_letter):
                raise MissingKey, "Erreur : la syntaxe est incorrect ex : 'k:'"
            if share_letter.upper() in letters:
                raise MissingKey, "Erreur : la lettre de partage est déjà attribuée."
        elif ldapshare._get_shares()[share_name].strip() == '':
            raise MissingKey, "Erreur : le partage n'a pas encore de lettre attribuée\\n (impossible de la supprimer)."
        ldapshare._set_share_drive(share_name, share_letter)
        ldapshare.ldap_admin.close()
        if share_letter == '':
            return dict(message="Le partage %s n'a plus de lettre de lecteur associé" % share_name)
        return dict(message="Le partage %s est désormais associé à la lettre de lecteur %s" % (share_name, share_letter))

    def test_letter(self, letter):
        """
        teste si la lettre de lecteur est valide
        """
        if letter[0].upper() not in [chr(i).upper() for i in range(97, 123)]:
            return False
        if len(letter) > 1:
            if len(letter) == 2:
                if letter[1] != ':':
                    return False
            else:
                return False
        return True

