# -*- coding: UTF-8 -*-
from twisted.python import log
import sys
"""
Erreurs du backend EAD2
"""

class Expired(Exception):
    """ magic number est expiré """
    pass

class UnknownFrontend(Exception):
    """ Frontend inconnu """
    pass

class ValueEoleError(Exception):
    """Cette valeur n'existe pas"""
    pass

class TypeEoleError(Exception):
    """Erreur de type"""
    pass

class ConfigError(Exception):
    pass

class FileNotFound(ConfigError):
    pass

class DependencyError(ConfigError):
    pass

class SignatureError(Exception):
    """Mauvais paramètre passé à une action
    """
    pass

class ConstraintError(ConfigError):
    pass

class ActionAlreadyRegistered(Exception):
    """Cette action a déjà été définie"""
    pass

def get_out(message):
    """
    Gestion des erreurs empêchant le démarrage de l'EAD
    """
    log.err()
    log.err("")
    log.err(message)
    log.err("** L'EAD n'a pas pu démarrer correctement **")
    log.err("")
    sys.exit(1)

