# -*- coding: utf-8 -*-
"""
formatage des donnees et utilisation des gabarits Cheetah pour l'affichage
"""
from twisted.python import log
from nevow import tags as T
import urllib, commands, traceback
from os import unlink, path as osp

from Cheetah.Template import Template as ChtTemplate
from Cheetah.NameMapper import NotFound as CheetahNotFound

from ead2.lib.error import TemplateError
from ead2.frontend.web.config import TEMPLATE_DIR, debug


# repris de creoletemplate
class IsDefined(object):
    """
    filtre permettant de ne pas lever d'exception au cas où
    la variable EAD n'est pas définie
    """

    def __init__(self, context):
        self.context = context

    def __call__(self, varname):
        # is_defined is supposed to be a callable
        if debug:
            log.msg("Appel à is_defined")
            log.msg(varname)
            log.msg(self.context)
        return varname in self.context

class CheetahTemplate(ChtTemplate):
    """personnalise et facilite la construction
    du template Cheetah
    """
    def __init__(self, filename, context):
        builtins = {}
        ChtTemplate.__init__(self, file=filename,
                             searchList=[context, builtins,
                                         {'is_defined':IsDefined(context)}]
                            )

def is_available(template):
    """:Returns:
    - True si le gabarit est disponible
    - False sinon
    """
    if osp.isfile(osp.join(TEMPLATE_DIR, '%s.tmpl' % template)):
        return True
    return False

def write_template(template, content):
    """
    recupere un template depuis le frontend web
    s'il n'est pas disponible en local
    :template: nom du template
    :content: contenu du template
    """
    try:
        filename = osp.join(TEMPLATE_DIR, '%s.tmpl' % template)
        fh = file(filename, 'w')
        fh.write(content)
        fh.close()
    except Exception, mess:
        fh.close()
        delete_template(template)
        raise Exception, "Erreur à l'écriture du template %s (%s)" % (template, mess)

def delete_template(template):
    """ supprime un template non conforme """
    filename = osp.join(TEMPLATE_DIR, '%s.tmpl' % template)
    unlink(filename)

def instanciate_template(template, context):
    """instancie un gabarit
    :Returns: la chaine instanciee
    """
    template_name = osp.join(TEMPLATE_DIR, '%s.tmpl' % template)
    try:
        chtpl = CheetahTemplate(template_name, context['data']['content'])
        #chtpl = ChtTemplate(file=template_name, searchList=[context['data']['content'],{}])
        result = str(chtpl)
    except CheetahNotFound, err:
        # utiliser a ce moment la un template par default
        delete_template(template)
        raise TemplateError, "erreur dans l'instanciation du template %s" % template
    return str(result)

def compile_template(template):
    if not is_compiled(template):
        template_name = osp.join(TEMPLATE_DIR, '%s.tmpl' % template)
        cmd = """/usr/bin/cheetah-compile %s""" % template_name
        commands.getstatusoutput(cmd)

def is_compiled(template):
    """ vérifie la présence du fichier python"""
    compiled_name = osp.join(TEMPLATE_DIR, '%s.py' % template)
    if osp.isfile(compiled_name):
        return True
    return False


def format_action(result, proxy, magic_nb):
    """
    :proxy: le backend xml-rpc
    :result: resultat de la sortie de l'action

    dans le resultat de l'action, un dictionnaire
    comprend:

    - une clef 'template' (le gabarit)
    - une clef 'data' (le resultat de l'action proprement dit)

    dans 'data' :
        - une clef 'content', qui est un contenu par defaut eventuellement
        - d'autres clefs qui peuvent etre utilisees comme variables de gabarit
            (templates: widgets utilises)
    """
    # texte d'erreur par défaut
    error_text = ""
    # unescape les caracteres speciaux apres le passage par xml-rpc
    result = urllib.unquote(result)
    # evalutation de la liste des sorties
    try:
        content = eval(result)
        data = content['data']
    except:
        # si ce qui est renvoye n'est pas normalise, c'est une chaine
        content = result
        data = content

    if type(data) == dict:
        if data.has_key('templates'):
            plugins = data['templates']
            for plug in plugins:
                if not is_available(plug):
                    content_plug = proxy.get_template(plug, magic_nb)[1]
                    write_template(plug, content_plug)
                compile_template(plug)

    if type(content) != str:
        if content.has_key('template'):
            try:
                # le template existe
                template = content['template']
                if is_available(template):
                    # le template est disponible
                    res = instanciate_template(template, content)
                    return T.xml(res)
                else:
                    # le template n'est pas disponible
                    try:
                        # tentative de recuperation du template
                        _, content_template = proxy.get_template(template, magic_nb)
                        write_template(template, content_template)
                        # instanciation cheetah
                        res = instanciate_template(template, content)
                        return T.xml(res)
                    except Exception, err:
                        # impossible de recuperer le template demande
                        raise Exception, err.message
            except Exception, err:
                log.err("Echec du templating (soit la forme soit le contenu)")
                traceback.print_exc()
                error_text = err.message

    return T.div[
                    T.p["Une erreur est survenue lors de la mise en forme de l'action demandée:"],
                    T.div[T.p["L'erreur suivante s'est produite: ", T.b[error_text]]],
                    T.a(href="javascript:Increase('div_contenu');", style='text_decoration:underline;')["Afficher le contenu reçu"],
                    T.div(_id='div_contenu', style="display:none;")[str(data)]
                ]

def put_to_nevow_xml(_list):
    """ rend des elements nevow depuis une liste de string"""
    result = []
    for i in _list:
        result.append(T.div[i])
    return result
