# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
#
###########################################################################
from twisted.python import log

from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
import ead2.backend.actions.amon.amon_tools as t
from ead2.backend.actions.amon import user
from ead2.backend.config.config import debug

used_templates = ['main','form', 'formselect', 'accordion']
zone_libelle = t.get_zone_libelle(1)

class Useradmin(Action):
    """
        interface de gestion des utilisateurs
        sur l'instance 0 de guardian
    """
    user_description = Dict(default={},
                            doc="description de l'éxécutant",
                            keys=['ip', 'name', 'role'])
    name = 'user_admin'
    libelle = 'Utilisateurs'
    description = "Gestion des utilisateurs sur '%s'" % (
                                    zone_libelle.lower(),)
    category = zone_libelle.capitalize()
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend",
                    keys=['server', 'action', 'todel', 'policy', 'user'])
    form_result = Dict(default={}, doc="retour formulaire de la requete en cours coté frontend",
                        keys = ['create_user'])

    def execute(self):
        """ renvoit les données pour la mise en forme
        """
        params, self.server_nb = tools.get_request(self.request)
        if self.form_result.has_key('create_user'):
            try:
                datas = user.add_user('admin',
                                      tools.format_form_result(
                                          self.form_result['create_user']))
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=True)
            except Exception, msg:
                log.err()
                datas = dict(message=msg.message)
            self.form_result = {}
            return self.send_frag(datas, template='amon_user',
                                         templates=used_templates)

        elif params.has_key('policy'):
            if params.has_key('user'):
                u = params['user'][0]
                policy = params['policy'][0]
                try:
                    if debug:
                        log.msg("++++ user_admin.py : Modification de la politique de filtrage de %s."%u)
                    datas = user.mod_user('admin', policy, u)
                    datas['toexec'] = tools.make_js_link(self.server_nb, self.name, confirm=True)
                except Exception, msg:
                    log.err()
                    datas = dict(message=msg.message)
                self.form_result = {}
                return self.send_frag(datas, template='amon_user',
                                             templates=used_templates)
        elif params.has_key('todel'):
            u = params['todel'][0]
            try:
                if debug:
                    log.msg("++++ user_admin.py : Suppression de la référence à %s."%u)
                datas = user.del_user('admin', u)
                datas['toexec'] = tools.make_js_link(self.server_nb, self.name, confirm=True)
            except Exception, msg:
                log.err()
                datas = dict(message=msg.message)
            self.form_result = {}
            return self.send_frag(datas, template='amon_user',
                                         templates=used_templates)

        result = {'titre': self.description}
        result.update(user.add_form('admin'))
        result.update(user.get_list('admin', self.server_nb, self.name))
        result['validate'] = user.get_validate(self.server_nb, self.name)
        return self.send_all(result, template='amon_user',
                                     templates=used_templates)
