# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2009
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""Actions permettant de supprimer les utilisateurs"""

from twisted.python import log
from scribe.linker import user_factory
from scribe.eoletools import calc_recycle_dir

from ead2.lib.error import MissingValue
from ead2.backend.config.config import debug
from ead2.backend.actions import tools
from ead2.backend.actions.lib.widgets import form as F, main as M, ajax
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions.scribe.tool import scribe_tools
from ead2.backend.actions.scribe.tool.user import used_templates


class UserDelete(Action):
    """ Supprime un utilisateur
        cette action est accessible par prof_admin
    """
    user_description = Dict(default={}, doc="description de l'exécutant",
                            keys=['ip', 'name', 'role'])
    name = 'scribe_user_delete'
    libelle = "Suppression"
    category = None
    description = 'Supprimer un utilisateur'
    # variables locales
    user = ''
    server_nb = ''
    request = Dict(default={},
                   doc="arguments de la requete en cours cote frontend",
                   keys=['server', 'action', 'user'])
    form_result = Dict(default={}, doc="Retour de formulaire en Json",
                       keys=['del_user'])

    def execute(self):
        """
            supprime un utilisateur (depuis un lien js, pas de formulaire)
        """
        params, self.server_nb = tools.get_request(self.request)
        self.user = ''
        result = {}
        if params.has_key('user'):
            user = params['user'][0].strip()
            if debug:
                log.msg("# On demande le formulaire de confirmation de \
                                    suppression du user : %s # " % user)
            result.update(self._get_form(user))
        elif self.form_result.has_key('del_user'):
            if debug:
                log.msg("# Suppression d'utilisateur #")
            try:
                result.update(self.del_user())
            except Exception, error:
                log.err("  !!!!   Échec de la suppression d'utilisateur  !!!!")
                result.update(dict(message=error.message))
        return self.send_all(result,
                             template='scribe_user_delete',
                             templates=used_templates)

    def _get_form(self, todel):
        """
            renvoie le formulaire de confirmation
            de suppression d'utilisateur
        """
        confirm = {}
        confirm['del_datas'] = F.Checkbox(name='del_datas',
                                          inline=True,
                                          checked=True,
                                          libelle="Supprimer également \
les données de l'utilisateur '%s'" % todel)
        confirm['user'] = F.Input(name='user', default=todel)
        confirm['validate'] = self._get_valid_btn()
        confirm['close_btn'] = M.CloseBtn(balise='mod_user_div_container',
                                          _class='scribe_close_btn')
        if user_factory(todel)._type == 'eleves':
            confirm['del_resp'] = F.Checkbox(name='del_resp',
                                             inline=True,
                                             checked=True,
                                             libelle="Supprimer les \
responsables de l'utilisateur '%s' si nécessaire" % todel)
        return confirm

    def _get_valid_btn(self):
        """ renvoie la description du bouton valider """
        href = ajax.valid(self.server_nb, self.name,
                          ['del_user'],
                          'mod_user_div_container')
        return M.Submit(href=href, title="Supprimer l'utilisateur")

    def del_user(self):
        """ supprime un utilisateur """
        formulaire = tools.format_form_result(self.form_result['del_user'],
                                              True)
        user = formulaire.get('user', None)
        del_datas = formulaire.get('del_datas', False)
        if debug:
            log.msg("  + Suppression de l'utilisateur '%s'" % user)
            log.msg("  + On supprime ses données : '%s'" % del_datas)
        if not user:
            raise MissingValue("!!!  Il manque le nom de l'utilisateur  !!!")

        if scribe_tools.is_prof_admin(self.user_description['role']):
            # un prof_admin ne peut modifier que ses eleves
            prof = self.user_description['name']
            if not scribe_tools.is_eleve_from_prof(user, prof):
                raise Exception("Action non autorisée.")

        if user == 'admin':
            raise Exception("Il n'est pas possible de supprimer 'admin' \
depuis cette interface")
        ldapuser = user_factory(user)
        if formulaire.get('del_resp'):
            # élève + responsables
            ldapuser.delete(user, remove_data=del_datas, delete_resp=True)
        else:
            ldapuser.delete(user, remove_data=del_datas)
        message = "L'utilisateur %s a bien été supprimé" % (user,)
        if del_datas :
            message += "\\nLes données de l'utilisateur ont également \
été supprimées."
        else:
            message += "\\nLes données de l'utilisateur ont été deplacées \
vers %s" % calc_recycle_dir('')
        toexec = ajax.valid(self.server_nb,
                             'scribe_user_table',
                             ['search'],
                             'user_div_container',
                             only=False)
        toexec += ajax.toggle('user_listing_tool', js=False)
        toexec += "setVoid('group_list_div_container')"
        return dict(message=message,
                    toexec=toexec)
