#-*-coding:utf-8-*-
"""
    UseFull fonction pour la validation de type
"""
# fonctions de vérification des paramètres
from os.path import exists

def valid_text(data):
    """
        Vérifie l'absence d'espace dans la variable
    """
    assert isinstance(data, str) and "" not in data

def valid_strict_text(data):
    """
        Return True if all characters in S are alphanumeric
        and there is at least one character in S, False otherwise.
    """
    assert data.isalnum()

def valid_digit(data):
    """
        Return True if all characters in S are digits
        and there is at least one character in S, False otherwise.
    """
    assert data.isdigit()

def valid_path(data):
    """
        Return True if data is an existing path
    """
    valid_text(data)
    assert exists(data)

def valid_list(data, allowed=None):
    """
        valide que les éléments de la liste sont autorisés
    """
    assert isinstance(data, list)
    if allowed != None:
        for val in data:
            assert val in allowed

def valid_yesno(data):
    """
        Valide un oui/non : 'oui','o','non','n','yes','y','no'
    """
    valid_text(data)
    assert data.lower() in ['oui', 'o', 'non', 'n', 'yes', 'y', 'no']

def valid_dict(data):
    """
        Valide le type dict
    """
    assert isinstance(data, dict)

def valid_passwd(data):
    """
        Valide un mot de passe (string de plus de 4 caractères)
    """
    assert isinstance(data, str) and len(data) > 4

def valid_boolean(data):
    """
        Valide un texte booléen
    """
    assert data.lower() in ['true', 'false', 'vrai', 'faux']
