# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# Action gestion
#  
# Page d'entree de la partie de gestion (d'utilisateur, groupe et partage)
#       
###########################################################################
"""Actions permettant de gérer les utilisateurs, compte, partage, groupe (application Gestion)"""
from twisted.python import log
from ead2.backend.lib.action import * # import des actions et des types
from ead2.backend.actions.tools import get_request
from ead2.lib.libead import uni
from ead2.backend.actions.horus import gestion_tools as G

class Gestion(Action):
    """ entrée de l'interface gestion """
    user_description = Dict(default={}, doc="description de l'éxécutant", keys=['ip', 'name', 'role'])
    name = 'gestion_index'
    libelle = 'Index'
    category = 'Gestion'
    description = 'Créer/Modifier/Supprimer des utilisateurs'
    # utilise dans le frontend pour differenciation
    plugin = Boolean(default=False, doc="type de rendu")
    url = Text(default='', doc="url de la navigation en cours cote frontend")
    request = Dict(default={}, doc="arguments de la requete en cours cote frontend", keys=['server', 'action'])

    def execute(self):
        """ renvoit les données pour l'affichage """
        params, server_nb = get_request(self.request)
        menus = ({"Gestion des utilisateurs":G.get_user_menu(server_nb)},
                {"Gestion des partages": G.get_share_menu(server_nb)},
                {"Gestion des groupes": G.get_group_menu(server_nb)},
                {"Gestion des comptes machines":G.get_account_menu(server_nb)}
                )
        result = {'menus':menus}
        return self.send_all(result, template='horus_gestion_index')
