# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Outil de parsing des fichiers de logs renvoie les lignes de logs par ip,
# url, login, tranche horaire
#
###########################################################################
""" Outils de parsing des fichiers de logs """
from twisted.python import log
from ead2.backend.actions.lib.logparser.config import LOG_DIR, TEMP_FILENAME, \
LOGPARSER_DIR
#from ead2.backend.actions.lib.logparser import file_listing
from os.path import join, splitext
import commands
from os import unlink

## fonction à utiliser de l'extérieur du module
def get_logs(filenames=[], ip=None, url=None, login=None, hours=(None, None), denied=None):
    """ renvoie les logs selon les critères fournis
        @filenmames: noms des fichiers à traiter
        @ip: ip de l'utilisateur
        @url: url visitée
        @login: login de l'utilisateur
        @hours: tranche horaire
        @denied: logs interdits?
    """
    if type(filenames) != list:
        filenames = [filenames]
    if hours == (None, None):
        return _get_filtered_logs(filenames, ip=ip, url=url, login=login, denied=denied)
    if None in hours:
        raise Exception("Erreur : Il manque l'heure de début ou de fin.")
    result = []
    beg, end = hours
    for filename in filenames:
        date = _get_file_date(filename)
        if date:
            timestamps = _construct_datetime_range(date, beg, end)
            for timestamp in timestamps:
                parsed_logs = _get_filtered_log(filename, ip=ip, url=url,
                        login=login, date=timestamp, denied=denied)
                result.extend(parsed_logs)
    return result

## parse les logs d'un ensemble de fichier
def _get_filtered_logs(filenames=[], url=None, ip=None, login=None, denied=None):
    """ renvoie les logs filtrés pour les fichiers filenames """
    if filenames == []:
        raise Exception("Précisez les jours de la recherche logparsing.py")
        #filenames = file_listing.get_logs()
    result = []
    for filename in filenames:
        result.extend(_get_filtered_log(filename, url=url, ip=ip, login=login,
            denied=denied))
    return result

## parse les logs de filename selon url, ip, login, date
## en supprimant les doublons (s'appuie sur parser.sh)
def _get_filtered_log(filename, url=None, ip=None, login=None, date=None, denied=None):
    """ renvoie les logs filtrés selon les parametres envoyés """
    filepath = join(LOG_DIR, filename)
    cmd = ''
    if splitext(filename)[1] == '.gz':
        act_grep = 'zgrep'
        act_cat = 'zcat'
    elif splitext(filename)[1] == '.lzma':
        act_grep = 'lzgrep'
        act_cat = 'lzcat'
    else:
        act_grep = 'grep'
        act_cat = 'cat'
    ## on a des " dans les champs du csv, donc on doit les escaper
    ## pour le passage de la commande au script
    ## (une fois pour python, une fois pour grep)
    grep = act_grep + ' -E \'%s\' ' + filepath
    othergrep = ' | grep -E \'%s\' '
    if url is not None:
        cmd += grep % url
        grep = othergrep
    if ip is not None:
        ip = '\\"%s\\"' % ip
        cmd += grep % ip
        grep = othergrep
    if login is not None:
        esc_login = '\\"%s\\"' % login
        cmd += grep % esc_login
        grep = othergrep
    if date is not None:
        cmd += grep % date
        grep = othergrep
    if denied is not None:
        cmd += grep % 'DENIED|Accès interdit'
    if cmd != '':
        parsersh = join(LOGPARSER_DIR, 'parser.sh')
        cmd = "%s \"%s\" \"%s\"" % (parsersh, cmd, TEMP_FILENAME)
    else:
        #FIXME: on passe par un fichier temporaire pour éviter de dézipper
        # (utilisation de zcat)
        # on doit pouvoir faire mieux
        cmd = "%s %s >%s" % (act_cat, filepath, TEMP_FILENAME)
    return_code, return_value = commands.getstatusoutput(cmd)
    if return_code % 256:
        log.err("Erreur: logparsing.py %s" % return_value)
        raise Exception("Erreur : le parsing en ligne de commande a échoué")
    grepped_datas = file(TEMP_FILENAME).read().splitlines()
    unlink(TEMP_FILENAME)
    parsed_datas = list(_parse_log_lines(grepped_datas))
    p_datas = []
    for line in parsed_datas:
        if line not in p_datas:
            p_datas.append(line)
    if login is not None:
        parsed_datas = _filter_login(p_datas, login)
    return p_datas

# cree un dico depuis des lignes de logs
def _parse_log_lines(datas):
    """ renvoie les logs sous forme de liste de dico """
    for line in datas:
        if len(line.split(',')) > 3:
            mylog = {'login':line.split(',')[1][1:-1],
                     'date':line.split(',')[0].split('"')[1],
                     'url':_get_domain(line.split(',')[3][1:-1]),
                     'ip':line.split(',')[2][1:-1],
                     'longurl':_replace_cars(line.split(',')[3][1:-1])
                    }
            if 'DENIED' in line or 'Accès interdit' in line:
                mylog['denied'] = 'True'
            yield mylog

# recuper le nom de domaine d'une url
def _get_domain(url):
    """ renvoie le nom de domaine d'une url choisie """
    return url.split('/')[2]

# remplace certains caractères indésirables
def _replace_cars(url):
    """ remplacement de caractères indésirables """
    return url.replace('%', '&#37;')

# repasse derrière pour controler le login
def _filter_login(datas, login):
    """ renvoie les logs de 'login' (filtre les urls contenant 'login) """
    return [a for a in datas if a['login'] == login]

### utilitaires pour le parsing par date
def _construct_datetime_range(date, beg, end):
    """ renvoie la liste des chaines "date heure:"
    qui correspondent à la beach hour (plage horaire) demandée
    """
    try:
        beg = int(beg)
        end = int(end)
    except:
        raise Exception("Erreur : Le début ou la fin de la plage horaire demandée ne sont pas des entiers.")
    if beg >= end:
        raise Exception("Erreur : Le début de la plage horaire demandée est supérieure ou égale à la fin.")
    day, month, year = date
    plage = ["%s.%s.%s %s:" % (year, month, day, hour) for hour in range(beg, end)]
    return plage

def _get_file_date(filename):
    """ renvoie la date d'un fichier de log en
        parsant la première ligne
    """
    filepath = join(LOG_DIR, filename)
    if splitext(filename)[1] == '.gz':
        cmd = "zgrep -m1 , %s" % filepath
    else:
        cmd = "grep -m1 , %s" % filepath
    return_code, first_file_line = commands.getstatusoutput(cmd)#'grep -m1 , %s'%filepath)
    if return_code % 256:
        log.err("Erreur : logparsing.py %s pour la commande : %s, code retour: %s" % (first_file_line, cmd, return_code))
        raise Exception("Une erreur s'est produite au parsing de %s : %s" % (filepath, first_file_line))
    if first_file_line:
        date = first_file_line.split('"')[1].split(' ')[0]
        return reformate_date(date)
    else:
        return ''

def reformate_date(date):
    """
    renvoie une date à un nouveau format: (jour,mois,année)
    depuis une date au format : 'année.mois.jour'
    """
    year, month, day = date.split('.')
    return day, month, year
