#-*-coding:utf-8-*-
"""
    Classe de log pour les actions lancées dans des at
"""
import sys
from traceback import print_exc

class Logger(object):
    """
        Gère les logs
        :logfile: fichier dans lequel logger
        :lockmanager: manager de lock (possède une méthode del_lock)
    """
    def __init__(self, logfile, lockmanager=None, root_logger=None):
        self.lockmanager = lockmanager
        self.logfile = logfile
        self.root_logger = root_logger
        self.init_logfile()
        self.end_msg = "FIN"

    def init_logfile(self):
        """
            Initialise le fichier de log
        """
        _file = file(self.logfile, 'w')
        _file.write('')
        _file.close()

    def log_err(self, message=None, unlock=True, error=None):
        """
            Loggue les ERREUR et les erreurs dans le fichier de log
            :message: message de log
            :unlock: supprimer un verrou
            :error: erreur interceptée dans un except
        """
        font_style = "font-weight:bold;text-align:center;"
        self.log("<div style='color:#ff0000;%s'>ERREUR</div>" % font_style)
        if error:
            self.log("<div style='text-align:center'>")
            self.log(error.message)
            if self.root_logger:
                self.root_logger.exception(error.message)
            else:
                print_exc(file=file(self.logfile,'a+'))
            self.log("</div>")
            self.log("\n")
        if message:
            self.log(message)
        self.log_end(unlock)
        sys.exit(2)

    def log_ok(self):
        """
            Loggue les OK
        """
        font_style = "font-weight:bold;text-align:center;"
        self.log("<div style='color:#00ff00;%s'>OK</div>" % font_style)

    def log_end(self, unlock=True):
        """
            Loggue la FIN
        """
        if unlock and self.lockmanager:
            try:
                self.lockmanager.del_lock()
            except:
                pass
        font_style = "font-weight:bold;text-align:center;"
        self.log("<div style='color:#0000ff;%s'>%s</div>" % (font_style,
                                                          self.end_msg))

    def log(self, msg):
        """
            Loggue les informations d'avancement de l'importation
        """
        _file = file(self.logfile, 'a+')
        _file.write(str(msg))
        _file.write('\n')
        _file.close()
