# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Configuration des rôles de l'ead2
#
###########################################################################
"""
Configurer les rôles de l'ead2
"""
from twisted.python import log
from ead2.backend.lib.action import Action, Dict
from ead2.backend.actions import tools
from ead2.backend.actions.lib.profils import role_editor_tools as editor

used_templates = ['main', 'form', 'listlist', 'checklist', 'formselect']
restart_msg = "Il faudra redémarrer l'ead-server pour que les modifications soient prises en compte\\n(service ead-server restart dans une console sur le serveur)."

def make_role(name, libelle, actions):
    manager = editor.RoleManager()
    if not manager.is_role(name):
        manager.add_role(name, libelle)
        message = "Le rôle %s a été créé.\\n" % libelle
    else:
        message = "Le rôle %s a été modfifié.\\n" % libelle
    if len(actions) != 0:
        message += "Association d'action : \\n"
        manager.set_role_perms(name, actions)
        message += '\\n'.join(actions)
        if len(actions)>1:
            message += '\\n ont été associées à ce rôle.'
        else:
            message += '\\n a été associé.'
    message += restart_msg
    return dict(message=message)

def make_user_role_link(role, userlist):
    """ associe des utilisateurs à un role """
    if not hasattr(userlist, '__iter__'):
        userlist =   [userlist]
    manager = editor.UserRoleManager()
    manager.add_users_role(role, userlist)
    libelle = editor.get_libelle(role)
    if len(userlist) >1:
        message = "Les utilisateurs choisis sont désormais %s.\\n" % libelle
    else:
        message = "L'utilisateur %s est désormais %s.\\n" % (userlist[0],
                                                             libelle)
    message += restart_msg
    return dict(message=message)

def del_role(name):
    """ suppresssion d'un role"""
    manager = editor.RoleManager()
    try:
        manager.del_role(name)
    except Exception, err:
        return dict(message=err)
    return dict(message="Le rôle %s a été supprimé." % name)

class RoleEditor(Action):
    """ page de gestion des rôles """
    user_description = Dict(default={}, doc="Description de l'executant",
                            keys=['name', 'role', 'ip'])
    name = "role_editor"
    libelle = "Création de rôles"
    description = "Edition de rôles"
    category = "Édition de rôles"
    request = Dict(default={},
                   doc="Arguments de la requête en cours côté frontend",
                   keys=['server', 'action', 'edit', 'delete'])
    form_result = Dict(default={}, doc="Validation de formulaire",
                        keys=['role', 'role_actions'])

    def execute(self):
        params, self.server_nb = tools.get_request(self.request)
        self.role_name = 'new'

        # demande du formulaire de creation
        if params.has_key('edit'):
            self.role_name =  params['edit'][0]
            datas = self._get_role_form()
            return self.send_frag(datas, template="role_editor",
                                  templates=used_templates)

        # suppression
        elif params.has_key('delete'):
            datas = self.del_role(params['delete'][0])
            datas['toexec'] = tools.make_js_link(self.server_nb, self.name,
                                                 confirm=True)
            return self.send_frag(datas, template="role_editor",
                                  templates=used_templates)

        # validation de la creation
        if self.form_result != {}:
            if self.form_result.has_key('role'):
                try:
                    datas = self.make_role()
                    datas['toexec'] = tools.make_js_link(self.server_nb,
                                                         self.name,
                                                         confirm=True)
                except Exception, msg:
                    log.err()
                    datas = dict(message = msg.message)
                self.form_result = {}
                return self.send_frag(datas, template="role_editor",
                                      templates=used_templates)

        result = {'titre':self.description}
        result.update(self._get_menu_btns())
        result.update(self._get_main_msg())
        return self.send_all(result=result, template="role_editor",
                             templates=used_templates)

    def _get_main_msg(self):
        """ renvoie le texte d'entrée """
        return dict(contenu="<b>OUTIL DE CONFIGURATION</b><br /> Cet outil permet de configurer des rôles ayant des droits spécifiques dans l'ead2.")

    def _get_menu_btns(self):
        """
        renvoie la description des boutons
        du menu d'édition des rôles
        """
        new_role_btn = dict(href=tools.make_js_link(self.server_nb, self.name,
                                                     balise='workspace',
                                                     edit='new'),
                                 title="Créer un nouveau rôle",
                                 icone="/image/btn_role.png",
                                 libelle="<b>Créer rôle</b>",
                                 _class='btn')


        btns = []
        manager = editor.RoleManager()
        for role in manager.get_roles():
            btn = (dict(href=tools.make_js_link(self.server_nb, self.name,
                                                balise='workspace',
                                                edit=role),
                            title="Editer le rôle %s."%(role),
                            icone="",
                            libelle="<b>%s</b>"%role,
                            _class="simple_services_mod"),
                   dict(href=tools.make_js_link(self.server_nb, self.name,
                                                balise='workspace',
                                                delete=role),
                            title="Supprimer le rôle %s."%(role),
                            icone="/image/supprimer.gif",
                            libelle="",
                            _class="simple_services_btn_suppr")
                   )
            btns.append(btn)
        return dict(menu=btns, new_role_btn=new_role_btn)

    def _get_role_form(self):
        """
        renvoie la description du formulaire
        de création d'un nouveau rôle
        """
        role = {'name':'name',
                    'libelle':'Intitulé du rôle',
                    'onblur':"testVoid('name', 'error_name');"
                    }
        role_libelle = {'name':'libelle',
                            'libelle':'Libellé associé au rôle',
                            'onblur':"testVoid('libelle', 'error_libelle');"
                       }
        # création
        if self.role_name == 'new':
            actions = editor.get_actions()
            role_actions = []
        # modification
        else:
            # on gèle les inputs
            role['disabled'] = 'ok'
            role['default_value'] = self.role_name
            role.pop('onblur')
            manager = editor.RoleManager()
            libelle = manager.get_libelle(self.role_name)
            role_libelle['disabled'] = 'ok'
            role_libelle['default_value'] = libelle
            role_libelle.pop('onblur')

            role_actions = manager.get_role_perms(self.role_name)
            actions = [action for action in editor.get_actions()
                                    if action not in role_actions]

        left = {'form':'available_actions',
                'datas':[{'name':action}for action in actions],
                'title':"Actions disponibles"}
        right = {'form':'role_actions',
                'datas':[{'name':action}for action in role_actions],
                 'title':'Actions associées au rôle'}
        title = "Association d'actions au rôle."
        btns = self._get_transf_btns()

        return dict(role=role,
                    role_libelle=role_libelle,
                    validate=self._get_validate_btn(),
                    actions=dict(left=left,
                                    right=right,
                                    title=title,
                                    btns=btns,
                                    name='role_editor_listlist'
                                    ),
                    )

    def _get_validate_btn(self):
        """
        renvoie la description du bouton valider
        pour la création de rôle
        """
        href = tools.make_form_link(self.server_nb, self.name, True,
                                    ['role', 'role_actions'],
                                    'msg_container'
                                   )
        title = 'Créer/Modifier le rôle et associer des actions'
        icone = '/image/ok.gif'
        if self.role_name == 'new':
            libelle = "Créer"
        else:
            libelle = "Modifier"
        return dict(href=href, title=title, icone=icone, libelle=libelle)

    def _get_transf_btns(self):
        """
        renvoit les btns de transfert de donnees liste a liste
        pour les services
        """
        href1 = "javascript:formTransferListElement('role_actions','available_actions_table');"
        href2 = "javascript:formTransferListElement('available_actions','role_actions_table');"
        icone1 = "/image/rightleft_red.png"
        icone2 = "/image/leftright.png"
        msg1 = "Retirer"
        msg2 = "Ajouter"
        btns = [{'href':href2, 'libelle':msg2, 'icone':icone2, 'title':msg2},
                {'href':href1, 'libelle':msg1, 'icone':icone1, 'title':msg1}]
        return btns


    def make_role(self):
        role = tools.format_form_result(self.form_result['role'])
        actions = tools.format_form_result(self.form_result['role_actions'], '2').keys()
        libelle, name = role['libelle'], role['name'].lower()
        return make_role(name, libelle, actions)

    def del_role(self, name):
        return del_role(name)


class RoleManager(Action):
    """ Gestion de l'attribution des roles """
    user_description = Dict(default={}, doc="Description de l'executant",
                            keys=['name', 'role', 'ip'])
    name = 'role_manager'
    description = "Gère l'attribution de rôles"
    libelle = "Attribution de rôles"
    category = None
    request = Dict(default={},
                   doc="Arguments de la requête en cours côté frontend",
                   keys=['server', 'action', 'associate', 'form', 'user'])
    form_result = Dict(default={}, doc="Validation de formulaire",
                      keys=['userlist', 'role_association', 'usertoassociate'])

    def execute(self):
        """ renvoie les données pour la mise en forme des actions """
        params, self.server_nb = tools.get_request(self.request)

        if params.has_key('form'):
            if params.has_key('user'):
                datas = self._get_form(params['form'][0], params['user'][0])
            else:
                datas = self._get_form(params['form'][0])
            return self.send_frag(datas, template='role_manager',
                                  templates=used_templates)

        if self.form_result != {}:
            try:
                datas = self.associate()
            except Exception, msg:
                log.err()
                datas = dict(message=msg.message)
            self.form_result = {}
            return self.send_frag(datas, template='role_manager',
                                  templates=used_templates)

        return self.send_all(dict(message="Il manque des données pour appeler cette action"),
                               template='role_manager',
                               templates=used_templates
                               )

    def _get_form(self, formname=None, username=None):
        """ renvoie la description d'un formulaire d'association de rôle à des individus
            @formname : nom du formulaire fournissant les noms d'utilisateur
            @username : nom de l'utilisateur à éditer
        """
        role_options = [{'name':role[0], 'libelle':role[1]}for role in editor.get_roles()]

        if username is not None:
            user_roles = editor.get_optionnal_user_roles(username)
            for role in role_options:
                if role['name'] in user_roles:
                    role['default'] = 'ok'

        select_role = {'name':'role',
                        'options':[{'name':'', 'options':role_options}],
                        'libelle':'Choix du rôle',
                        }

        validate = {'href':tools.make_form_link(self.server_nb, self.name,
                                                    True,
                                                    [formname, 'role_association'],
                                                    'role_msg_container'),
                    'libelle':'Valider',
                    'icone':'/image/ok.gif',
                    'title':'Associer ce rôle aux utilisateurs'
                   }

        role_icone = '/image/action_role_over.png'
        return dict(select_role=select_role,
                    validate=validate,
                    role_icone=role_icone)

    def associate(self):
        """ valide l'association de rôle et d'utilisateur """
        if not self.form_result.has_key('role_association'):
            raise Exception, "Il manque des données pour associer un rôle."
        role = tools.format_form_result(self.form_result['role_association'])['role']

        if self.form_result.has_key('userlist'):
            userlist = tools.format_form_result(self.form_result['userlist'], False).keys()
            if userlist == []:
                raise Exception, "Aucun utilisateur n'a été sélectionné."
        elif self.form_result.has_key('usertoassociate'):
            userlist = tools.format_form_result(self.form_result['usertoassociate']).values()
            if userlist == []:
                raise Exception, "Aucun utilisateur n'a été sélectionné."
        else:
            raise Exception, "Impossible de récupérer la liste des utilisateurs."

        return make_user_role_link(role, userlist)

class RoleAssociation(Action):
    """ gère l'édition du fichier roles_local.ini """
    user_description = Dict(default={}, doc="Description de l'executant",
                            keys=['name', 'role', 'ip'])
    name = "role_association"
    libelle = "Association de rôles"
    description = "Association de rôles"
    category = "Édition de rôles"
    request = Dict(default={},
                   doc="Arguments de la requête en cours côté frontend",
                   keys=['server', 'action', 'edit', 'new', 'delete'])
    form_result = Dict(default={}, doc="Validation de formulaire",
                        keys=['role_association'])

    def execute(self):
        params, self.server_nb = tools.get_request(self.request)

        if params.has_key('new'):
            datas = self.get_form()
            return self.send_frag(datas, template='role_association',
                                  templates=used_templates)
        elif params.has_key('edit'):
            datas = self.get_form(params['edit'][0])
            return self.send_frag(datas, template='role_association',
                                  templates=used_templates)
        elif params.has_key('delete'):
            try:
                datas = self.delete(params['delete'][0])
                datas['toexec'] = tools.make_js_link(self.server_nb,
                                                     self.name,
                                                     confirm=False)
            except Exception, msg:
                datas = dict(message=msg.message)
            return self.send_frag(datas, template='role_association',
                                  templates=used_templates)

        if self.form_result != {}:
            if self.form_result.has_key('role_association'):
                try:
                    datas = self.add_association()
                    datas['toexec'] = tools.make_js_link(self.server_nb,
                                                         self.name,
                                                         confirm=False)
                except Exception, msg:
                    datas = dict(message=msg.message)
                self.form_result = {}
                return self.send_frag(datas, template='role_association',
                                      templates=used_templates)


        result = {'title':self.description}
        result.update(self.get_menu())
        return self.send_all(result, template='role_association',
                             templates=used_templates)

    def get_menu(self):
        """ renvoie la description d'un menu de gestion des associations """
        create_btn = {'href':tools.make_js_link(self.server_nb, self.name,
                                                balise='workspace',
                                                new='new'),
                      'title':"Créer une association de rôle",
                      'libelle':"Associer rôle",
                      "icone":"/image/action_role.png",
                      '_class':'btn'
                      }

        btns = []
        manager = editor.UserRoleManager()

        for ldapkey, roles in manager.get_sections().items():
            for ldapvalue, role in roles.items():
                btn = ("<b>%s:%s -> %s</b>" % (ldapkey, ldapvalue,
                                               editor.get_libelle(role)),
                       dict(href=tools.make_js_link(self.server_nb, self.name,
                                                    balise='workspace',
                                                    delete="%s#%s#%s" % (ldapkey, ldapvalue, role)),
                            title="Supprimer",
                            icone="/image/supprimer.gif",
                            libelle="",
                            _class="simple_services_btn_suppr")
                   )
                btns.append(btn)

        contenu = "<b> Association d'une clé avec un rôle </b><br /> L'annuaire ldap utilisé par votre serveur d'authentification sso, permet d'associer une clé ldap avec un rôle dans l'Ead2."

        return dict(create_btn=create_btn,
                    menu = btns,
                    contenu=contenu)

    def get_form(self):
        """ renvoie les données pour la mise en forme du formulaire """
        role_options = [{'name':role[0], 'libelle':role[1]}for role in editor.get_roles()]

        ldapkey = {'name':'ldapkey',
                    'libelle':'Intitulé de la clé ldap',
                    'onblur':"testVoid('ldapkey', 'error_ldapkey')"}
        ldapkey = {'name':'ldapkey',
                    'libelle':"Intitulé de la clé",
                    'options':[{'name':'Utilisateurs ldap',
                                                'options':[{'name':name,
                                                            'libelle':libelle}
                                                            for name, libelle in editor.get_ldapkeys()
                                                          ]},
                                {'name':'Utilisateurs système',
                                                'options':[{'name':'pam',
                                                            'libelle':"Login de l'utilisateur"
                                                          }]
                                }
                               ]
                    }


        ldapvalue = {'name':'ldapvalue',
                    'libelle':'Valeur de la clé',
                    'onblur':"testVoid('ldapvalue', 'error_ldapvalue')"}

        select_role = {'name':'role',
                        'options':[{'name':'', 'options':role_options}],
                        'libelle':'Choix du rôle',
                        }

        validate = {'href':tools.make_form_link(self.server_nb, self.name,
                                                    True,
                                                    ['role_association'],
                                                    'role_msg_container'),
                    'libelle':'Valider',
                    'icone':'/image/ok.gif',
                    'title':'Associer ce rôle aux utilisateurs'
                   }

        return dict(ldapkey=ldapkey,
                    ldapvalue=ldapvalue,
                    select_role=select_role,
                    validate=validate)

    def delete(self, association_name):
        """ supprime une association entre une clé ldap et un rôle """
        ldapkey, ldapvalue, role = association_name.split('#')[:3]

        manager = editor.UserRoleManager()
        manager.remove_association(ldapkey, ldapvalue, role)

        if ldapkey == "pam":
            message = "Le compte système %s n'est désormais plus %s." % (ldapvalue, role)
        else:
            message = "Les utilisateurs ayant une clé ldap %s de valeur %s au sein de l'annuaire ne sont plus %s" % (ldapvalue, ldapkey, role)
        message += "\\nN.B:\\nRedémarrez l'ead-server pour que les modifications prennent effet."

        return dict(message=message)

    def add_association(self):
        """ ajoute un lien entre une clé ldap et un rôle """
        resultat = tools.format_form_result(self.form_result['role_association'])
        ldapkey = resultat['ldapkey']
        ldapvalue = resultat['ldapvalue']
        role = resultat['role']

        manager = editor.UserRoleManager()
        manager.add_role_key(ldapkey, ldapvalue, role)

        if ldapkey == 'pam':
            message = "Le compte système %s est désormais associé au rôle %s." % (ldapvalue, role)
        else:
            message = "Les utilisateurs ayant une clé %s de valeur %s au sein de l'annuaire sont désormais %s." % (ldapkey, ldapvalue, role)
        message += "\\nN.B:\\nRedémarrez l'ead-server pour que les modifications prennent effet."

        return dict(message=message)
