# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
###########################################################################
"""
    Exécution d'une commande système
"""
from glob import glob
from os.path import join
#from twisted.python import log
from ead2.backend.actions.lib.widgets import ajax
from ead2.backend.actions.lib.main import Main
from ead2.backend.config.config import CONFIG_DIR


def get_cmds_from_config():
    """
    Récupération de la liste des commandes consoles
    depuis les fichiers de configuration
    """
    cmds = []
    fic_cmds = glob('%s/cmds/*.cmd' % CONFIG_DIR)
    for fic_cmd in fic_cmds:
        for cmd in file(join(fic_cmd)).readlines():
            if not cmd.startswith('#') and cmd.strip() != '':
                cmds.append(cmd.strip())
    return cmds


class Console(Main):
    """
        action de mise en forme de bouton d'exécution de commande
    """
    name = "cmd_console"
    libelle = "Console"
    description = "Lancez des commandes sur le système"
    title = "Console de lancement de script"
    category = "Système"
    template = "console_system"
    widget_templates = ['main']
    btn_container_tmpl = "consolebtn%s"

    def execute(self):
        self.parse_request()
        return self.send(self._get_page())

    def send(self, dico):
        return self.send_all(dico, template=self.template,
                             templates=self.widget_templates)

    def _get_page(self):
        """
            renvoie la description de la page d'exécution de commande (un bouton)
        """
        cmds = get_cmds_from_config()
        if cmds:
            toexec = ""
            containers = []
            for indice, cmd_actionname in enumerate(cmds):
                container = self.btn_container_tmpl % indice
                containers.append(container)
                toexec += ajax.call(self.server_nb,
                                    cmd_actionname,
                                    container=container,
                                    only=False)
            return dict(toexec=toexec,
                        containers=containers,
                        titre=self.title
                        )
        else:
            defaultmessage = "Aucune commande n'est disponible"
            return dict(defaultmessage=defaultmessage, titre=self.title)
