#-*-coding:utf-8-*-
from sets import Set
from string import ascii_letters, digits

from twisted.python import log

from amon.backend import get_filter_zones
from amon.ipset import group_manager, time_manager, rule_generator
from amon.guardian import dans_tools, config

from creole.eosfunc import valid_ip

from ead2.backend.actions.amon import amon_tools as t
from ead2.lib.error import MissingKey
from ead2.backend.actions import tools
from ead2.backend.config.config import debug

zone_indices = {'admin':0,
                'pedago':1}
policies_libelles = ('Défaut', 'modérateur', 'interdits', 'mode liste blanche', '1', '2', '3', '4')
#FIXME: vérifier la modification des associations configuration-interface
#       tester dans le cas de modification pour déporter les groupes vers leur config respective

def test_group_name(gr_name):
    chars = ascii_letters + digits + '-_.éè'
    for i in gr_name:
        if i not in chars:
            raise Exception, "Erreur le nom de groupe de machine ne doit pas contenir le caractère '%s' ." % i
    return True

def _get_ip_set_create_btn(zone, server_nb, name):
    href = tools.make_js_link(server_nb, 'groupe_machine_create_%s'%zone, balise='ip_set_workspace')
    title = "créer un groupe de machine"
    libelle = "Nouveau groupe de machine"
    icone = "/image/amon/add.png"
    return dict(new_ip_set={'href':href, 'title':title, 'libelle':libelle, 'icone':icone})

def create_form(zone):
    """
    renvoie la description du formulaire
    de création de groupe de machine
    """
    new_set_name = {'name':'set_name', 'libelle':'nom du groupe',
                    'onblur':"testVoid('set_name', 'error_set_name');"}
    ip_from = {'name':'ip_from', 'libelle':"début de la plage d'ip",
               'onblur':"testVoid('ip_from', 'error_ip_from');"}
    ip_to = {'name':'ip_to', 'libelle':"fin de la plage d'ip",
             'onblur':"testVoid('ip_to', 'error_ip_to');"}
    ifaces = get_filter_zones()[zone_indices[zone]]
    if len(ifaces) > 1:
        options = [{'name':iface['nom'], 'libelle':"%s (%s)"%(iface['nom_machine'], iface['nom'])}for iface in ifaces]
        interface = {'name':'interface',
                     'options':[{'name':'', 'options':options}],
                     'libelle':"Interface de la plage"
                     }
        return dict(new_set_name=new_set_name,
                    ip_from=ip_from,
                    ip_to=ip_to,
                    interface=interface,
                    close=get_close_btn())
    return dict(new_set_name=new_set_name,
                ip_from=ip_from,
                ip_to=ip_to,
                close=get_close_btn())

def ip_set_del_btn(server_nb, name, ip_set):
    """ bouton supprimer """
    libelle = ""
    _href = tools.make_js_link(server_nb, name, confirm=True, balise='ip_set_del_msg',
                                    delete=ip_set['name'])
    href = tools.make_confirm_link("Êtes-vous sûr de vouloir supprimer le groupe de machine %s?"%ip_set['name'], _href)
    title = "Supprimer le groupe de machine %s"%ip_set['name']
    icone = "/image/supprimer.gif"
    _class = "amon_ip_set_del_btn"
    return dict(libelle=libelle, href=href, title=title, icone=icone, _class=_class)

def ip_set_active_btn(zone, server_nb, name,  ip_set):
    """ bouton activer """
    libelle = "Mod"
    href = tools.make_js_link(server_nb, 'groupe_machine_service_%s'%zone, confirm=False,
                                balise='ip_set_workspace', ip_set=ip_set['name'])
    title = "Associer des services au groupe %s"%ip_set['name']
    icone = ""
    _class = "amon_ip_set_btn"
    return dict(libelle=libelle, href=href, title=title, icone=icone, _class=_class)

def ip_set_time_btn(zone, server_nb, name, ip_set):
    """ bouton configuration horaire """
    libelle = ""
    href = tools.make_js_link(server_nb, 'groupe_machine_horaire_%s'%zone, confirm=False,
                                balise='ip_set_workspace', ip_set=ip_set['name'])
    title = "Définir des plage horaire pour %s"%ip_set['name']
    icone = "/image/amon/time.png"
    _class = "amon_ip_set_btn"
    return dict(libelle=libelle, href=href, title=title, icone=icone, _class=_class)

def get_active_btn(server_nb, name, ip_set):
    """ bouton d'activation l'interdiction web """
    libelle = ""

    if (ip_set['active'] == '0') or (ip_set['active'] == '1' and ip_set['time'] == '1'):
        href = tools.make_js_link(server_nb, name, confirm=False, balise='ip_set_del_msg',
                                active=ip_set['name'])
        title = "Activer l'interdiction web sur ce groupe de machine"
        icone = "/image/amon/enable.png"
    else:
        href = tools.make_js_link(server_nb, name, confirm=False, balise='ip_set_del_msg',
                                                    unactive=ip_set['name'])
        title = "Désactiver l'interdiction web sur ce groupe de machine"
        icone = "/image/amon/disable.png"

    _class = "amon_ip_set_btn"
    return dict(libelle=libelle, href=href, title=title, icone=icone, _class=_class)

def get_active_time_btn(server_nb, name, ip_set):
    """ bouton d'activation de la gestion du temp """
    libelle = ""

    if (ip_set['time'] == '0') or (ip_set['active'] == '0' and ip_set['time'] == '1'):
        href = tools.make_js_link(server_nb, name, confirm=False, balise='ip_set_del_msg',
                                     active_time=ip_set['name'])
        title = "Activer l'interdiction horaire sur ce groupe de machine"
        icone = "/image/amon/enable.png"
    else:
        href = tools.make_js_link(server_nb, name, confirm=False, balise='ip_set_del_msg',
                                                         unactive_time=ip_set['name'])
        title = "Désactiver l'interdiction horaire sur ce groupe de machine"
        icone = "/image/amon/disable.png"

    _class = "amon_ip_set_btn"
    return dict(libelle=libelle, href=href, title=title, icone=icone, _class=_class)

def policy_form(zone, server_nb, name, ip_set):
    """
        renvoie la description du formulaire
        de choix de la politique de filtrage à appliquer sur le groupe de machine
    """
    plage = "%s-%s"%(ip_set['ip_from'], ip_set['ip_to'])
    options = [{'name': str(policy), 'libelle': policies_libelles[policy-1]}for policy in config.policies]
    if dans_tools.get_policy(zone_indices[zone], plage, _type='ip'):
        options[dans_tools.get_policy(zone_indices[zone], plage, _type='ip')-1]['default'] = 'ok'
    select_policy = {'onchange':tools.make_js_link(server_nb, name, code=True, balise="ip_set_del_msg",
                                                    policy='this.options[this.selectedIndex].value',
                                                    ip_set="'%s'"%ip_set['name']),
                     'name':'select_policy',
                     'options':[{'name':'', 'options':options}]}
    return select_policy

def forbid_select(zone, server_nb, name, ip_set):
    """ select d'interdiction de web (aucune, horaire, tout le web, tout le réseau) """
    options = [{'name':'aucune', 'libelle':'Jamais'},
               {'name':'web', 'libelle':'Le web tout le temps'},
               {'name':'horaire', 'libelle':'Le web selon horaires'},
               {'name':'all', 'libelle':'Toute activité réseau'}]

    if (ip_set['active'] == '1'):
        if ip_set['time'] == '1':
            options[2]['default'] = 'ok'
        else:
            options[1]['default'] = 'ok'
    elif (ip_set['active'] == '2'):
        options[3]['default'] = 'ok'
    else:
        options[0]['default'] = 'ok'

    select = {'name':'forbid',
              'options':[{'name':'', 'options':options}],
              'onchange':tools.make_js_link(server_nb, name, code=True, balise="ip_set_del_msg",
                                                    forbid='this.options[this.selectedIndex].value',
                                                    ip_set="'%s'"%ip_set['name']),}
    return select

def ip_sets(zone, server_nb, name):
    """ renvoie la description pour la mise en forme des sets d'ip de la zone 'zone'"""
    def sort_func(a,b):
        """ fonction de classement selon le nom des groupes """
        if a['name'] > b['name']: return 1
        else: return -1


    ip_sets = group_manager.get_all_groups(zone_indices[zone])
    ip_sets.sort(sort_func)

    ip_set_list_libelles = ("Groupes de machine",
                            "Horaires",
                            "Interdictions",
                            'Politique <br />de filtrage',
                            "Suppression", )

    sets = []
    for ip_set in ip_sets:
        libelle = "<b>%s</b> plage IP: %s à %s sur l'interface %s" % (
                                    ip_set['name'], ip_set['ip_from'],
                                    ip_set['ip_to'], ip_set['interface'])
        horaire_btn = ip_set_time_btn(zone, server_nb, name, ip_set)
        suppr_btn = ip_set_del_btn(server_nb, name, ip_set)
        web_forbid = forbid_select(zone, server_nb, name, ip_set)
        select_policy = policy_form(zone, server_nb, name, ip_set)
        sets.append((libelle, horaire_btn, web_forbid, select_policy, suppr_btn))
    return dict(ip_sets=sets, ip_set_list_libelles=ip_set_list_libelles)

def create_set(zone, resultat):
    """ cree un set d'ip
        depuis un resultat de formulaire
    """
    if not Set(['set_name', 'ip_from', 'ip_to']).issubset(Set(resultat.keys())):
        log.err("groupe_machine_create : erreur, il manque des données à la création de groupe.%s"%resultat.keys())
        raise MissingKey, "Erreur: il manque des données à la création de groupe de machine."
    name = resultat['set_name']
    ip_from = resultat['ip_from']
    ip_to = resultat['ip_to']
    valid_ip(ip_from)
    valid_ip(ip_to)
    if resultat.has_key('interface'):
        interface = resultat['interface']
    else:
        # une seule interface qu'on récupère direct dans la liste
        interface = get_filter_zones()[zone_indices[zone]][0]['nom']
    test_group_name(name)

    if group_manager.create_group(zone_indices[zone], name, ip_from, ip_to, interface):
        set_ipset_rules()
        return dict()#message="Le groupe de machine %s a été créé.\\nIl recouvre la plage d'ip %s - %s."%(name, ip_from, ip_to))
    else:
        log.err("groupe_machine_create : erreur au lancement de manager.create_ip_set.")
        raise Exception, "Erreur: une erreur s'est produite à la création du set %s"%name

def del_ip_set(zone, todel):
    """ supprime un set d'ip """
    zone = zone_indices[zone]
    group = group_manager.get_group(zone, todel)
    message = ''

    # on supprime le groupe
    if group_manager.del_group(zone, todel):
        if group['active'] in ['1', '2']: ## des règles iptables s'applique au groupe de machine
            set_iptables_rules()
        set_ipset_rules()
        message += "Le groupe de machine %s a bien été supprimé."%todel
    else:
        raise Exception, "Erreur: une erreur est survenue à la suppression du groupe de machine %s."%todel

    # on désincrit le groupe (guardian) (si il est inscrit dans le fichiers de config d'ou le try)
    plage = "%s-%s"%(group['ip_from'], group['ip_to'])
    try:
        dans_tools.unset_policy(zone, plage, _type='ip')
    except:
        if debug:
            log.msg("Le groupe de machine %s avait la politique \
par defaut (n'etait pas inscrit dans filtergrouplist)"%todel)

    if dans_tools.reload():
        message += "\\nLe filtre a bien été rechargé."
    else:
        log.err("Erreur au lancement de service eole-guardian reload(1) dans groupe_forms.py")
        raise Exception, "%s\\n Erreur au rechargement du filtre."%message
    return dict()#message=message)


def set_ipset_rules():
    """ éxécute la génération de règle ipset """
    generator = rule_generator.RuleGenerator()
    generator.create_ip_sets()

def set_iptables_rules():
    """ relance bastion (remise à zéro des règles iptables)
    """
    #FIXME: on peut faire évoluer les performances de l'outil en testant l'existence des règles pour éviter les bastion restart inutil...
    t.bastion_restart()

def get_close_btn():
    """ renvoie la description du bouton de vidage de la balise ip_set_workspace(zone de travail) """
    href = "javascript:setVoid('ip_set_workspace');"
    title = "Fermer la section"
    libelle = "Fermer"
    icone = "/image/supprimer.gif"
    _class = "ip_set_close_btn"
    return dict(href=href,
                title=title,
                libelle=libelle,
                icone=icone,
                _class=_class)

def active_set(zone, group_name, active=True):
    """ active les restrictions sur un groupe de machine """
    zone = zone_indices[zone]
    if active:
        toactive = group_name
        if group_manager.active(zone, toactive) and group_manager.unactive_time(zone, toactive):
            set_iptables_rules()
            return dict(message="Le groupe de machine %s est désormais interdit de navigation web."%toactive)
        else:
            raise Exception, "Erreur: une erreur est survenue à l'activation du groupe de machine %s."%toactive
    else:
        tounactive = group_name
        if group_manager.unactive(zone, tounactive):
            set_iptables_rules()
            return dict(message="Le groupe de machine %s peut désormais naviguer librement."%tounactive)
        else:
            raise Exception, "Erreur: une erreur est survenue à la désactivation du groupe de machine %s."%tounactive

def active_time(zone, group_name, active=True):
    """ active/désactive les interdictions horaires """
    if active:
        toactive = group_name
        if group_manager.active_time(zone_indices[zone], toactive) and group_manager.active(zone_indices[zone], toactive):
            set_iptables_rules()
            return dict(message="Le groupe de machine %s est désormais interdit de navigation web selon les horaires spécifiés."%toactive)
        else:
            raise Exception, "Erreur: une erreur est survenue à l'activation des horaires du groupe de machine %s."%toactive
    else:
        tounactive = group_name
        if group_manager.unactive_time(zone_indices[zone], tounactive) and group_manager.unactive(zone_indices[zone], tounactive):
            set_iptables_rules()
            return dict(message="Le groupe de machine %s n'est plus soumis à des interdictions horaires."%tounactive)
        else:
            raise Exception, "Erreur: une erreur est survenue à la désactivation des horaires du groupe de machine %s."%tounactive

def set_total_forbidden(zone, group_name):
    """
    active l'interdiction de tout activité réseau pour un groupe de machine
    """
    if group_manager.set_total(zone, group_name):
        set_iptables_rules()
        return dict(message="Le groupe de machine %s est désormais interdit de toute activité réseau."%group_name)
    else:
        raise Exception, "Erreur: une erreur est survenue à l'interdiction totale du groupe de machine %s."%group_name

def unset_forbidden(zone, ipset):
    if group_manager.unactive(zone, ipset) and group_manager.unactive_time(zone, ipset):
        set_iptables_rules()
        return dict(message="Le groupe de machine %s n'est plus soumis à des interdictions web"%ipset)
    else:
        raise Exception, "Erreur: une erreur est survenue à la suppression des restrictions web."

def set_web_forbidden(zone, ipset):
    if group_manager.active(zone, ipset) and group_manager.unactive_time(zone, ipset):
        set_iptables_rules()
        return dict(message="Le groupe de machine %s est désormais interdit de navigation web."%ipset)
    else:
        raise Exception, "Erreur: une erreur est survenue à l'activation du groupe de machine %s."%ipset

def set_time_forbidden(zone, ipset):
    if group_manager.active(zone, ipset) and group_manager.active_time(zone, ipset):
        set_iptables_rules()
        return dict(message="Le groupe de machine %s est désormais interdit de navigation web selon les horaires spécifiés."%ipset)
    else:
        raise Exception, "Erreur: une erreur est survenue à l'activation des horaires du groupe de machine %s."%ipset

def forbid(zone, ipset, _type):
    """ interdit la navigation selon le type _type (aucune, web, horaire) """
    zone = zone_indices[zone]
    if _type == 'aucune':
        return unset_forbidden(zone, ipset)
    elif _type == 'web':
        return set_web_forbidden(zone, ipset)
    elif _type == 'horaire':
        return set_time_forbidden(zone, ipset)
    elif _type == 'all':
        return set_total_forbidden(zone, ipset)

def set_policy(zone, set, policy):
    """ définit la politique optionnelle à appliquer à un groupe de machine """
    policy = int(policy)
    message = ""
    ip_set = group_manager.get_group(zone_indices[zone], set)
    plage = "%s-%s"%(ip_set['ip_from'], ip_set['ip_to'])
    dans_tools.set_policy(zone_indices[zone], policy, plage, _type='ip')
    message += "La politique %s a été associé au groupe %s."%(policies_libelles[policy-1], set)

    if dans_tools.reload():
        message += "\\nLe filtre a été rechargé."
    else:
        log.err("Erreur au lancement de service eole-guardian reload(1) dans groupe_forms.py")
        raise Exception, "%s\\n Erreur au rechargement du filtre."%message

    return dict(message = message)


def _get_time_range(zone, server_nb, name, ip_set_name, ip_set_datas):
    """ renvoie les données pour la configuration de plage horaire
        ip_set
    """
    zone = zone_indices[zone]
    hours = time_manager.get_time_list()
    jours_datas = {}
    for jour in time_manager.get_days_list():
        horaires = time_manager.get_schedules(zone, ip_set_name, jour)
        closed_hours = []
        btns = []

        # fermé par defaut
        for i in range(48):
            closed_hours.append('0')
            btns.append('')

        libelle = "<b>Autorisation de navigation web:</b>"
        for horaire in horaires:
            libelle += "<br />de %s à %s"%(str(horaire['hdeb']), str(horaire['hfin']))
            deb = hours.index(horaire['hdeb'])
            end = hours.index(horaire['hfin'])
            middle = (deb+end)/2
            for i in range(deb, end):
                closed_hours[i] = '1'

            btns[middle] = _get_del_time_range_btn(server_nb, name, ip_set_name, jour, horaire)
            if middle/2 == (middle-1)/2:
                btns[middle-1] = 'void'
            else:
                btns[middle+1] = 'void'
        if horaires == []:
            libelle += "<br />la navigation web est interdite toute la journée"
        jours_datas[jour] = (closed_hours, btns, libelle)


    set_name = {'name':'ip_set_name', 'default_value':ip_set_name}
    start_hours = time_manager.get_hours()
    end_hours = time_manager.get_hours()
    days = time_manager.get_days()

    tstart_select = {'name':'tstart',
                     'libelle':'Début de plage',
                     'options':[{'name':'debut', 'options':start_hours}]}

    tstop_select = {'name':'tstop',
                    'libelle':'Fin de plage',
                    'options':[{'name':'fin', 'options':end_hours}]}

    days_select = {'name':'day',
                   'libelle':"Choix du (des jours)",
                   'options':[{'name':'', 'options':days}],
                    'multi':'ok',
                    'size':'7'}

    return dict(ip_set_name_input=set_name,
                msgs=("Navigation interdite", "Navigation autorisée"),
                tstart_select=tstart_select,
                tstop_select=tstop_select,
                days_select=days_select,
                time_range_table=get_time_range_table(),
                jours_datas=jours_datas,
                jours=time_manager.get_days_list(),
                )

def _get_del_time_range_btn(server_nb, name, ip_set_name, jour, plage):
    """ renvoie la description du bouton de suppression de plage horaire """
    icone = "/image/supprimer.gif"
    href = tools.make_js_link(server_nb, name,
                              confirm=False,
                              balise='ip_set_time_range_msg',
                              todel="%s#%s#%s"%(jour, plage['hdeb'], plage['hfin']),
                              ip_set=ip_set_name
                              )
    libelle = ""
    title = "Supprimer la plage allant de %s au %s le %s"%(plage['hdeb'], plage['hfin'], jour)
    _class = "amon_ip_set_btn"
    return dict(href=href, icone=icone, libelle=libelle, title=title, _class=_class)

def _get_copy_time_range_form(zone, ip_set_name):
    """ renvoie la description du formulaire de copie d'horaire """
    options = [{'libelle':name, 'name':name}for name in group_manager.get_all_groups(zone_indices[zone], attr='name')if name!= ip_set_name]
    ip_set_tocopy = {'name':'ip_set',
                       'libelle': "Copier les horaires d'un autre groupe",
                      'options':[{'name':'groupes existants',
                                    'options':options}]
                      }
    return dict(ip_set_tocopy=ip_set_tocopy)

def _get_group_datas(zone, group):
    """ renvoie les données pour la mise en forme d'un groupe """
    datas = group_manager.get_group(zone_indices[zone], group)
    return datas

def get_time_range_table():
    """ renvoie une table [(0,0), (1,0), (2,0)...(3,0)]"""
    table = [('0', '0')]
    for i in range(1, 9):
        table.append((str(i)+'h',str(0)))
    table.append(('9h', '1'))

    for i in range(0,9):
        table.append((str(i)+'h',str(1)))
    table.append(('9h', '2'))

    for i in range(3):
        table.append((str(i)+'h',str(2)))
    table.append(('3h', '0'))
    return table

def set_time_range(zone, ip_set_name, resultat):
    """
        définit une plage horaire
    """
    jours = resultat['day']
    hdeb = resultat['tstart']
    hfin = resultat['tstop']
    message = "Configuration de plage horaire:\\nLa navigation web sera autorisée entre %s et %s\\n"%(hdeb, hfin)
    if not group_manager.is_group(zone_indices[zone], ip_set_name):
        raise Exception, "Le groupe %s n'existe pas." % ip_set_name
    for jour in jours:
        if jour in time_manager.get_days_list():
            try:
                time_manager.add_schedule(zone_indices[zone], ip_set_name, jour, hdeb, hfin)
                message += "le %s\\n"%jour
            except Exception, mess:
                message += "le %s:\\n     "%jour
                message += mess.message
                message += "\\n"

    # si le groupe est actif et les horaires sont actifs, la modif influe sur les règles iptables
    if _get_group_datas(zone, ip_set_name)['active'] == '1' and _get_group_datas(zone, ip_set_name)['time'] == '1':
        set_iptables_rules()
    return dict(message=message)

def copy_time_range(zone, group, resultat):
    """ copie les plages horaires d'un groupe à un autre """
    group_to_copy_from = resultat['ip_set']
    time_manager.copy_schedules(zone_indices[zone], group_to_copy_from, group)
    message = "Les plages horaires du groupe %s ont été associées au groupe %s.\\n"%(group_to_copy_from, group)
    if _get_group_datas(zone, group)['active'] == '1' and _get_group_datas(zone, group)['time'] == '1':
        set_iptables_rules()
    return dict(message = message)

def del_time_range(zone, group, schedule):
    """ valide la suppression d'une plage horaire
        on recoit:
        @group: nom de l'ip_set
        @schedule: jour#heurededebut#heuredefin
    """
    plage = schedule.split('#')
    time_manager.del_schedule(zone_indices[zone], group, plage[0], plage[1], plage[2])

    # si le groupe est actif et les horaires sont actifs, la modif influe sur les règles iptables
    if _get_group_datas(zone, group)['active'] == '1' and _get_group_datas(zone, group)['time'] == '1':
        set_iptables_rules()
    return dict(message = "La plage horaire du %s de %s à %s a été annulée."%(plage[0], plage[1], plage[2]))

